/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4Ctoh;
import oracle.sql.TIMESTAMP;

class T4CTTIaqm
implements Diagnosable {
    private static final String CLASS_NAME = T4CTTIaqm.class.getName();
    static final int ATTR_ORIGINAL_MSGID = 69;
    static final byte ATTR_AGENT_NAME = 64;
    static final byte ATTR_AGENT_ADDRESS = 65;
    static final byte ATTR_AGENT_PROTOCOL = 66;
    static final int AQM_MSG_NO_DELAY = 0;
    static final int AQM_MSG_NO_EXPIRATION = -1;
    static final int AQM_MSGPROP_CORRID_SIZE = 128;
    int aqmpri;
    int aqmdel;
    int aqmexp;
    byte[] aqmcorBytes;
    int aqmcorBytesLength;
    int aqmatt;
    byte[] aqmeqnBytes;
    int aqmeqnBytesLength;
    int aqmsta;
    private byte[] aqmeqtBuffer = new byte[7];
    private int[] retInt = new int[1];
    TIMESTAMP aqmeqt;
    byte[] aqmetiBytes;
    byte[] senderAgentName = null;
    int senderAgentNameLength = 0;
    byte[] senderAgentAddress = null;
    int senderAgentAddressLength = 0;
    byte senderAgentProtocol = 0;
    byte[] originalMsgId;
    byte[] aqmuprBytes;
    int aqmuprBytesLength;
    T4Ctoh toh;
    int aqmcsn;
    int aqmdsn;
    int aqmflg;
    int aqmshardNum;
    T4CMAREngine mar;
    T4CConnection connection;

    @Override
    public Diagnosable getDiagnosable() {
        return this.connection.getDiagnosable();
    }

    T4CTTIaqm(T4CConnection _connection, T4Ctoh _toh) {
        this.toh = _toh;
        this.connection = _connection;
        this.mar = this.connection.mare;
    }

    void initToDefaultValues() {
        this.aqmpri = 0;
        this.aqmdel = 0;
        this.aqmexp = -1;
        this.aqmcorBytes = null;
        this.aqmcorBytesLength = 0;
        this.aqmatt = 0;
        this.aqmeqnBytes = null;
        this.aqmeqnBytesLength = 0;
        this.aqmsta = 0;
        this.aqmeqt = null;
        this.aqmetiBytes = null;
        this.aqmuprBytes = null;
        this.aqmuprBytesLength = 0;
        this.senderAgentName = null;
        this.senderAgentNameLength = 0;
        this.senderAgentAddress = null;
        this.senderAgentAddressLength = 0;
        this.senderAgentProtocol = 0;
        this.originalMsgId = null;
        this.aqmcsn = 0;
        this.aqmdsn = 0;
        this.aqmflg = 0;
        this.aqmshardNum = -1;
    }

    void marshal() throws IOException {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshal", "aqmpri={0}, aqmdel={1}, aqmexp={2}, aqmsta={3}", (String)null, (Throwable)null, (Object)this.aqmpri, (Object)this.aqmdel, (Object)this.aqmexp, (Object)this.aqmsta);
        this.mar.marshalSB4(this.aqmpri);
        this.mar.marshalSB4(this.aqmdel);
        this.mar.marshalSB4(this.aqmexp);
        if (this.aqmcorBytes != null && this.aqmcorBytes.length != 0) {
            this.mar.marshalSWORD(this.aqmcorBytes.length);
            this.mar.marshalCLR(this.aqmcorBytes, 0, this.aqmcorBytes.length);
        } else {
            this.mar.marshalSWORD(0);
        }
        this.mar.marshalSB4(0);
        if (this.aqmeqnBytes != null && this.aqmeqnBytes.length != 0) {
            this.mar.marshalSWORD(this.aqmeqnBytes.length);
            this.mar.marshalCLR(this.aqmeqnBytes, 0, this.aqmeqnBytes.length);
        } else {
            this.mar.marshalSWORD(0);
        }
        this.mar.marshalSB4(this.aqmsta);
        this.mar.marshalSWORD(0);
        if (this.connection.getTTCVersion() >= 3) {
            if (this.aqmetiBytes != null && this.aqmetiBytes.length > 0) {
                this.mar.marshalSWORD(this.aqmetiBytes.length);
                this.mar.marshalCLR(this.aqmetiBytes, 0, this.aqmetiBytes.length);
            } else {
                this.mar.marshalSWORD(0);
            }
        }
        int nbExtentions = 4;
        byte[][] extensionTextValues = new byte[nbExtentions][];
        byte[][] extensionBinaryValues = new byte[nbExtentions][];
        int[] extensionKeywords = new int[nbExtentions];
        extensionTextValues[0] = this.senderAgentName;
        extensionBinaryValues[0] = null;
        extensionKeywords[0] = 64;
        extensionTextValues[1] = this.senderAgentAddress;
        extensionBinaryValues[1] = null;
        extensionKeywords[1] = 65;
        extensionTextValues[2] = null;
        extensionBinaryValues[2] = new byte[1];
        extensionBinaryValues[2][0] = this.senderAgentProtocol;
        extensionKeywords[2] = 66;
        extensionTextValues[3] = null;
        extensionBinaryValues[3] = this.originalMsgId;
        extensionKeywords[3] = 69;
        this.mar.marshalSWORD(nbExtentions);
        this.mar.marshalUB1((short)14);
        this.mar.marshalKPDKV(extensionTextValues, extensionBinaryValues, extensionKeywords);
        if (this.connection.getTTCVersion() >= 3) {
            this.mar.marshalUB4(0L);
            this.mar.marshalUB4(0L);
            this.mar.marshalUB4(0L);
            if (this.connection.getTTCVersion() >= 4) {
                this.mar.marshalUB4(0L);
            }
        }
        if (this.connection.getTTCVersion() >= 16) {
            if (this.aqmshardNum != -1) {
                this.mar.marshalUB4(this.aqmshardNum);
            } else {
                this.mar.marshalUB4(65535L);
            }
        }
    }

    void receive() throws SQLException, IOException {
        int nbExtentions;
        this.aqmpri = this.mar.unmarshalSB4();
        this.aqmdel = this.mar.unmarshalSB4();
        this.aqmexp = this.mar.unmarshalSB4();
        int correlationLength = this.mar.unmarshalSWORD();
        if (correlationLength > 0) {
            this.aqmcorBytes = new byte[correlationLength];
            int[] intAr = new int[1];
            this.mar.unmarshalCLR(this.aqmcorBytes, 0, intAr, this.aqmcorBytes.length);
            this.aqmcorBytesLength = intAr[0];
        } else {
            this.aqmcorBytes = null;
        }
        this.aqmatt = this.mar.unmarshalSB4();
        int exceptionQueueLength = this.mar.unmarshalSWORD();
        if (exceptionQueueLength > 0) {
            this.aqmeqnBytes = new byte[exceptionQueueLength];
            int[] intAr = new int[1];
            this.mar.unmarshalCLR(this.aqmeqnBytes, 0, intAr, this.aqmeqnBytes.length);
            this.aqmeqnBytesLength = intAr[0];
        } else {
            this.aqmeqnBytes = null;
        }
        this.aqmsta = this.mar.unmarshalSB4();
        int enqueueTimeLength = this.mar.unmarshalSB4();
        if (enqueueTimeLength > 0) {
            this.mar.unmarshalCLR(this.aqmeqtBuffer, 0, this.retInt, 7);
            this.aqmeqt = new TIMESTAMP(this.aqmeqtBuffer);
        }
        if (this.connection.getTTCVersion() >= 3) {
            int aqmetil = this.mar.unmarshalSWORD();
            if (aqmetil > 0) {
                this.aqmetiBytes = new byte[aqmetil];
                int[] intAr = new int[1];
                this.mar.unmarshalCLR(this.aqmetiBytes, 0, intAr, this.aqmetiBytes.length);
            } else {
                this.aqmetiBytes = null;
            }
        }
        if ((nbExtentions = this.mar.unmarshalSWORD()) > 0) {
            this.mar.unmarshalUB1();
            byte[][] extensionTextValues = new byte[nbExtentions][];
            int[] extensionTextValuesLength = new int[nbExtentions];
            byte[][] extensionBinaryValues = new byte[nbExtentions][];
            int[] extensionKeywords = new int[nbExtentions];
            this.mar.unmarshalKPDKV(extensionTextValues, extensionTextValuesLength, extensionBinaryValues, extensionKeywords);
            for (int i = 0; i < nbExtentions; ++i) {
                if (extensionKeywords[i] == 64 && extensionTextValues[i] != null && extensionTextValuesLength[i] > 0) {
                    this.senderAgentName = extensionTextValues[i];
                    this.senderAgentNameLength = extensionTextValuesLength[i];
                }
                if (extensionKeywords[i] == 65 && extensionTextValues[i] != null && extensionTextValuesLength[i] > 0) {
                    this.senderAgentAddress = extensionTextValues[i];
                    this.senderAgentAddressLength = extensionTextValuesLength[i];
                }
                if (extensionKeywords[i] == 66 && extensionBinaryValues[i] != null && extensionBinaryValues[i].length > 0) {
                    this.senderAgentProtocol = extensionBinaryValues[i][0];
                }
                if (extensionKeywords[i] != 69 || extensionBinaryValues[i] == null || extensionBinaryValues[i].length <= 0) continue;
                this.originalMsgId = extensionBinaryValues[i];
            }
        }
        if (this.connection.getTTCVersion() >= 3) {
            int aqmuprl = this.mar.unmarshalSWORD();
            if (aqmuprl > 0) {
                if (aqmuprl > 1) {
                    throw new SQLException("Unexpected user properties length " + aqmuprl);
                }
                T4Ctoh toh2 = new T4Ctoh(this.connection);
                toh2.unmarshal(this.mar);
                int lengthOfPayload = toh2.imageLength;
                this.aqmuprBytes = new byte[lengthOfPayload];
                int[] intAr = new int[1];
                this.mar.unmarshalCLR(this.aqmuprBytes, 0, intAr, this.aqmuprBytes.length);
                this.aqmuprBytesLength = intAr[0];
            }
            this.aqmcsn = (int)this.mar.unmarshalUB4();
            this.aqmdsn = (int)this.mar.unmarshalUB4();
            if (this.connection.getTTCVersion() >= 4) {
                this.aqmflg = (int)this.mar.unmarshalUB4();
            }
        }
        if (this.connection.getTTCVersion() >= 16) {
            this.aqmshardNum = (int)this.mar.unmarshalUB4();
        }
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "reveive", "aqmpri={0}, aqmdel={1}, aqmexp={2}, aqmatt={3}, aqmsta={4}, aqmcsn={5}, aqmdsn={6}", (String)null, (Throwable)null, (Object)this.aqmpri, (Object)this.aqmdel, (Object)this.aqmexp, (Object)this.aqmatt, (Object)this.aqmsta, (Object)this.aqmcsn, (Object)this.aqmdsn);
    }
}

