/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.OracleTimeoutThreadPerVM;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.Monitor;

class OracleTimeoutPollingThread
extends Thread
implements Monitor,
Diagnosable {
    private static final String CLASS_NAME = OracleTimeoutPollingThread.class.getName();
    protected static final String threadName = "OracleTimeoutPollingThread";
    public static final String pollIntervalProperty = "oracle.jdbc.TimeoutPollInterval";
    public static final String pollIntervalDefault = "1000";
    private OracleTimeoutThreadPerVM[] knownTimeouts;
    private int count;
    private long sleepMillis;
    private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();

    public OracleTimeoutPollingThread() {
        super(threadName);
        this.setDaemon(true);
        this.setPriority(10);
        this.knownTimeouts = new OracleTimeoutThreadPerVM[2];
        this.count = 0;
        this.sleepMillis = Long.parseLong(PhysicalConnection.getSystemPropertyPollInterval());
        this.start();
    }

    public void addTimeout(OracleTimeoutThreadPerVM t) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int i = 0;
            if (this.count >= this.knownTimeouts.length) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "addTimeout", "growing knownTimeouts--new size = {0}", (String)null, (Throwable)null, (Object)(this.knownTimeouts.length * 4));
                OracleTimeoutThreadPerVM[] bigger = new OracleTimeoutThreadPerVM[this.knownTimeouts.length * 4];
                System.arraycopy(this.knownTimeouts, 0, bigger, 0, this.knownTimeouts.length);
                i = this.knownTimeouts.length;
                this.knownTimeouts = bigger;
            }
            while (i < this.knownTimeouts.length) {
                if (this.knownTimeouts[i] == null) {
                    this.knownTimeouts[i] = t;
                    ++this.count;
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "addTimeout", "added at {0}", (String)null, (Throwable)null, (Object)i);
                    break;
                }
                ++i;
            }
        }
    }

    public void removeTimeout(OracleTimeoutThreadPerVM t) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            for (int i = 0; i < this.knownTimeouts.length; ++i) {
                if (this.knownTimeouts[i] != t) continue;
                this.knownTimeouts[i] = null;
                --this.count;
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "removeTimeout", "removed from {0}", (String)null, (Throwable)null, (Object)i);
                break;
            }
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(this.sleepMillis);
            }
            catch (InterruptedException e) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "run", "OracleTimeoutPollingThread Interrupted. Stop. ", null, null);
                return;
            }
            this.pollOnce();
        }
    }

    private void pollOnce() {
        if (this.count > 0) {
            long now = System.currentTimeMillis();
            for (int i = 0; i < this.knownTimeouts.length; ++i) {
                try {
                    if (this.knownTimeouts[i] == null) continue;
                    this.knownTimeouts[i].interruptIfAppropriate(now);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }
}

