/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.db.postgres.embedded;

import com.opentable.db.postgres.embedded.DatabasePreparer;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.internal.configuration.ConfigUtils;

public final class FlywayPreparer
implements DatabasePreparer {
    private final List<String> locations;
    private final Map<String, String> flywayConfiguration;

    public static FlywayPreparer forClasspathLocation(String ... locations) {
        return new FlywayPreparer(Arrays.asList(locations), new HashMap<String, String>());
    }

    public static FlywayPreparer forClasspathLocation(Map<String, String> flywayConfiguration, String ... locations) {
        return new FlywayPreparer(Arrays.asList(locations), flywayConfiguration);
    }

    private FlywayPreparer(List<String> locations, Map<String, String> flywayConfiguration) {
        this.locations = locations;
        this.flywayConfiguration = flywayConfiguration;
    }

    @Override
    public void prepare(DataSource ds) throws SQLException {
        Map fromClassPath;
        try (InputStream inputStream = FlywayPreparer.class.getResourceAsStream("/flyway.properties");){
            fromClassPath = ConfigUtils.loadConfigurationFromInputStream((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        this.flywayConfiguration.putAll(this.flywayConfiguration);
        Flyway.configure().configuration(fromClassPath).envVars().configuration(this.flywayConfiguration).locations(this.locations.toArray(new String[0])).dataSource(ds).load().migrate();
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlywayPreparer that = (FlywayPreparer)o;
        return Objects.equals(this.locations, that.locations) && Objects.equals(this.flywayConfiguration, that.flywayConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.locations, this.flywayConfiguration);
    }
}

