/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.text.MessageFormat;

class DLLException
extends Exception {
    private static final long serialVersionUID = -4498171382218222079L;
    private int category = -9;
    private int status = -9;
    private int state = -9;
    private int errCode = -1;
    private String param1 = "";
    private String param2 = "";
    private String param3 = "";

    DLLException(String message, int category, int status, int state) {
        super(message);
        this.category = category;
        this.status = status;
        this.state = state;
    }

    DLLException(String param1, String param2, String param3, int errCode) {
        this.errCode = errCode;
        this.param1 = param1;
        this.param2 = param2;
        this.param3 = param3;
    }

    int GetCategory() {
        return this.category;
    }

    int GetStatus() {
        return this.status;
    }

    int GetState() {
        return this.state;
    }

    int GetErrCode() {
        return this.errCode;
    }

    String GetParam1() {
        return this.param1;
    }

    String GetParam2() {
        return this.param2;
    }

    String GetParam3() {
        return this.param3;
    }

    static void buildException(int errCode, String param1, String param2, String param3) throws SQLServerException {
        String errMessage = DLLException.getErrMessage(errCode);
        MessageFormat form = new MessageFormat(SQLServerException.getErrString(errMessage));
        String[] msgArgs = DLLException.buildMsgParams(errMessage, param1, param2, param3);
        throw new SQLServerException(null, form.format(msgArgs), null, 0, false);
    }

    private static String[] buildMsgParams(String errMessage, String parameter1, String parameter2, String parameter3) {
        String[] msgArgs = new String[3];
        if ("R_AECertLocBad".equalsIgnoreCase(errMessage)) {
            msgArgs[0] = parameter1;
            msgArgs[1] = parameter1 + "/" + parameter2 + "/" + parameter3;
        } else if ("R_AECertStoreBad".equalsIgnoreCase(errMessage)) {
            msgArgs[0] = parameter2;
            msgArgs[1] = parameter1 + "/" + parameter2 + "/" + parameter3;
        } else if ("R_AECertHashEmpty".equalsIgnoreCase(errMessage)) {
            msgArgs[0] = parameter1 + "/" + parameter2 + "/" + parameter3;
        } else {
            msgArgs[0] = parameter1;
            msgArgs[1] = parameter2;
            msgArgs[2] = parameter3;
        }
        return msgArgs;
    }

    private static String getErrMessage(int errCode) {
        return switch (errCode) {
            case 1 -> "R_AEKeypathEmpty";
            case 2 -> "R_EncryptedCEKNull";
            case 3 -> "R_NullKeyEncryptionAlgorithm";
            case 4 -> "R_AEWinApiErr";
            case 5 -> "R_AECertpathBad";
            case 6 -> "R_AECertLocBad";
            case 7 -> "R_AECertStoreBad";
            case 8 -> "R_AECertHashEmpty";
            case 9 -> "R_AECertNotFound";
            case 10 -> "R_AEMaloc";
            case 11 -> "R_EmptyEncryptedCEK";
            case 12 -> "R_InvalidKeyEncryptionAlgorithm";
            case 13 -> "R_AEKeypathLong";
            case 14 -> "R_InvalidEcryptionAlgorithmVersion";
            case 15 -> "R_AEECEKLenBad";
            case 16 -> "R_AEECEKSigLenBad";
            case 17 -> "R_InvalidCertificateSignature";
            default -> "R_AEWinApiErr";
        };
    }
}

