/*
 * Decompiled with CFR 0.152.
 */
package com.jgeppert.struts2.jquery.components;

import com.jgeppert.struts2.jquery.components.AbstractTopicsBean;
import com.opensymphony.xwork2.util.ValueStack;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.util.MakeIterator;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.annotations.StrutsTagSkipInheritance;

@StrutsTag(name="accordion", tldTagClass="com.jgeppert.struts2.jquery.views.jsp.ui.AccordionTag", description="Render an accordion from a List.")
public class Accordion
extends AbstractTopicsBean {
    private static final transient Random RANDOM = new Random();
    public static final String JQUERYACTION = "accordion";
    public static final String TEMPLATE = "accordion";
    public static final String TEMPLATE_CLOSE = "accordion-close";
    public static final String COMPONENT_NAME = Accordion.class.getName();
    protected boolean throwExceptionOnNullValueAttribute = false;
    protected String active;
    protected String animate;
    protected String heightStyle;
    protected String collapsible;
    protected String header;
    protected String openOnMouseover;
    protected String href;
    protected String paramKeys;
    protected String paramValues;
    protected Object list;
    protected String listKey;
    protected String listValue;

    public Accordion(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    public String getDefaultOpenTemplate() {
        return "accordion";
    }

    protected String getDefaultTemplate() {
        return TEMPLATE_CLOSE;
    }

    public void evaluateExtraParams() {
        super.evaluateExtraParams();
        this.addParameter("jqueryaction", "accordion");
        if (this.active != null) {
            this.addParameter("active", this.findString(this.active));
        }
        if (this.animate != null) {
            this.addParameter("animate", this.findString(this.animate));
        }
        if (this.heightStyle != null) {
            this.addParameter("heightStyle", this.findString(this.heightStyle));
        }
        if (this.collapsible != null) {
            this.addParameter("collapsible", this.findValue(this.collapsible, Boolean.class));
        }
        if (this.header != null) {
            this.addParameter("header", this.findString(this.header));
        }
        if (this.openOnMouseover != null) {
            this.addParameter("openOnMouseover", this.findValue(this.openOnMouseover, Boolean.class));
        }
        if (this.href != null) {
            this.addParameter("href", this.findString(this.href));
        }
        if (this.paramKeys != null) {
            this.addParameter("paramKeys", this.findString(this.paramKeys));
        }
        if (this.paramValues != null) {
            this.addParameter("paramValues", this.findString(this.paramValues));
        }
        Object value = null;
        if (this.list == null) {
            this.list = this.parameters.get("list");
        }
        if (this.list instanceof String) {
            value = this.findValue((String)this.list);
        } else if (this.list instanceof Collection) {
            value = this.list;
        } else if (MakeIterator.isIterable((Object)this.list)) {
            value = MakeIterator.convert((Object)this.list);
        }
        if (value == null) {
            value = this.throwExceptionOnNullValueAttribute ? this.findValue(this.list == null ? (String)this.list : this.list.toString(), "list", "The requested list key '" + this.list + "' could not be resolved as a collection/array/map/enumeration/iterator type. " + "Example: people or people.{name}") : this.findValue(this.list == null ? (String)this.list : this.list.toString());
        }
        if (value instanceof Collection) {
            this.addParameter("list", value);
        } else {
            this.addParameter("list", MakeIterator.convert((Object)value));
        }
        if (value instanceof Collection) {
            this.addParameter("listSize", ((Collection)value).size());
        } else if (value instanceof Map) {
            this.addParameter("listSize", ((Map)value).size());
        } else if (value != null && value.getClass().isArray()) {
            this.addParameter("listSize", Array.getLength(value));
        }
        if (this.listKey != null) {
            this.listKey = this.stripExpressionIfAltSyntax(this.listKey);
            this.addParameter("listKey", this.listKey);
        } else if (value instanceof Map) {
            this.addParameter("listKey", "key");
        }
        if (this.listValue != null) {
            this.listValue = this.stripExpressionIfAltSyntax(this.listValue);
            this.addParameter("listValue", this.listValue);
        } else if (value instanceof Map) {
            this.addParameter("listValue", "value");
        }
        if (this.id == null || this.id.length() == 0) {
            int nextInt = RANDOM.nextInt();
            nextInt = nextInt == Integer.MIN_VALUE ? Integer.MAX_VALUE : Math.abs(nextInt);
            this.id = "accordion_" + String.valueOf(nextInt);
            this.addParameter("id", this.id);
        }
    }

    @StrutsTagSkipInheritance
    public void setTheme(String theme) {
        super.setTheme(theme);
    }

    public String getTheme() {
        return "jquery";
    }

    @StrutsTagAttribute(description="Selector for the active element. Set to false to display none at start. Needs collapsible: true.  Default: 0")
    public void setActive(String active) {
        this.active = active;
    }

    @StrutsTagAttribute(description="If and how to animate changing panels. Can be Boolean, Number, String (Escaped with simple ' sign) or JavaScript Object", defaultValue="false")
    public void setAnimate(String animate) {
        this.animate = animate;
    }

    @StrutsTagAttribute(description="Controls the height of the accordion and each panel. Possible values 'auto': All panels will be set to the height of the tallest panel, 'content': Each panel will be only as tall as its content, 'fill': Expand to the available height based on the accordion's parent height.", defaultValue="auto")
    public void setHeightStyle(String heightStyle) {
        this.heightStyle = heightStyle;
    }

    @StrutsTagAttribute(description="Whether all the sections can be closed at once. Allows collapsing the active section by the triggering event. Default: false", defaultValue="false", type="Boolean")
    public void setCollapsible(String collapsible) {
        this.collapsible = collapsible;
    }

    @StrutsTagAttribute(description="Selector for the header element. Default: h3", defaultValue="h3")
    public void setHeader(String header) {
        this.header = header;
    }

    public String getHeader() {
        return this.header;
    }

    @StrutsTagAttribute(description="open accordion on mouse over event. Default: false", defaultValue="false", type="Boolean")
    public void setOpenOnMouseover(String openOnMouseover) {
        this.openOnMouseover = openOnMouseover;
    }

    @StrutsTagAttribute(description="Iterable source to populate from. If the list is a Map (key, value), the Map key will become the option 'value' parameter and the Map value will become the option body.")
    public void setList(Object list) {
        this.list = list;
    }

    @StrutsTagAttribute(description="Property of list objects to get field value from")
    public void setListKey(String listKey) {
        this.listKey = listKey;
    }

    @StrutsTagAttribute(description="Property of list objects to get field content from")
    public void setListValue(String listValue) {
        this.listValue = listValue;
    }

    @StrutsTagAttribute(description="The URL to call to obtain the content. Note: If used with ajax context, the value must be set as an url tag value.")
    public void setHref(String href) {
        this.href = href;
    }

    @StrutsTagAttribute(description="Comma seperated List of parameter names for the href url. e.g. queryParam1,queryParam2")
    public void setParamKeys(String paramKeys) {
        this.paramKeys = paramKeys;
    }

    @StrutsTagAttribute(description="Comma seperated List of List Keys for parameter values. e.g. queryValue1,queryValue2")
    public void setParamValues(String paramValues) {
        this.paramValues = paramValues;
    }
}

