/*
 * Decompiled with CFR 0.152.
 */
package com.jgeppert.struts2.jquery.components;

import com.jgeppert.struts2.jquery.components.AbstractRemoteBean;
import com.jgeppert.struts2.jquery.components.ButtonBean;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.annotations.StrutsTagSkipInheritance;

@StrutsTag(name="a", tldTagClass="com.jgeppert.struts2.jquery.views.jsp.ui.AnchorTag", description="Renders an HTML anchor element that when clicked calls a URL via remote XMLHttpRequest and updates its targets content", allowDynamicAttributes=true)
public class Anchor
extends AbstractRemoteBean
implements ButtonBean {
    public static final String TEMPLATE = "a";
    public static final String TEMPLATE_CLOSE = "a-close";
    public static final String COMPONENT_NAME = Anchor.class.getName();
    public static final transient Random RANDOM = new Random();
    public static final String JQUERYACTION = "anchor";
    protected String openDialog;
    protected String onClickTopics;
    protected String validate;
    protected String validateFunction;
    protected String button;
    protected String buttonIcon;
    protected String buttonIconSecondary;
    protected String buttonText;

    public Anchor(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    public String getDefaultOpenTemplate() {
        return TEMPLATE;
    }

    protected String getDefaultTemplate() {
        return TEMPLATE_CLOSE;
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }

    public void evaluateExtraParams() {
        super.evaluateExtraParams();
        this.addParameter("jqueryaction", JQUERYACTION);
        if (this.openDialog != null) {
            this.addParameter("openDialog", this.findString(this.openDialog));
        }
        if (this.onClickTopics != null) {
            this.addParameter("onClickTopics", this.findString(this.onClickTopics));
        }
        if (this.button != null) {
            this.addParameter("button", this.findValue(this.button, Boolean.class));
        }
        if (this.buttonIcon != null) {
            this.addParameter("buttonIcon", this.findString(this.buttonIcon));
        }
        if (this.buttonIconSecondary != null) {
            this.addParameter("buttonIconSecondary", this.findString(this.buttonIconSecondary));
        }
        if (this.buttonText != null) {
            this.addParameter("buttonText", this.findValue(this.buttonText, Boolean.class));
        }
        if (this.validate != null) {
            this.addParameter("validate", this.findValue(this.validate, Boolean.class));
        }
        if (this.validateFunction != null) {
            this.addParameter("validateFunction", this.findString(this.validateFunction));
        }
        if (this.id == null || this.id.length() == 0) {
            int nextInt = RANDOM.nextInt();
            nextInt = nextInt == Integer.MIN_VALUE ? Integer.MAX_VALUE : Math.abs(nextInt);
            this.id = "anchor_" + String.valueOf(nextInt);
            this.addParameter("id", this.id);
        }
    }

    @StrutsTagSkipInheritance
    public void setTheme(String theme) {
        super.setTheme(theme);
    }

    public String getTheme() {
        return "jquery";
    }

    @StrutsTagAttribute(description="id of dialog that will be opened when clicked.")
    public void setOpenDialog(String openDialog) {
        this.openDialog = openDialog;
    }

    @StrutsTagAttribute(name="onClickTopics", description="A comma delimited list of topics that published when the element is clicked", type="String", defaultValue="")
    public void setOnClickTopics(String onClickTopics) {
        this.onClickTopics = onClickTopics;
    }

    @StrutsTagAttribute(description="jQuery UI Button", defaultValue="false", type="Boolean")
    public void setButton(String button) {
        this.button = button;
    }

    @StrutsTagAttribute(description="Icons to display. The primary icon is displayed on the left of the label text. Value must be a classname (String), eg. ui-icon-gear.")
    public void setButtonIcon(String buttonIcon) {
        this.buttonIcon = buttonIcon;
    }

    @StrutsTagAttribute(description="Icons to display. The secondary icon is displayed on the right of the label text. Value must be a classname (String), eg. ui-icon-gear.")
    public void setButtonIconSecondary(String buttonIconSecondary) {
        this.buttonIconSecondary = buttonIconSecondary;
    }

    @StrutsTagAttribute(description="Whether to show any text - when set to false (display no text), icons (see icons option) must be enabled, otherwise it'll be ignored.", defaultValue="true", type="Boolean")
    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    @StrutsTagAttribute(description="A function that handle the client validation result. eg.: myValidation(form, errors)")
    public void setValidateFunction(String validateFunction) {
        this.validateFunction = validateFunction;
    }

    @StrutsTagAttribute(description="Enable client AJAX validation", defaultValue="false", type="Boolean")
    public void setValidate(String validate) {
        this.validate = validate;
    }
}

