/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.shared.access.sqlite;

import com.amazonaws.services.dynamodbv2.local.shared.access.sqlite.SQLiteIndexElement;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TableSchemaInfo {
    private List<AttributeDefinition> attributes = null;
    private List<LocalSecondaryIndex> lsiList = null;
    private Map<String, List<SQLiteIndexElement>> sqliteIndex = null;
    private List<SQLiteIndexElement> uniqueIndexes = null;

    @JsonProperty(value="Attributes")
    public List<AttributeDefinition> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="Attributes")
    public void setAttributes(List<AttributeDefinition> attributes) {
        this.attributes = attributes;
    }

    @JsonProperty(value="LSIList")
    public List<LocalSecondaryIndex> getLsiList() {
        return this.lsiList;
    }

    @JsonProperty(value="LSIList")
    public void setLsiList(List<LocalSecondaryIndex> lsiList) {
        this.lsiList = lsiList;
    }

    @JsonProperty(value="SQLiteIndex")
    public Map<String, List<SQLiteIndexElement>> getSqliteIndex() {
        return this.sqliteIndex;
    }

    @JsonProperty(value="SQLiteIndex")
    public void setSqliteIndex(Map<String, List<SQLiteIndexElement>> sqliteIndex) {
        this.sqliteIndex = sqliteIndex;
    }

    @JsonProperty(value="UniqueIndexes")
    public List<SQLiteIndexElement> getUniqueIndexes() {
        return this.uniqueIndexes;
    }

    @JsonProperty(value="UniqueIndexes")
    public void setUniqueIndexes(List<SQLiteIndexElement> uniqueIndexes) {
        this.uniqueIndexes = uniqueIndexes;
    }

    public TableSchemaInfo() {
    }

    @JsonIgnore
    public TableSchemaInfo(AttributeDefinition hashKeyDef, AttributeDefinition rangeKeyDef, List<AttributeDefinition> attributes, List<LocalSecondaryIndex> lsiList) {
        this.attributes = attributes;
        this.lsiList = lsiList;
        this.uniqueIndexes = new ArrayList<SQLiteIndexElement>();
        this.sqliteIndex = new HashMap<String, List<SQLiteIndexElement>>();
        ArrayList<SQLiteIndexElement> primaryIndexes = new ArrayList<SQLiteIndexElement>();
        SQLiteIndexElement hashKeyIndex = new SQLiteIndexElement(KeyType.HASH, hashKeyDef, "hashKey");
        primaryIndexes.add(hashKeyIndex);
        this.uniqueIndexes.add(hashKeyIndex);
        if (rangeKeyDef != null) {
            SQLiteIndexElement rangeKeyIndex = new SQLiteIndexElement(KeyType.RANGE, rangeKeyDef, "rangeKey");
            primaryIndexes.add(rangeKeyIndex);
            this.uniqueIndexes.add(rangeKeyIndex);
        }
        this.sqliteIndex.put("", primaryIndexes);
        if (lsiList != null) {
            HashMap<String, String> sqliteColumnName = new HashMap<String, String>();
            sqliteColumnName.put(rangeKeyDef.getAttributeName(), "rangeKey");
            HashMap<String, AttributeDefinition> nameToDefinition = new HashMap<String, AttributeDefinition>();
            for (AttributeDefinition attributeDefinition : attributes) {
                nameToDefinition.put(attributeDefinition.getAttributeName(), attributeDefinition);
            }
            int count = 0;
            for (LocalSecondaryIndex lsi : lsiList) {
                boolean isNewIndex = false;
                ArrayList<SQLiteIndexElement> lsiIndexes = new ArrayList<SQLiteIndexElement>();
                String lsiIndexName = lsi.getIndexName();
                AttributeDefinition lsiRangeKeyDef = (AttributeDefinition)nameToDefinition.get(((KeySchemaElement)lsi.getKeySchema().get(1)).getAttributeName());
                String columnName = (String)sqliteColumnName.get(lsiRangeKeyDef.getAttributeName());
                if (columnName == null) {
                    columnName = "lsiRangeKey_" + count;
                    ++count;
                    isNewIndex = true;
                }
                lsiIndexes.add(hashKeyIndex);
                SQLiteIndexElement lsiRangeKeyIndex = new SQLiteIndexElement(KeyType.RANGE, lsiRangeKeyDef, columnName);
                lsiIndexes.add(lsiRangeKeyIndex);
                if (isNewIndex) {
                    this.uniqueIndexes.add(lsiRangeKeyIndex);
                }
                sqliteColumnName.put(lsiRangeKeyDef.getAttributeName(), columnName);
                this.sqliteIndex.put(lsiIndexName, lsiIndexes);
            }
        }
    }

    @JsonIgnore
    public SQLiteIndexElement getHashKeyIndex() {
        return this.sqliteIndex.get("").get(0);
    }

    @JsonIgnore
    public AttributeDefinition getHashKeyDefinition() {
        return this.getHashKeyIndex().getDynamoDBAttribute();
    }

    @JsonIgnore
    public SQLiteIndexElement getRangeKeyIndex() {
        if (this.sqliteIndex.get("").size() == 2) {
            return this.sqliteIndex.get("").get(1);
        }
        return null;
    }

    @JsonIgnore
    public AttributeDefinition getRangeKeyDefinition() {
        SQLiteIndexElement index = this.getRangeKeyIndex();
        if (index != null) {
            return index.getDynamoDBAttribute();
        }
        return null;
    }

    @JsonIgnore
    public SQLiteIndexElement getLSIRangeIndexElement(String indexName) {
        List<SQLiteIndexElement> indexes = this.sqliteIndex.get(indexName);
        if (indexes == null) {
            return null;
        }
        return indexes.get(1);
    }

    public String toString() {
        String ret = "";
        for (String k : this.sqliteIndex.keySet()) {
            ret = String.valueOf(ret) + k + "\n";
            for (SQLiteIndexElement e : this.sqliteIndex.get(k)) {
                ret = String.valueOf(ret) + "\t" + e.toString() + "\n";
            }
        }
        return ret;
    }
}

