/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase01generatesources;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.AbstractScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateSourcesMojo
extends AbstractAndroidMojo {
    protected boolean deleteConflictingFiles;
    protected File genDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isCurrentProjectAndroid()) {
            return;
        }
        try {
            this.extractSourceDependencies();
            this.extractApkLibDependencies();
            final String[] relativeAidlFileNames1 = this.findRelativeAidlFileNames(this.sourceDirectory);
            final String[] relativeAidlFileNames2 = this.findRelativeAidlFileNames(this.extractedDependenciesJavaSources);
            final HashMap<String, String[]> relativeApklibAidlFileNames = new HashMap<String, String[]>();
            for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
                if (!artifact.getType().equals("apklib")) continue;
                String[] apklibAidlFiles = this.findRelativeAidlFileNames(new File(this.getLibraryUnpackDirectory(artifact) + "/src"));
                relativeApklibAidlFileNames.put(artifact.getArtifactId(), apklibAidlFiles);
            }
            HashSet<String> relativeAidlFileNamesSet = new HashSet<String>(){
                {
                    this.addAll(Arrays.asList(relativeAidlFileNames1));
                    this.addAll(Arrays.asList(relativeAidlFileNames2));
                    for (String[] apklibAidlFiles : relativeApklibAidlFileNames.values()) {
                        this.addAll(Arrays.asList(apklibAidlFiles));
                    }
                }
            };
            if (this.deleteConflictingFiles) {
                this.deleteConflictingRJavaFiles(this.sourceDirectory);
                this.deleteConflictingManifestJavaFiles(this.sourceDirectory);
                this.deleteConflictingThumbsDb(this.resourceDirectory);
                this.deleteConflictingAidlJavaFiles(this.sourceDirectory, (Collection<String>)relativeAidlFileNamesSet);
                this.deleteConflictingAidlJavaFiles(this.extractedDependenciesJavaSources, (Collection<String>)relativeAidlFileNamesSet);
                for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
                    if (!artifact.getType().equals("apklib")) continue;
                    this.deleteConflictingAidlJavaFiles(new File(this.getLibraryUnpackDirectory(artifact) + "/src/main/java"), (Collection<String>)relativeAidlFileNamesSet);
                }
            }
            this.generateR();
            this.generateApklibR();
            HashMap<File, String[]> files = new HashMap<File, String[]>();
            files.put(this.sourceDirectory, relativeAidlFileNames1);
            files.put(this.extractedDependenciesJavaSources, relativeAidlFileNames2);
            for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
                if (!artifact.getType().equals("apklib")) continue;
                files.put(new File(this.getLibraryUnpackDirectory(artifact) + "/src"), (String[])relativeApklibAidlFileNames.get(artifact.getArtifactId()));
            }
            this.generateAidlFiles(files);
        }
        catch (MojoExecutionException e) {
            this.getLog().error((CharSequence)"Error when generating sources.", (Throwable)e);
            throw e;
        }
    }

    protected void extractSourceDependencies() throws MojoExecutionException {
        for (Artifact artifact : this.getRelevantDependencyArtifacts()) {
            String type = artifact.getType();
            if (!type.equals("apksources")) continue;
            this.getLog().debug((CharSequence)("Detected apksources dependency " + artifact + " with file " + artifact.getFile() + ". Will resolve and extract..."));
            File apksourcesFile = new File(this.getLocalRepository().getBasedir(), this.getLocalRepository().pathOf(artifact));
            if (!apksourcesFile.exists()) {
                apksourcesFile = this.resolveArtifactToFile(artifact);
            }
            if (apksourcesFile.isDirectory()) {
                apksourcesFile = this.resolveArtifactToFile(artifact);
            }
            this.getLog().debug((CharSequence)("Extracting " + apksourcesFile + "..."));
            this.extractApksources(apksourcesFile);
        }
        this.projectHelper.addResource(this.project, this.extractedDependenciesJavaResources.getAbsolutePath(), null, null);
        this.project.addCompileSourceRoot(this.extractedDependenciesJavaSources.getAbsolutePath());
    }

    private void extractApksources(File apksourcesFile) throws MojoExecutionException {
        if (apksourcesFile.isDirectory()) {
            this.getLog().warn((CharSequence)("The apksources artifact points to '" + apksourcesFile + "' which is a directory; skipping unpacking it."));
            return;
        }
        ZipUnArchiver unArchiver = new ZipUnArchiver(apksourcesFile){

            protected Logger getLogger() {
                return new ConsoleLogger(0, "dependencies-unarchiver");
            }
        };
        this.extractedDependenciesDirectory.mkdirs();
        unArchiver.setDestDirectory(this.extractedDependenciesDirectory);
        try {
            unArchiver.extract();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while extracting " + apksourcesFile.getAbsolutePath() + ". Message: " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    private void extractApkLibDependencies() throws MojoExecutionException {
        for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
            String type = artifact.getType();
            if (!type.equals("apklib")) continue;
            this.getLog().debug((CharSequence)("Extracting apklib " + artifact.getArtifactId() + "..."));
            this.extractApklib(artifact);
        }
    }

    private void extractApklib(Artifact apklibArtifact) throws MojoExecutionException {
        File apkLibFile = new File(this.getLocalRepository().getBasedir(), this.getLocalRepository().pathOf(apklibArtifact));
        if (!apkLibFile.exists()) {
            apkLibFile = this.resolveArtifactToFile(apklibArtifact);
        }
        if (apkLibFile.isDirectory()) {
            apkLibFile = this.resolveArtifactToFile(apklibArtifact);
        }
        if (apkLibFile.isDirectory()) {
            this.getLog().warn((CharSequence)("The apklib artifact points to '" + apkLibFile + "' which is a directory; skipping unpacking it."));
            return;
        }
        ZipUnArchiver unArchiver = new ZipUnArchiver(apkLibFile){

            protected Logger getLogger() {
                return new ConsoleLogger(0, "dependencies-unarchiver");
            }
        };
        File apklibDirectory = new File(this.getLibraryUnpackDirectory(apklibArtifact));
        apklibDirectory.mkdirs();
        unArchiver.setDestDirectory(apklibDirectory);
        try {
            unArchiver.extract();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while extracting " + apklibDirectory.getAbsolutePath() + ". Message: " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        this.projectHelper.addResource(this.project, apklibDirectory.getAbsolutePath() + "/src", null, Arrays.asList("**/*.java", "**/*.aidl"));
        this.project.addCompileSourceRoot(apklibDirectory.getAbsolutePath() + "/src");
    }

    private void deleteConflictingManifestJavaFiles(File sourceDirectory) throws MojoExecutionException {
        int numberOfFilesDeleted = this.deleteFilesFromDirectory(sourceDirectory, "**/Manifest.java");
        if (numberOfFilesDeleted > 0) {
            this.getLog().info((CharSequence)("Deleted " + numberOfFilesDeleted + " conflicting Manifest.java file(s) in source directory. If you use Eclipse, please Refresh (F5) the project to regain it."));
        }
    }

    private void deleteConflictingRJavaFiles(File sourceDirectory) throws MojoExecutionException {
        int numberOfFilesDeleted = this.deleteFilesFromDirectory(sourceDirectory, "**/R.java");
        if (numberOfFilesDeleted > 0) {
            this.getLog().info((CharSequence)("Deleted " + numberOfFilesDeleted + " conflicting R.java file(s) in source directory. If you use Eclipse, please Refresh (F5) the project to regain it."));
        }
    }

    private void deleteConflictingThumbsDb(File resourceDirectory) throws MojoExecutionException {
        int numberOfFilesDeleted = this.deleteFilesFromDirectory(resourceDirectory, "**/Thumbs.db");
        if (numberOfFilesDeleted > 0) {
            this.getLog().info((CharSequence)("Deleted " + numberOfFilesDeleted + " Thumbs.db file(s) in resource directory."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteConflictingAidlJavaFiles(File sourceDirectory, Collection<String> relativeAidlFileNames) throws MojoExecutionException {
        for (String relativeAidlFileName : relativeAidlFileNames) {
            String relativeJavaFileName = relativeAidlFileName.substring(0, relativeAidlFileName.lastIndexOf(".")) + ".java";
            File conflictingJavaFileInSourceDirectory = new File(sourceDirectory, relativeJavaFileName);
            if (!conflictingJavaFileInSourceDirectory.exists()) continue;
            boolean shouldDelete = false;
            try {
                LineIterator lineIterator = FileUtils.lineIterator((File)conflictingJavaFileInSourceDirectory);
                try {
                    while (!shouldDelete && lineIterator.hasNext()) {
                        if (!lineIterator.nextLine().contains("interface")) continue;
                        shouldDelete = true;
                    }
                }
                finally {
                    lineIterator.close();
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not inspect aidl file \"" + conflictingJavaFileInSourceDirectory.getAbsolutePath() + "\".");
            }
            if (!shouldDelete) continue;
            boolean successfullyDeleted = conflictingJavaFileInSourceDirectory.delete();
            if (successfullyDeleted) {
                this.getLog().info((CharSequence)("Deleted conflicting file in source directory: \"" + conflictingJavaFileInSourceDirectory + "\". If you use Eclipse, please Refresh (F5) the project to regain them."));
                continue;
            }
            throw new MojoExecutionException("Failed to delete conflicting file in source directory: \"" + conflictingJavaFileInSourceDirectory + "\"");
        }
    }

    private void generateR() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Generating R file for " + this.project.getPackaging()));
        this.genDirectory.mkdirs();
        File[] overlayDirectories = this.resourceOverlayDirectories == null || this.resourceOverlayDirectories.length == 0 ? new File[]{this.resourceOverlayDirectory} : this.resourceOverlayDirectories;
        if (this.extractedDependenciesRes.exists()) {
            try {
                this.getLog().info((CharSequence)"Copying dependency resource files to combined resource directory.");
                if (!this.combinedRes.exists() && !this.combinedRes.mkdirs()) {
                    throw new MojoExecutionException("Could not create directory for combined resources at " + this.combinedRes.getAbsolutePath());
                }
                FileUtils.copyDirectory((File)this.extractedDependenciesRes, (File)this.combinedRes);
            }
            catch (IOException e) {
                throw new MojoExecutionException("", (Exception)e);
            }
        }
        if (this.resourceDirectory.exists() && this.combinedRes.exists()) {
            try {
                this.getLog().info((CharSequence)"Copying local resource files to combined resource directory.");
                FileUtils.copyDirectory((File)this.resourceDirectory, (File)this.combinedRes, (FileFilter)new FileFilter(){

                    public boolean accept(File file) {
                        for (String pattern : AbstractScanner.DEFAULTEXCLUDES) {
                            if (!AbstractScanner.match((String)pattern, (String)file.getAbsolutePath())) continue;
                            GenerateSourcesMojo.this.getLog().debug((CharSequence)("Excluding " + file.getName() + " from resource copy : matching " + pattern));
                            return false;
                        }
                        return true;
                    }
                });
            }
            catch (IOException e) {
                throw new MojoExecutionException("", (Exception)e);
            }
        }
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("package");
        commands.add("-m");
        commands.add("-J");
        commands.add(this.genDirectory.getAbsolutePath());
        commands.add("-M");
        commands.add(this.androidManifestFile.getAbsolutePath());
        if (StringUtils.isNotBlank((String)this.customPackage)) {
            commands.add("--custom-package");
            commands.add(this.customPackage);
        }
        for (File resOverlayDir : overlayDirectories) {
            if (resOverlayDir == null || !resOverlayDir.exists()) continue;
            commands.add("-S");
            commands.add(resOverlayDir.getAbsolutePath());
        }
        if (this.combinedRes.exists()) {
            commands.add("-S");
            commands.add(this.combinedRes.getAbsolutePath());
        } else if (this.resourceDirectory.exists()) {
            commands.add("-S");
            commands.add(this.resourceDirectory.getAbsolutePath());
        }
        for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
            if (!artifact.getType().equals("apklib")) continue;
            commands.add("-S");
            commands.add(this.getLibraryUnpackDirectory(artifact) + "/res");
        }
        commands.add("--auto-add-overlay");
        if (this.assetsDirectory.exists()) {
            commands.add("-A");
            commands.add(this.assetsDirectory.getAbsolutePath());
        }
        if (this.extractedDependenciesAssets.exists()) {
            commands.add("-A");
            commands.add(this.extractedDependenciesAssets.getAbsolutePath());
        }
        commands.add("-I");
        commands.add(this.getAndroidSdk().getAndroidJar().getAbsolutePath());
        if (StringUtils.isNotBlank((String)this.configurations)) {
            commands.add("-c");
            commands.add(this.configurations);
        }
        this.getLog().info((CharSequence)(this.getAndroidSdk().getPathForTool("aapt") + " " + ((Object)commands).toString()));
        try {
            executor.executeCommand(this.getAndroidSdk().getPathForTool("aapt"), commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
        this.project.addCompileSourceRoot(this.genDirectory.getAbsolutePath());
    }

    private void generateApklibR() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Generating R file for projects dependent on apklibs");
        this.genDirectory.mkdirs();
        for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
            if (!artifact.getType().equals("apklib")) continue;
            this.generateRForApkLibDependency(this.getLibraryUnpackDirectory(artifact) + "/" + "AndroidManifest.xml");
        }
        this.project.addCompileSourceRoot(this.genDirectory.getAbsolutePath());
    }

    private void generateRForApkLibDependency(String pathToApkLibAndroidManifest) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Generating R file for apklibrary: " + pathToApkLibAndroidManifest));
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("package");
        commands.add("-m");
        commands.add("-J");
        commands.add(this.genDirectory.getAbsolutePath());
        commands.add("-M");
        commands.add(pathToApkLibAndroidManifest);
        if (this.resourceDirectory.exists()) {
            commands.add("-S");
            commands.add(this.resourceDirectory.getAbsolutePath());
        }
        for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
            String apkLibResDir;
            if (!artifact.getType().equals("apklib") || !new File(apkLibResDir = this.getLibraryUnpackDirectory(artifact) + "/res").exists()) continue;
            commands.add("-S");
            commands.add(apkLibResDir);
        }
        commands.add("--auto-add-overlay");
        if (this.assetsDirectory.exists()) {
            commands.add("-A");
            commands.add(this.assetsDirectory.getAbsolutePath());
        }
        for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
            String apkLibAssetsDir;
            if (!artifact.getType().equals("apklib") || !new File(apkLibAssetsDir = this.getLibraryUnpackDirectory(artifact) + "/assets").exists()) continue;
            commands.add("-A");
            commands.add(apkLibAssetsDir);
        }
        commands.add("-I");
        commands.add(this.getAndroidSdk().getAndroidJar().getAbsolutePath());
        if (StringUtils.isNotBlank((String)this.configurations)) {
            commands.add("-c");
            commands.add(this.configurations);
        }
        this.getLog().info((CharSequence)(this.getAndroidSdk().getPathForTool("aapt") + " " + ((Object)commands).toString()));
        try {
            executor.executeCommand(this.getAndroidSdk().getPathForTool("aapt"), commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }

    private void generateAidlFiles(Map<File, String[]> files) throws MojoExecutionException {
        ArrayList<String> protoCommands = new ArrayList<String>();
        protoCommands.add("-p" + this.getAndroidSdk().getPathForFrameworkAidl());
        File generatedSourcesAidlDirectory = new File(this.project.getBuild().getDirectory() + File.separator + "generated-sources" + File.separator + "aidl");
        generatedSourcesAidlDirectory.mkdirs();
        this.project.addCompileSourceRoot(generatedSourcesAidlDirectory.getPath());
        Set<File> sourceDirs = files.keySet();
        for (File sourceDir : sourceDirs) {
            protoCommands.add("-I" + sourceDir);
        }
        for (File sourceDir : sourceDirs) {
            for (String relativeAidlFileName : files.get(sourceDir)) {
                File targetDirectory = new File(generatedSourcesAidlDirectory, new File(relativeAidlFileName).getParent());
                targetDirectory.mkdirs();
                String shortAidlFileName = new File(relativeAidlFileName).getName();
                String shortJavaFileName = shortAidlFileName.substring(0, shortAidlFileName.lastIndexOf(".")) + ".java";
                File aidlFileInSourceDirectory = new File(sourceDir, relativeAidlFileName);
                ArrayList<String> commands = new ArrayList<String>(protoCommands);
                commands.add(aidlFileInSourceDirectory.getAbsolutePath());
                commands.add(new File(targetDirectory, shortJavaFileName).getAbsolutePath());
                try {
                    CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
                    executor.setLogger(this.getLog());
                    executor.executeCommand(this.getAndroidSdk().getPathForTool("aidl"), commands, this.project.getBasedir(), false);
                }
                catch (ExecutionException e) {
                    throw new MojoExecutionException("", (Exception)e);
                }
            }
        }
    }

    private String[] findRelativeAidlFileNames(File sourceDirectory) {
        String[] relativeAidlFileNames = this.findFilesInDirectory(sourceDirectory, "**/*.aidl");
        this.getLog().info((CharSequence)("ANDROID-904-002: Found aidl files: Count = " + relativeAidlFileNames.length));
        return relativeAidlFileNames;
    }

    private boolean isCurrentProjectAndroid() {
        HashSet<String> androidArtifacts = new HashSet<String>(){
            {
                this.addAll(Arrays.asList("apk", "apklib", "apksources"));
            }
        };
        return androidArtifacts.contains(this.project.getArtifact().getType());
    }
}

