/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android;

import com.jayway.maven.plugins.android.AndroidSdk;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.Sdk;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathNotFoundException;
import org.apache.commons.jxpath.xml.DocumentContainer;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.utils.resolvers.DefaultArtifactsResolver;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAndroidMojo
extends AbstractMojo {
    protected static final String ANDROID_PACKAGE_EXTENSTION = ".apk";
    protected MavenProject project;
    protected MavenSession session;
    protected File sourceDirectory;
    protected File resourceDirectory;
    protected File resourceOverlayDirectory;
    protected File[] resourceOverlayDirectories;
    protected File assetsDirectory;
    protected File androidManifestFile;
    protected File extractedDependenciesDirectory;
    protected File extractedDependenciesRes;
    protected File extractedDependenciesAssets;
    protected File extractedDependenciesJavaSources;
    protected File extractedDependenciesJavaResources;
    protected File combinedRes;
    protected String device;
    protected String configurations;
    protected boolean generateApk;
    protected ArtifactResolver artifactResolver;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private ArtifactFactory artifactFactory;
    protected MavenProjectHelper projectHelper;
    private Sdk sdk;
    private File sdkPath;
    private String envANDROID_HOME;
    public static final String ENV_ANDROID_HOME = "ANDROID_HOME";
    private String sdkPlatform;
    protected boolean undeployBeforeDeploy;
    protected boolean attachJar;
    protected boolean attachSources;
    protected static final List<String> EXCLUDED_DEPENDENCY_SCOPES = Arrays.asList("provided", "system", "import");

    protected ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    protected Set<Artifact> getRelevantCompileArtifacts() {
        List allArtifacts = this.project.getCompileArtifacts();
        Set<Artifact> results = this.filterOutIrrelevantArtifacts(allArtifacts);
        return results;
    }

    protected Set<Artifact> getRelevantDependencyArtifacts() {
        Set allArtifacts = this.project.getDependencyArtifacts();
        Set<Artifact> results = this.filterOutIrrelevantArtifacts(allArtifacts);
        return results;
    }

    private Set<Artifact> filterOutIrrelevantArtifacts(Iterable<Artifact> allArtifacts) {
        HashSet<Artifact> results = new HashSet<Artifact>();
        for (Artifact artifact : allArtifacts) {
            if (artifact == null || EXCLUDED_DEPENDENCY_SCOPES.contains(artifact.getScope())) continue;
            if (artifact.getGroupId().equals("android")) {
                this.getLog().warn((CharSequence)"Excluding the android.jar from being unpacked into your apk file, based on its <groupId>android</groupId>. Please set <scope>provided</scope> in that dependency, because that is the correct way, and the only which will work in the future.");
                continue;
            }
            results.add(artifact);
        }
        return results;
    }

    protected File resolveArtifactToFile(Artifact artifact) throws MojoExecutionException {
        DefaultArtifactsResolver artifactsResolver = new DefaultArtifactsResolver(this.artifactResolver, this.localRepository, this.remoteRepositories, true);
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        artifacts.add(artifact);
        File jar = null;
        Set resolvedArtifacts = artifactsResolver.resolve(artifacts, this.getLog());
        for (Artifact resolvedArtifact : resolvedArtifacts) {
            jar = resolvedArtifact.getFile();
        }
        if (jar == null) {
            throw new MojoExecutionException("Could not resolve artifact " + artifact.getId() + ". Please install it with \"mvn install:install-file ...\" or deploy it to a repository with \"mvn deploy:deploy-file ...\"");
        }
        return jar;
    }

    protected void deployApk(File apkFile) throws MojoExecutionException {
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        ArrayList<String> commands = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)this.device)) {
            if ("usb".equals(this.device)) {
                commands.add("-d");
            } else if ("emulator".equals(this.device)) {
                commands.add("-e");
            } else {
                commands.add("-s");
                commands.add(this.device);
            }
        }
        commands.add("install");
        commands.add("-r");
        commands.add(apkFile.getAbsolutePath());
        this.getLog().info((CharSequence)(this.getAndroidSdk().getPathForTool("adb") + " " + ((Object)commands).toString()));
        try {
            executor.executeCommand(this.getAndroidSdk().getPathForTool("adb"), commands, false);
            String standardOut = executor.getStandardOut();
            if (standardOut != null && standardOut.contains("Failure")) {
                throw new MojoExecutionException("Error deploying " + apkFile + " to device. You might want to add command line parameter -Dandroid.undeployBeforeDeploy=true or add plugin configuration tag <undeployBeforeDeploy>true</undeployBeforeDeploy>\n" + standardOut);
            }
        }
        catch (ExecutionException e) {
            this.getLog().error((CharSequence)executor.getStandardOut());
            this.getLog().error((CharSequence)executor.getStandardError());
            throw new MojoExecutionException("Error deploying " + apkFile + " to device.", (Exception)e);
        }
    }

    protected boolean undeployApk(File apkFile) throws MojoExecutionException {
        return this.undeployApk(apkFile, true);
    }

    protected boolean undeployApk(File apkFile, boolean deleteDataAndCacheDirectoriesOnDevice) throws MojoExecutionException {
        String packageName = this.extractPackageNameFromApk(apkFile);
        return this.undeployApk(packageName, deleteDataAndCacheDirectoriesOnDevice);
    }

    protected boolean undeployApk(String packageName) throws MojoExecutionException {
        return this.undeployApk(packageName, true);
    }

    protected boolean undeployApk(String packageName, boolean deleteDataAndCacheDirectoriesOnDevice) throws MojoExecutionException {
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("uninstall");
        if (!deleteDataAndCacheDirectoriesOnDevice) {
            commands.add("-k");
        }
        commands.add(packageName);
        this.getLog().info((CharSequence)(this.getAndroidSdk().getPathForTool("adb") + " " + ((Object)commands).toString()));
        try {
            executor.executeCommand(this.getAndroidSdk().getPathForTool("adb"), commands, false);
            this.getLog().debug((CharSequence)executor.getStandardOut());
            this.getLog().debug((CharSequence)executor.getStandardError());
            return true;
        }
        catch (ExecutionException e) {
            this.getLog().error((CharSequence)executor.getStandardOut());
            this.getLog().error((CharSequence)executor.getStandardError());
            return false;
        }
    }

    protected String extractPackageNameFromApk(File apkFile) throws MojoExecutionException {
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("dump");
        commands.add("xmltree");
        commands.add(apkFile.getAbsolutePath());
        commands.add("AndroidManifest.xml");
        this.getLog().info((CharSequence)(this.getAndroidSdk().getPathForTool("aapt") + " " + ((Object)commands).toString()));
        try {
            executor.executeCommand(this.getAndroidSdk().getPathForTool("aapt"), commands, true);
            String xmlTree = executor.getStandardOut();
            String string = this.extractPackageNameFromAndroidManifestXmlTree(xmlTree);
            return string;
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("Error while trying to figure out package name from inside apk file " + apkFile);
        }
        finally {
            this.getLog().error((CharSequence)executor.getStandardError());
        }
    }

    protected String extractPackageNameFromAndroidManifestXmlTree(String aaptDumpXmlTree) {
        Scanner scanner = new Scanner(aaptDumpXmlTree);
        scanner.findWithinHorizon("^E: manifest", 0);
        scanner.findWithinHorizon("  A: package=\"", 0);
        String packageName = scanner.next(".*?\"");
        packageName = packageName.substring(0, packageName.length() - 1);
        return packageName;
    }

    protected String extractPackageNameFromAndroidManifest(File androidManifestFile) throws MojoExecutionException {
        URL xmlURL;
        try {
            xmlURL = androidManifestFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error while trying to figure out package name from inside AndroidManifest.xml file " + androidManifestFile, (Exception)e);
        }
        DocumentContainer documentContainer = new DocumentContainer(xmlURL);
        Object packageName = JXPathContext.newContext((Object)documentContainer).getValue("manifest/@package", String.class);
        return (String)packageName;
    }

    protected String extractInstrumentationRunnerFromAndroidManifest(File androidManifestFile) throws MojoExecutionException {
        Object instrumentationRunner;
        URL xmlURL;
        try {
            xmlURL = androidManifestFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error while trying to figure out instrumentation runner from inside AndroidManifest.xml file " + androidManifestFile, (Exception)e);
        }
        DocumentContainer documentContainer = new DocumentContainer(xmlURL);
        try {
            instrumentationRunner = JXPathContext.newContext((Object)documentContainer).getValue("manifest//instrumentation/@android:name", String.class);
        }
        catch (JXPathNotFoundException e) {
            return null;
        }
        return (String)instrumentationRunner;
    }

    protected int deleteFilesFromDirectory(File baseDirectory, String ... includes) throws MojoExecutionException {
        String[] files = this.findFilesInDirectory(baseDirectory, includes);
        if (files == null) {
            return 0;
        }
        for (String file : files) {
            boolean successfullyDeleted = new File(baseDirectory, file).delete();
            if (successfullyDeleted) continue;
            throw new MojoExecutionException("Failed to delete \"" + file + "\"");
        }
        return files.length;
    }

    protected String[] findFilesInDirectory(File baseDirectory, String ... includes) {
        if (baseDirectory.exists()) {
            DirectoryScanner directoryScanner = new DirectoryScanner();
            directoryScanner.setBasedir(baseDirectory);
            directoryScanner.setIncludes(includes);
            directoryScanner.addDefaultExcludes();
            directoryScanner.scan();
            String[] files = directoryScanner.getIncludedFiles();
            return files;
        }
        return new String[0];
    }

    protected AndroidSdk getAndroidSdk() throws MojoExecutionException {
        String chosenSdkPlatform;
        File chosenSdkPath;
        if (this.sdk != null) {
            chosenSdkPath = this.sdk.getPath() != null ? this.sdk.getPath() : (this.sdkPath != null ? this.sdkPath : new File(this.getAndroidHomeOrThrow()));
            chosenSdkPlatform = !StringUtils.isBlank((String)this.sdk.getPlatform()) ? this.sdk.getPlatform() : this.sdkPlatform;
        } else {
            chosenSdkPath = this.sdkPath != null ? this.sdkPath : new File(this.getAndroidHomeOrThrow());
            chosenSdkPlatform = this.sdkPlatform;
        }
        return new AndroidSdk(chosenSdkPath, chosenSdkPlatform);
    }

    private String getAndroidHomeOrThrow() throws MojoExecutionException {
        String androidHome = System.getenv(ENV_ANDROID_HOME);
        if (StringUtils.isBlank((String)androidHome)) {
            throw new MojoExecutionException("No Android SDK path could be found. You may configure it in the pom using <sdk><path>...</path></sdk> or <properties><sdk.path>...</sdk.path></properties> or on command-line using -Dandroid.sdk.path=... or by setting environment variable ANDROID_HOME");
        }
        return androidHome;
    }
}

