/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.Emulator;
import com.jayway.maven.plugins.android.ExecutionException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class AbstractEmulatorMojo
extends AbstractAndroidMojo {
    public static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    private Emulator emulator;
    private String emulatorAvd;
    private String emulatorWait;
    private String emulatorOptions;
    private String parsedAvd;
    private String parsedOptions;
    private String parsedWait;
    private static final String STOP_EMULATOR_MSG = "Stopping android emulator with pid: ";
    private static final String START_EMULATOR_MSG = "Starting android emulator with script: ";
    private static final String START_EMULATOR_WAIT_MSG = "Waiting for emulator start:";
    private static final String NO_EMULATOR_RUNNING = "unknown";
    private static final String NO_DEMON_RUNNING_MACOSX = "* daemon not running";
    private static final String scriptFolder = System.getProperty("java.io.tmpdir");
    private static final String pidFileName = scriptFolder + "/maven-android-plugin-emulator.pid";

    private boolean isWindows() {
        boolean result = OS_NAME.toLowerCase().contains("windows");
        this.getLog().debug((CharSequence)("isWindows: " + result));
        return result;
    }

    protected void startAndroidEmulator() throws MojoExecutionException {
        this.parseParameters();
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        try {
            String filename = this.isWindows() ? this.writeEmulatorStartScriptWindows() : this.writeEmulatorStartScriptUnix();
            String emulatorName = this.getRunningEmulatorName();
            if (emulatorName.equals(NO_EMULATOR_RUNNING) || emulatorName.startsWith(NO_DEMON_RUNNING_MACOSX)) {
                this.getLog().info((CharSequence)(START_EMULATOR_MSG + filename));
                executor.executeCommand(filename, null);
                this.getLog().info((CharSequence)(START_EMULATOR_WAIT_MSG + this.parsedWait));
                Thread.sleep(new Long(this.parsedWait));
            } else {
                this.getLog().info((CharSequence)("Emulator " + emulatorName + " already running. Skipping start and wait."));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("", e);
        }
    }

    private String getRunningEmulatorName() throws MojoExecutionException, ExecutionException {
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("get-serialno");
        executor.executeCommand(this.getAndroidSdk().getAdbPath(), commands);
        return executor.getStandardOut();
    }

    private String writeEmulatorStartScriptWindows() throws IOException, MojoExecutionException {
        String filename = scriptFolder + "\\maven-android-plugin-emulator-start.bat";
        File file = new File(filename);
        PrintWriter writer = new PrintWriter(new FileWriter(file));
        String command = this.assembleStartCommandLine();
        String uniqueWindowTitle = "MavenAndroidPlugin-AVD" + this.parsedAvd;
        writer.print("START " + uniqueWindowTitle + " " + command);
        writer.println();
        writer.println("FOR /F \"tokens=2\" %%I in ('TASKLIST /NH /FI \"WINDOWTITLE eq " + uniqueWindowTitle + "\"' ) DO SET PID=%%I");
        writer.println("ECHO %PID% > " + pidFileName);
        writer.flush();
        writer.close();
        file.setExecutable(true);
        return filename;
    }

    private String writeEmulatorStartScriptUnix() throws IOException, MojoExecutionException {
        String filename = scriptFolder + "/maven-android-plugin-emulator-start.sh";
        File sh = new File("/bin/bash");
        if (!sh.exists()) {
            sh = new File("/usr/bin/bash");
        }
        if (!sh.exists()) {
            sh = new File("/bin/sh");
        }
        File file = new File(filename);
        PrintWriter writer = new PrintWriter(new FileWriter(file));
        writer.println("#!" + sh.getAbsolutePath());
        writer.print(this.assembleStartCommandLine());
        writer.print(" 1>/dev/null 2>&1 &");
        writer.println();
        writer.println("echo $! > " + pidFileName);
        writer.flush();
        writer.close();
        file.setExecutable(true);
        return filename;
    }

    protected void stopAndroidEmulator() throws MojoExecutionException {
        this.parseParameters();
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        try {
            FileReader fileReader = new FileReader(pidFileName);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String pid = bufferedReader.readLine();
            bufferedReader.close();
            if (this.isWindows()) {
                this.stopEmulatorWindows(executor, pid);
            } else {
                this.stopEmulatorUnix(executor, pid);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("", e);
        }
    }

    private void stopEmulatorWindows(CommandExecutor executor, String pid) throws ExecutionException {
        String stopCommand = "TASKKILL";
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("/PID");
        commands.add(pid);
        this.getLog().info((CharSequence)(STOP_EMULATOR_MSG + pid));
        executor.executeCommand(stopCommand, commands);
    }

    private void stopEmulatorUnix(CommandExecutor executor, String pid) throws ExecutionException {
        String stopCommand = "kill";
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(pid);
        this.getLog().info((CharSequence)(STOP_EMULATOR_MSG + pid));
        executor.executeCommand(stopCommand, commands);
    }

    private String assembleStartCommandLine() throws MojoExecutionException {
        StringBuilder startCommandline = new StringBuilder().append(this.getAndroidSdk().getEmulatorPath()).append(" -avd ").append(this.parsedAvd).append(" ");
        if (!StringUtils.isEmpty((String)this.parsedOptions)) {
            startCommandline.append(this.parsedOptions);
        }
        this.getLog().info((CharSequence)("Android emulator command: " + startCommandline));
        return startCommandline.toString();
    }

    private void parseParameters() {
        if (this.emulator != null) {
            this.parsedAvd = this.emulator.getAvd() != null ? this.emulator.getAvd() : this.determineAvd();
            this.parsedOptions = this.emulator.getOptions() != null ? this.emulator.getOptions() : this.determineOptions();
            this.parsedWait = this.emulator.getWait() != null ? this.emulator.getWait() : this.determineWait();
        } else {
            this.parsedAvd = this.determineAvd();
            this.parsedOptions = this.determineOptions();
            this.parsedWait = this.determineWait();
        }
    }

    private String determineWait() {
        String wait = this.emulatorWait != null ? this.emulatorWait : "5000";
        return wait;
    }

    private String determineOptions() {
        String options = this.emulatorOptions != null ? this.emulatorOptions : "";
        return options;
    }

    private String determineAvd() {
        String avd = this.emulatorAvd != null ? this.emulatorAvd : "Default";
        return avd;
    }
}

