/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase04processclasses;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.config.ConfigHandler;
import com.jayway.maven.plugins.android.config.ConfigPojo;
import com.jayway.maven.plugins.android.config.PullParameter;
import com.jayway.maven.plugins.android.configuration.Proguard;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.interpolation.os.Os;

@Mojo(name="proguard", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ProguardMojo
extends AbstractAndroidMojo {
    @ConfigPojo
    @Parameter
    protected Proguard proguard;
    @Parameter(property="android.proguard.skip")
    private Boolean proguardSkip;
    @PullParameter(defaultValue={"true"})
    private Boolean parsedSkip;
    @PullParameter(defaultValue={"${project.basedir}/proguard.cfg"})
    private File parsedConfig;
    @PullParameter(defaultValueGetterMethod="getDefaultProguardConfigs")
    private String[] parsedConfigs;
    @Parameter(property="android.proguard.options")
    private String[] proguardOptions;
    @PullParameter(defaultValueGetterMethod="getDefaultProguardOptions")
    private String[] parsedOptions;
    @Parameter(property="android.proguard.proguardJarPath")
    private String proguardProguardJarPath;
    @PullParameter(defaultValueGetterMethod="getProguardJarPath")
    private String parsedProguardJarPath;
    @Parameter(property="android.proguard.outputDirectory")
    private File outputDirectory;
    @PullParameter(defaultValue={"${project.build.directory}/proguard"})
    private File parsedOutputDirectory;
    @Parameter(property="android.proguard.obfuscatedJar", defaultValue="${project.build.directory}/${project.build.finalName}_obfuscated.jar")
    private String obfuscatedJar;
    @Parameter(property="android.proguard.jvmArguments")
    private String[] proguardJvmArguments;
    @PullParameter(defaultValueGetterMethod="getDefaultJvmArguments")
    private String[] parsedJvmArguments;
    @Parameter(property="android.proguard.filterMavenDescriptor")
    private Boolean proguardFilterMavenDescriptor;
    @PullParameter(defaultValue={"true"})
    private Boolean parsedFilterMavenDescriptor;
    @Parameter(property="android.proguard.filterManifest")
    private Boolean proguardFilterManifest;
    @PullParameter(defaultValue={"true"})
    private Boolean parsedFilterManifest;
    @Parameter(property="android.proguard.includeJdkLibs")
    private Boolean includeJdkLibs;
    @PullParameter(defaultValue={"true"})
    private Boolean parsedIncludeJdkLibs;
    @Parameter(property="android.proguard.attachMap")
    private Boolean attachMap;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedAttachMap;
    @Parameter(defaultValue="${plugin.artifacts}", required=true, readonly=true)
    protected List<Artifact> pluginDependencies;
    private static final Collection<String> ANDROID_LIBRARY_EXCLUDED_FILTER = Arrays.asList("org/xml/**", "org/w3c/**", "java/**", "javax/**");
    private static final Collection<String> MAVEN_DESCRIPTOR = Arrays.asList("META-INF/maven/**");
    private static final Collection<String> META_INF_MANIFEST = Arrays.asList("META-INF/MANIFEST.MF");
    private static final String JAR_DEPENDENCY_TYPE = "jar";
    private List<ArtifactPrototype> artifactBlacklist = new LinkedList<ArtifactPrototype>();
    private List<ArtifactPrototype> artifactsToShift = new LinkedList<ArtifactPrototype>();
    private File javaHomeDir;
    private File javaLibDir;
    private File altJavaLibDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ConfigHandler configHandler = new ConfigHandler((Object)this, this.session, this.execution);
        configHandler.parseConfiguration();
        if (!this.parsedSkip.booleanValue()) {
            if (this.parsedConfig.exists()) {
                this.project.getProperties().setProperty("android.proguard.obfuscatedJar", this.obfuscatedJar);
                this.executeProguard();
            } else {
                this.getLog().info((CharSequence)String.format("Proguard skipped because the configuration file doesn't exist: %s", this.parsedConfig));
            }
        }
    }

    private void executeProguard() throws MojoExecutionException {
        File proguardDir = this.parsedOutputDirectory;
        if (!proguardDir.exists() && !proguardDir.mkdir()) {
            throw new MojoExecutionException("Cannot create proguard output directory");
        }
        if (proguardDir.exists() && !proguardDir.isDirectory()) {
            throw new MojoExecutionException("Non-directory exists at " + proguardDir.getAbsolutePath());
        }
        this.getLog().info((CharSequence)"Proguarding output");
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        ArrayList<String> commands = new ArrayList<String>();
        this.collectJvmArguments(commands);
        commands.add("-jar");
        commands.add(this.parsedProguardJarPath);
        commands.add("@\"" + this.parsedConfig + "\"");
        for (String config : this.parsedConfigs) {
            commands.add("@\"" + config + "\"");
        }
        if (this.proguardFile != null) {
            commands.add("@\"" + this.proguardFile.getAbsolutePath() + "\"");
        }
        this.collectInputFiles(commands);
        commands.add("-outjars");
        commands.add("'\"" + this.obfuscatedJar + "\"'");
        commands.add("-dump");
        commands.add("'\"" + proguardDir + File.separator + "dump.txt\"'");
        commands.add("-printseeds");
        commands.add("'\"" + proguardDir + File.separator + "seeds.txt\"'");
        commands.add("-printusage");
        commands.add("'\"" + proguardDir + File.separator + "usage.txt\"'");
        File mapFile = new File(proguardDir, "mapping.txt");
        commands.add("-printmapping");
        commands.add("'\"" + mapFile + "\"'");
        commands.addAll(Arrays.asList(this.parsedOptions));
        String javaExecutable = ProguardMojo.getJavaExecutable().getAbsolutePath();
        this.getLog().debug((CharSequence)(javaExecutable + " " + ((Object)commands).toString()));
        try {
            executor.setCaptureStdOut(true);
            executor.executeCommand(javaExecutable, commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
        if (this.parsedAttachMap.booleanValue()) {
            this.projectHelper.attachArtifact(this.project, "map", mapFile);
        }
    }

    private void collectJvmArguments(List<String> commands) {
        if (this.parsedJvmArguments != null) {
            for (String jvmArgument : this.parsedJvmArguments) {
                if (!jvmArgument.startsWith("-")) {
                    jvmArgument = "-" + jvmArgument;
                }
                commands.add(jvmArgument);
            }
        }
    }

    private void collectInputFiles(List<String> commands) throws MojoExecutionException {
        this.skipArtifact("commons-logging", "commons-logging", true);
        List<ProGuardInput> inJars = this.getProgramInputFiles();
        for (ProGuardInput injar : inJars) {
            this.getLog().debug((CharSequence)("Added injar : " + injar));
            commands.add("-injars");
            commands.add(injar.toCommandLine());
        }
        List<ProGuardInput> libraryJars = this.getLibraryInputFiles();
        for (ProGuardInput libraryjar : libraryJars) {
            this.getLog().debug((CharSequence)("Added libraryJar : " + libraryjar));
            commands.add("-libraryjars");
            commands.add(libraryjar.toCommandLine());
        }
    }

    private static File getJavaExecutable() {
        String javaHome = System.getProperty("java.home");
        String slash = File.separator;
        return new File(javaHome + slash + "bin" + slash + "java");
    }

    private void skipArtifact(String groupId, String artifactId, boolean shiftToLibraries) throws MojoExecutionException {
        ArtifactPrototype artifact = new ArtifactPrototype(groupId, artifactId);
        this.artifactBlacklist.add(artifact);
        if (shiftToLibraries) {
            this.artifactsToShift.add(artifact);
        }
    }

    private boolean isBlacklistedArtifact(Artifact artifact) {
        for (ArtifactPrototype artifactToSkip : this.artifactBlacklist) {
            if (!artifactToSkip.groupId.equals(artifact.getGroupId()) || !artifactToSkip.artifactId.equals(artifact.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    private boolean isShiftedArtifact(Artifact artifact) {
        for (ArtifactPrototype artifactToShift : this.artifactsToShift) {
            if (!artifactToShift.groupId.equals(artifact.getGroupId()) || !artifactToShift.artifactId.equals(artifact.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    private List<ProGuardInput> getProgramInputFiles() {
        HashSet<String> globalInJarExcludes = new HashSet<String>();
        LinkedList<ProGuardInput> inJars = new LinkedList<ProGuardInput>();
        if (this.parsedFilterManifest.booleanValue()) {
            globalInJarExcludes.addAll(META_INF_MANIFEST);
        }
        if (this.parsedFilterMavenDescriptor.booleanValue()) {
            globalInJarExcludes.addAll(MAVEN_DESCRIPTOR);
        }
        inJars.add(this.createProguardInput(this.projectOutputDirectory.getAbsolutePath()));
        for (Artifact artifact : this.getTransitiveDependencyArtifacts(new String[0])) {
            if (this.isBlacklistedArtifact(artifact)) {
                this.getLog().debug((CharSequence)("Excluding (blacklisted) dependency as input jar : " + artifact));
                continue;
            }
            if (JAR_DEPENDENCY_TYPE.equals(artifact.getType())) {
                this.getLog().debug((CharSequence)("Including dependency as input jar : " + artifact));
                inJars.add(this.createProguardInput(artifact.getFile().getAbsolutePath(), globalInJarExcludes));
                continue;
            }
            if ("aar".equals(artifact.getType())) continue;
            this.getLog().debug((CharSequence)("Excluding dependency as input jar : " + artifact));
        }
        return inJars;
    }

    private ProGuardInput createProguardInput(String path, Collection<String> filterExpression) {
        return new ProGuardInput(path, filterExpression);
    }

    private ProGuardInput createProguardInput(String path) {
        return this.createProguardInput(path, null);
    }

    private List<ProGuardInput> getLibraryInputFiles() {
        LinkedList<ProGuardInput> libraryJars = new LinkedList<ProGuardInput>();
        if (this.parsedIncludeJdkLibs.booleanValue()) {
            File jceJar;
            File jsseJar;
            File rtJar = this.getJVMLibrary("rt.jar");
            if (rtJar == null) {
                rtJar = this.getJVMLibrary("classes.jar");
            }
            if (rtJar != null) {
                libraryJars.add(this.createProguardInput(rtJar.getPath()));
            }
            if ((jsseJar = this.getJVMLibrary("jsse.jar")) != null) {
                libraryJars.add(this.createProguardInput(jsseJar.getPath()));
            }
            if ((jceJar = this.getJVMLibrary("jce.jar")) != null) {
                libraryJars.add(this.createProguardInput(jceJar.getPath()));
            }
        }
        for (Artifact artifact : this.project.getArtifacts()) {
            if (artifact.getScope().equals("provided")) {
                if (artifact.getArtifactId().equals("android") && this.parsedIncludeJdkLibs.booleanValue()) {
                    this.getLog().debug((CharSequence)("Including dependency as (android) library jar : " + artifact));
                    libraryJars.add(this.createProguardInput(artifact.getFile().getAbsolutePath(), ANDROID_LIBRARY_EXCLUDED_FILTER));
                    continue;
                }
                this.getLog().debug((CharSequence)("Including dependency as (provided) library jar : " + artifact));
                libraryJars.add(this.createProguardInput(artifact.getFile().getAbsolutePath()));
                continue;
            }
            if (this.isShiftedArtifact(artifact)) {
                this.getLog().debug((CharSequence)("Including dependency as (shifted) library jar : " + artifact));
                libraryJars.add(this.createProguardInput(artifact.getFile().getAbsolutePath()));
                continue;
            }
            this.getLog().debug((CharSequence)("Excluding dependency as library jar : " + artifact));
        }
        return libraryJars;
    }

    private String getProguardJarPath() throws MojoExecutionException {
        String proguardJarPath = this.getProguardJarPathFromDependencies();
        if (StringUtils.isEmpty((String)proguardJarPath)) {
            File proguardJarPathFile = new File(this.getAndroidSdk().getToolsPath(), "proguard/lib/proguard.jar");
            return proguardJarPathFile.getAbsolutePath();
        }
        return proguardJarPath;
    }

    private String getProguardJarPathFromDependencies() throws MojoExecutionException {
        Artifact proguardArtifact = null;
        int proguardArtifactDistance = -1;
        for (Artifact artifact : this.pluginDependencies) {
            this.getLog().debug((CharSequence)("pluginArtifact: " + artifact.getFile()));
            if (!"proguard".equals(artifact.getArtifactId()) && !"proguard-base".equals(artifact.getArtifactId())) continue;
            int distance = artifact.getDependencyTrail().size();
            this.getLog().debug((CharSequence)("proguard DependencyTrail: " + distance));
            if (proguardArtifactDistance == -1) {
                proguardArtifact = artifact;
                proguardArtifactDistance = distance;
                continue;
            }
            if (distance >= proguardArtifactDistance) continue;
            proguardArtifact = artifact;
            proguardArtifactDistance = distance;
        }
        if (proguardArtifact != null) {
            this.getLog().debug((CharSequence)("proguardArtifact: " + proguardArtifact.getFile()));
            return proguardArtifact.getFile().getAbsoluteFile().toString();
        }
        return null;
    }

    private String[] getDefaultJvmArguments() {
        return new String[]{"-Xmx512M"};
    }

    private String[] getDefaultProguardConfigs() {
        return new String[0];
    }

    private String[] getDefaultProguardOptions() {
        return new String[0];
    }

    private File getJVMLibrary(String fileName) {
        File libFile = new File(this.getJavaLibDir(), fileName);
        if (!libFile.exists() && !(libFile = new File(this.getAltJavaLibDir(), fileName)).exists()) {
            libFile = null;
        }
        return libFile;
    }

    private File getJavaHomeDir() {
        if (this.javaHomeDir == null) {
            this.javaHomeDir = new File(System.getProperty("java.home"));
        }
        return this.javaHomeDir;
    }

    private File getJavaLibDir() {
        if (this.javaLibDir == null) {
            this.javaLibDir = new File(this.getJavaHomeDir(), "lib");
        }
        return this.javaLibDir;
    }

    private File getAltJavaLibDir() {
        if (this.altJavaLibDir == null) {
            this.altJavaLibDir = new File(this.getJavaHomeDir().getParent(), "Classes");
        }
        return this.altJavaLibDir;
    }

    private static class ProGuardInput {
        private String path;
        private Collection<String> excludedFilter;

        public ProGuardInput(String path, Collection<String> excludedFilter) {
            this.path = path;
            this.excludedFilter = excludedFilter;
        }

        public String toCommandLine() {
            String endQuote;
            String startQuotes;
            if (this.excludedFilter != null && !this.excludedFilter.isEmpty()) {
                String endQuote2;
                String middleQuote;
                String startQuotes2;
                if (!Os.isFamily((String)"windows")) {
                    startQuotes2 = "'\"";
                    middleQuote = "\"(";
                    endQuote2 = ")'";
                } else {
                    startQuotes2 = "\"'";
                    middleQuote = "'(";
                    endQuote2 = ")\"";
                }
                StringBuilder sb = new StringBuilder(startQuotes2);
                sb.append(this.path);
                sb.append(middleQuote);
                Iterator<String> it = this.excludedFilter.iterator();
                while (it.hasNext()) {
                    sb.append('!').append(it.next());
                    if (!it.hasNext()) continue;
                    sb.append(',');
                }
                sb.append(endQuote2);
                return sb.toString();
            }
            if (!Os.isFamily((String)"windows")) {
                startQuotes = "'\"";
                endQuote = "\"'";
            } else {
                startQuotes = "\"'";
                endQuote = "'\"";
            }
            return startQuotes + this.path + endQuote;
        }

        public String toString() {
            return "ProGuardInput{path='" + this.path + '\'' + ", excludedFilter=" + this.excludedFilter + '}';
        }
    }

    private static class ArtifactPrototype {
        private final String groupId;
        private final String artifactId;

        private ArtifactPrototype(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }
    }
}

