/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase05compile;

import com.jayway.maven.plugins.android.common.AetherHelper;
import com.jayway.maven.plugins.android.common.JarHelper;
import com.jayway.maven.plugins.android.common.NativeHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.repository.RemoteRepository;

public class MakefileHelper {
    public static final String MAKEFILE_CAPTURE_FILE = "ANDROID_MAVEN_PLUGIN_LOCAL_C_INCLUDES_FILE";
    public static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0;
    public static final String WINDOWS_DRIVE_ROOT_REGEX = "[a-zA-Z]:\\\\";
    private Log log;
    private final RepositorySystem repoSystem;
    private final RepositorySystemSession repoSession;
    private final List<RemoteRepository> projectRepos;
    private final File unpackedApkLibsDirectory;

    public MakefileHelper(Log log, RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> projectRepos, File unpackedApkLibsDirectory) {
        this.log = log;
        this.repoSystem = repoSystem;
        this.repoSession = repoSession;
        this.projectRepos = projectRepos;
        this.unpackedApkLibsDirectory = unpackedApkLibsDirectory;
    }

    public static void cleanupAfterBuild(MakefileHolder makefileHolder) {
        if (makefileHolder.getIncludeDirectories() != null) {
            for (File file : makefileHolder.getIncludeDirectories()) {
                try {
                    FileUtils.deleteDirectory((File)file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public MakefileHolder createMakefileFromArtifacts(File outputDir, Set<Artifact> artifacts, String ndkArchitecture, boolean useHeaderArchives) throws IOException, MojoExecutionException {
        StringBuilder makeFile = new StringBuilder("# Generated by Android Maven Plugin\n");
        ArrayList<File> includeDirectories = new ArrayList<File>();
        makeFile.append("$(shell echo \"LOCAL_C_INCLUDES=$(LOCAL_C_INCLUDES)\" > $(ANDROID_MAVEN_PLUGIN_LOCAL_C_INCLUDES_FILE))");
        makeFile.append('\n');
        makeFile.append("$(shell echo \"LOCAL_PATH=$(LOCAL_PATH)\" >> $(ANDROID_MAVEN_PLUGIN_LOCAL_C_INCLUDES_FILE))");
        makeFile.append('\n');
        makeFile.append("$(shell echo \"LOCAL_MODULE_FILENAME=$(LOCAL_MODULE_FILENAME)\" >> $(ANDROID_MAVEN_PLUGIN_LOCAL_C_INCLUDES_FILE))");
        makeFile.append('\n');
        makeFile.append("$(shell echo \"LOCAL_MODULE=$(LOCAL_MODULE)\" >> $(ANDROID_MAVEN_PLUGIN_LOCAL_C_INCLUDES_FILE))");
        makeFile.append('\n');
        makeFile.append("$(shell echo \"LOCAL_CFLAGS=$(LOCAL_CFLAGS)\" >> $(ANDROID_MAVEN_PLUGIN_LOCAL_C_INCLUDES_FILE))");
        makeFile.append('\n');
        if (!artifacts.isEmpty()) {
            for (Artifact artifact : artifacts) {
                boolean apklibStatic = false;
                makeFile.append("#\n");
                makeFile.append("# Group ID: ");
                makeFile.append(artifact.getGroupId());
                makeFile.append('\n');
                makeFile.append("# Artifact ID: ");
                makeFile.append(artifact.getArtifactId());
                makeFile.append('\n');
                makeFile.append("# Artifact Type: ");
                makeFile.append(artifact.getType());
                makeFile.append('\n');
                makeFile.append("# Version: ");
                makeFile.append(artifact.getVersion());
                makeFile.append('\n');
                makeFile.append("include $(CLEAR_VARS)");
                makeFile.append('\n');
                makeFile.append("LOCAL_MODULE    := ");
                makeFile.append(artifact.getArtifactId());
                makeFile.append('\n');
                apklibStatic = this.addLibraryDetails(makeFile, outputDir, artifact, ndkArchitecture);
                if (useHeaderArchives) {
                    try {
                        DefaultArtifact harArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope(), "har", artifact.getClassifier(), artifact.getArtifactHandler());
                        Artifact resolvedHarArtifact = AetherHelper.resolveArtifact((Artifact)harArtifact, this.repoSystem, this.repoSession, this.projectRepos);
                        File includeDir = new File(System.getProperty("java.io.tmpdir"), "android_maven_plugin_native_includes" + System.currentTimeMillis() + "_" + resolvedHarArtifact.getArtifactId());
                        includeDir.deleteOnExit();
                        includeDirectories.add(includeDir);
                        JarHelper.unjar(new JarFile(resolvedHarArtifact.getFile()), includeDir, new JarHelper.UnjarListener(){

                            @Override
                            public boolean include(JarEntry jarEntry) {
                                return !jarEntry.getName().startsWith("META-INF");
                            }
                        });
                        makeFile.append("LOCAL_EXPORT_C_INCLUDES := ");
                        String str = includeDir.getAbsolutePath();
                        makeFile.append(str);
                        makeFile.append('\n');
                        if (this.log.isDebugEnabled()) {
                            Collection includes = FileUtils.listFiles((File)includeDir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
                            this.log.debug((CharSequence)("Listing LOCAL_EXPORT_C_INCLUDES for " + artifact.getId() + ": " + includes));
                        }
                    }
                    catch (Exception e) {
                        throw new MojoExecutionException("Error while resolving header archive file for: " + artifact.getArtifactId(), e);
                    }
                }
                if ("a".equals(artifact.getType()) || apklibStatic) {
                    makeFile.append("include $(PREBUILT_STATIC_LIBRARY)\n");
                    continue;
                }
                makeFile.append("include $(PREBUILT_SHARED_LIBRARY)\n");
            }
        }
        return new MakefileHolder(includeDirectories, makeFile.toString());
    }

    private boolean addLibraryDetails(StringBuilder makeFile, File outputDir, Artifact artifact, String ndkArchitecture) throws IOException {
        boolean apklibStatic = false;
        if ("apklib".equals(artifact.getType())) {
            String classifier = artifact.getClassifier();
            String architecture = classifier != null ? classifier : ndkArchitecture;
            File[] staticLibs = NativeHelper.listNativeFiles(artifact, this.unpackedApkLibsDirectory, architecture, true);
            if (staticLibs != null && staticLibs.length > 0) {
                int libIdx = this.findApklibNativeLibrary(staticLibs, artifact.getArtifactId());
                apklibStatic = true;
                this.addLibraryDetails(makeFile, outputDir, staticLibs[libIdx], "");
            } else {
                File[] sharedLibs = NativeHelper.listNativeFiles(artifact, this.unpackedApkLibsDirectory, architecture, false);
                if (sharedLibs == null) {
                    throw new IOException("Failed to find any library file in APKLIB");
                }
                int libIdx = this.findApklibNativeLibrary(sharedLibs, artifact.getArtifactId());
                this.addLibraryDetails(makeFile, outputDir, sharedLibs[libIdx], "");
            }
        } else {
            this.addLibraryDetails(makeFile, outputDir, artifact.getFile(), artifact.getArtifactId());
        }
        return apklibStatic;
    }

    private void addLibraryDetails(StringBuilder makeFile, File outputDir, File libFile, String outputName) throws IOException {
        String localPath = MakefileHelper.resolveRelativePath(outputDir, libFile);
        localPath = localPath.substring(0, localPath.indexOf(libFile.getName()) - 1);
        makeFile.append("LOCAL_PATH := ");
        makeFile.append(localPath);
        makeFile.append('\n');
        makeFile.append("LOCAL_SRC_FILES := ");
        makeFile.append(libFile.getName());
        makeFile.append('\n');
        makeFile.append("LOCAL_MODULE_FILENAME := ");
        if ("".equals(outputName)) {
            makeFile.append(FilenameUtils.removeExtension((String)libFile.getName()));
        } else {
            makeFile.append(outputName);
        }
        makeFile.append('\n');
    }

    private int findApklibNativeLibrary(File[] libs, String artifactName) throws IOException {
        int libIdx = -1;
        if (libs.length == 1) {
            libIdx = 0;
        } else {
            this.log.info((CharSequence)"Found multiple library files, looking for name match with artifact");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < libs.length; ++i) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(libs[i].getName());
                if (!libs[i].getName().startsWith("lib" + artifactName)) continue;
                if (libIdx != -1) {
                    throw new IOException("Found multiple libraries matching artifact name " + artifactName + ". Please use unique artifact/library names.");
                }
                libIdx = i;
            }
            if (libIdx < 0) {
                throw new IOException("Unable to determine main library from " + sb.toString() + " APKLIB should contain only 1 library or a library matching the artifact name");
            }
        }
        return libIdx;
    }

    protected static String resolveRelativePath(File outputDirectory, File file) throws IOException {
        String resolvedPath = file.getCanonicalPath();
        String strOutputDirectoryPath = outputDirectory.getCanonicalPath();
        String strFilePath = file.getCanonicalPath();
        if (strFilePath.startsWith(strOutputDirectoryPath)) {
            resolvedPath = strFilePath.substring(strOutputDirectoryPath.length() + 1);
        } else {
            List<String> outputDirectoryPathParts = MakefileHelper.splitPath(outputDirectory.getCanonicalFile());
            List<String> filePathParts = MakefileHelper.splitPath(file.getCanonicalFile());
            int commonDepth = 0;
            int maxCommonDepth = Math.min(outputDirectoryPathParts.size(), filePathParts.size());
            for (int i = 0; i < maxCommonDepth && outputDirectoryPathParts.get(i).equals(filePathParts.get(i)); ++i) {
                ++commonDepth;
            }
            if (commonDepth > 0) {
                int i;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("..");
                for (i = 0; i < outputDirectoryPathParts.size() - commonDepth - 1; ++i) {
                    stringBuilder.append(File.separator);
                    stringBuilder.append("..");
                }
                for (i = commonDepth; i < filePathParts.size(); ++i) {
                    stringBuilder.append(File.separator);
                    stringBuilder.append(filePathParts.get(i));
                }
                resolvedPath = stringBuilder.toString();
            } else {
                if (IS_WINDOWS) {
                    throw new IOException("Unable to resolve relative path across windows drives");
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (File depthCheck = outputDirectory.getParentFile(); depthCheck != null; depthCheck = depthCheck.getParentFile()) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(File.separator);
                    }
                    stringBuilder.append("..");
                }
                resolvedPath = stringBuilder.toString() + strFilePath;
            }
        }
        return resolvedPath;
    }

    protected static List<String> splitPath(File f) {
        List<String> result;
        File parent = f.getParentFile();
        if (parent == null) {
            String strF;
            result = new ArrayList<String>();
            if (f.getName().length() > 0) {
                result.add(f.getName());
            } else if (IS_WINDOWS && (strF = f.toString()).matches(WINDOWS_DRIVE_ROOT_REGEX)) {
                result.add(strF.substring(0, strF.length() - 1).toUpperCase());
            }
        } else {
            result = MakefileHelper.splitPath(parent);
            result.add(f.getName());
        }
        return result;
    }

    public String createLibraryList(Set<Artifact> resolvedLibraryList, String ndkArchitecture, boolean staticLibrary) {
        StringBuilder sb = new StringBuilder();
        for (Artifact a : resolvedLibraryList) {
            File[] libFiles;
            if (staticLibrary && "a".equals(a.getType())) {
                sb.append(a.getArtifactId());
            }
            if (!staticLibrary && "so".equals(a.getType())) {
                sb.append(a.getArtifactId());
            }
            if ("apklib".equals(a.getType()) && (libFiles = NativeHelper.listNativeFiles(a, this.unpackedApkLibsDirectory, ndkArchitecture, staticLibrary)) != null && libFiles.length > 0) {
                sb.append(a.getArtifactId());
            }
            sb.append(" ");
        }
        return sb.toString();
    }

    public static class MakefileHolder {
        String makeFile;
        List<File> includeDirectories;

        public MakefileHolder(List<File> includeDirectories, String makeFile) {
            this.includeDirectories = includeDirectories;
            this.makeFile = makeFile;
        }

        public List<File> getIncludeDirectories() {
            return this.includeDirectories;
        }

        public String getMakeFile() {
            return this.makeFile;
        }
    }
}

