/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.pipeline;

import com.itextpdf.tool.xml.CustomContext;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Pipeline;
import com.itextpdf.tool.xml.PipelineException;
import com.itextpdf.tool.xml.ProcessObject;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPipeline<T extends CustomContext>
implements Pipeline<T> {
    private final ThreadLocal<WorkerContext> wc = new ThreadLocal();
    private Pipeline<?> next;

    public AbstractPipeline(Pipeline<?> next) {
        this.setNext(next);
    }

    @Override
    public final void setContext(WorkerContext context) {
        this.wc.set(context);
    }

    @Override
    public Pipeline<?> getNext() {
        return this.next;
    }

    public final WorkerContext getContext() {
        return this.wc.get();
    }

    @Override
    public Pipeline<?> open(Tag t, ProcessObject po) throws PipelineException {
        return this.getNext();
    }

    @Override
    public Pipeline<?> content(Tag t, byte[] content, ProcessObject po) throws PipelineException {
        return this.getNext();
    }

    @Override
    public Pipeline<?> close(Tag t, ProcessObject po) throws PipelineException {
        return this.getNext();
    }

    @Override
    public T getNewCustomContext() throws NoCustomContextException {
        throw new NoCustomContextException();
    }

    @Override
    public T getLocalContext() throws PipelineException {
        try {
            CustomContext cc = this.getContext().get(this.getClass().getName());
            if (null != cc) {
                return (T)cc;
            }
            throw new PipelineException(String.format(LocaleMessages.getInstance().getMessage("pipeline.owncontextmissing"), this.getClass().getName()));
        }
        catch (NoCustomContextException e) {
            throw new PipelineException(String.format(LocaleMessages.getInstance().getMessage("pipeline.owncontextmissing"), this.getClass().getName()), e);
        }
    }

    public void setNext(Pipeline<?> next) {
        this.next = next;
    }

    @Override
    public String getContextKey() {
        return this.getClass().getName();
    }
}

