/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.number;

import com.ibm.icu.impl.number.DecimalQuantity;
import com.ibm.icu.impl.number.PatternStringParser;

@Deprecated
public class Grouper {
    private static final byte N2 = -2;
    private static final byte N1 = -1;
    private static final byte B2 = 2;
    private static final byte B3 = 3;
    private static final Grouper DEFAULTS = new Grouper(-2, -2, false);
    private static final Grouper MIN2 = new Grouper(-2, -2, true);
    private static final Grouper NONE = new Grouper(-1, -1, false);
    private final byte grouping1;
    private final byte grouping2;
    private final boolean min2;
    private static final Grouper GROUPING_3 = new Grouper(3, 3, false);
    private static final Grouper GROUPING_3_2 = new Grouper(3, 2, false);
    private static final Grouper GROUPING_3_MIN2 = new Grouper(3, 3, true);
    private static final Grouper GROUPING_3_2_MIN2 = new Grouper(3, 2, true);

    private Grouper(byte grouping1, byte grouping2, boolean min2) {
        this.grouping1 = grouping1;
        this.grouping2 = grouping2;
        this.min2 = min2;
    }

    @Deprecated
    public static Grouper defaults() {
        return DEFAULTS;
    }

    @Deprecated
    public static Grouper minTwoDigits() {
        return MIN2;
    }

    @Deprecated
    public static Grouper none() {
        return NONE;
    }

    static Grouper getInstance(byte grouping1, byte grouping2, boolean min2) {
        if (grouping1 == -1) {
            return NONE;
        }
        if (!min2 && grouping1 == 3 && grouping2 == 3) {
            return GROUPING_3;
        }
        if (!min2 && grouping1 == 3 && grouping2 == 2) {
            return GROUPING_3_2;
        }
        if (min2 && grouping1 == 3 && grouping2 == 3) {
            return GROUPING_3_MIN2;
        }
        if (min2 && grouping1 == 3 && grouping2 == 2) {
            return GROUPING_3_2_MIN2;
        }
        return new Grouper(grouping1, grouping2, min2);
    }

    Grouper withLocaleData(PatternStringParser.ParsedPatternInfo patternInfo) {
        if (this.grouping1 != -2) {
            return this;
        }
        byte grouping1 = (byte)(patternInfo.positive.groupingSizes & 0xFFFFL);
        byte grouping2 = (byte)(patternInfo.positive.groupingSizes >>> 16 & 0xFFFFL);
        byte grouping3 = (byte)(patternInfo.positive.groupingSizes >>> 32 & 0xFFFFL);
        if (grouping2 == -1) {
            grouping1 = -1;
        }
        if (grouping3 == -1) {
            grouping2 = grouping1;
        }
        return Grouper.getInstance(grouping1, grouping2, this.min2);
    }

    boolean groupAtPosition(int position, DecimalQuantity value) {
        assert (this.grouping1 != -2);
        if (this.grouping1 == -1 || this.grouping1 == 0) {
            return false;
        }
        return (position -= this.grouping1) >= 0 && position % this.grouping2 == 0 && value.getUpperDisplayMagnitude() - this.grouping1 + 1 >= (this.min2 ? 2 : 1);
    }
}

