/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.lib;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.tdb.TDBException;
import org.openjena.atlas.lib.Chars;
import org.openjena.riot.system.PrefixMap;
import org.openjena.riot.system.Prologue;
import org.openjena.riot.system.RiotChars;

public class NodeFmtLib {
    private static final boolean onlySafeBNodeLabels = false;
    static char encodeMarkerChar = (char)88;
    static char[] invalidBNodeLabelChars = new char[]{encodeMarkerChar, ':', '-'};

    public static String str(Triple t) {
        return NodeFmtLib.serialize(t.getSubject()) + " " + NodeFmtLib.serialize(t.getPredicate()) + " " + NodeFmtLib.serialize(t.getObject());
    }

    public static String str(Quad q) {
        return NodeFmtLib.serialize(q.getGraph()) + " " + NodeFmtLib.serialize(q.getSubject()) + " " + NodeFmtLib.serialize(q.getPredicate()) + " " + NodeFmtLib.serialize(q.getObject());
    }

    public static String displayStr(Node n) {
        return FmtUtils.stringForNode((Node)n);
    }

    public static String serialize(Node n) {
        return NodeFmtLib.serialize(n, null, null);
    }

    public static String serialize(Node n, Prologue prologue) {
        return NodeFmtLib.serialize(n, prologue.getBaseURI(), prologue.getPrefixMap());
    }

    public static String serialize(Node n, String base, PrefixMap prefixMap) {
        if (n == null) {
            return "<<null>>";
        }
        if (n.isBlank()) {
            String str = n.getBlankNodeLabel();
            return "_:" + str;
        }
        if (n.isLiteral()) {
            return FmtUtils.stringForLiteral((Node_Literal)((Node_Literal)n), null);
        }
        if (n.isURI()) {
            String uri = n.getURI();
            return NodeFmtLib.stringForURI(uri, base, prefixMap);
        }
        if (n.isVariable()) {
            return "?" + n.getName();
        }
        throw new TDBException("Failed to turn a node into a string: " + n);
    }

    static String stringForURI(String uri, String base, PrefixMap mapping) {
        String x;
        String pname;
        if (mapping != null && (pname = mapping.abbreviate(uri)) != null) {
            return pname;
        }
        if (base != null && (x = FmtUtils.abbrevByBase((String)uri, (String)base)) != null) {
            return "<" + x + ">";
        }
        return FmtUtils.stringForURI((String)uri);
    }

    public static String safeBNodeLabel(String label) {
        StringBuilder buff = new StringBuilder();
        buff.append("B");
        for (int i = 0; i < label.length(); ++i) {
            char ch = label.charAt(i);
            if (RiotChars.isA2ZN((int)ch)) {
                buff.append(ch);
                continue;
            }
            Chars.encodeAsHex((StringBuilder)buff, (char)encodeMarkerChar, (char)ch);
        }
        return buff.toString();
    }

    public static String displayStr(Triple t, PrefixMapping prefixMapping) {
        return FmtUtils.stringForTriple((Triple)t, (PrefixMapping)prefixMapping);
    }

    public static String displayStr(RDFNode obj) {
        return FmtUtils.stringForRDFNode((RDFNode)obj);
    }
}

