/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.file;

import com.hp.hpl.jena.tdb.base.block.BlockException;
import com.hp.hpl.jena.tdb.base.file.FileException;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.file.PlainFile;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainFilePersistent
extends PlainFile {
    private static Logger log = LoggerFactory.getLogger(PlainFilePersistent.class);
    private FileChannel channel;
    private RandomAccessFile out;
    private String filename;

    PlainFilePersistent(Location loc, String filename) {
        this(loc.getPath(filename, "dat"));
    }

    PlainFilePersistent(String filename) {
        try {
            this.filename = filename;
            this.out = new RandomAccessFile(filename, "rw");
            long filesize = this.out.length();
            this.channel = this.out.getChannel();
            this.byteBuffer = this.allocateBuffer(filesize);
        }
        catch (IOException ex) {
            throw new FileException("Failed to create BlockMgrFile", ex);
        }
    }

    protected PlainFilePersistent() {
        this.channel = null;
        this.out = null;
    }

    public void sync() {
        try {
            this.channel.force(false);
        }
        catch (IOException ex) {
            throw new FileException("force", ex);
        }
    }

    public void close() {
        try {
            this.out.close();
            this.channel = null;
            this.out = null;
        }
        catch (IOException ex) {
            throw new BlockException("BlockMgrMapped.close", ex);
        }
    }

    protected ByteBuffer allocateBuffer(long size) {
        try {
            return this.channel.map(FileChannel.MapMode.READ_WRITE, 0L, size);
        }
        catch (IOException ex) {
            throw new FileException("allocateBuffer", ex);
        }
    }
}

