/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorExpr;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.sse.writers.WriterExpr;
import com.hp.hpl.jena.sparql.util.ExprUtils;

public class AggSampleDistinct
extends AggregatorBase {
    private final Expr expr;

    public AggSampleDistinct(Expr expr) {
        this.expr = expr;
    }

    public Aggregator copy(Expr expr) {
        return new AggSampleDistinct(expr);
    }

    public String toString() {
        return "SAMPLE(DISTINCT " + ExprUtils.fmtSPARQL(this.expr) + ")";
    }

    public String toPrefixString() {
        return "(sample distinct" + WriterExpr.asString(this.expr) + ")";
    }

    protected Accumulator createAccumulator() {
        return new AccSampleDistict(this.expr);
    }

    public Expr getExpr() {
        return this.expr;
    }

    public int hashCode() {
        return 0x17A ^ this.expr.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggSampleDistinct)) {
            return false;
        }
        AggSampleDistinct agg = (AggSampleDistinct)other;
        return agg.getExpr().equals(this.getExpr());
    }

    public Node getValueEmpty() {
        return null;
    }

    private static class AccSampleDistict
    extends AccumulatorExpr {
        private NodeValue sampleSoFar = null;

        public AccSampleDistict(Expr expr) {
            super(expr);
        }

        public void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            this.sampleSoFar = nv;
        }

        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        public NodeValue getAccValue() {
            return this.sampleSoFar;
        }
    }
}

