package com.herbocailleau.sgq.entities;

import java.util.ArrayList;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class SgqConfigurationAbstract extends TopiaEntityAbstract implements SgqConfiguration {

    /**
     * Nom de l'attribut en BD : key
     */
    protected String key;

    /**
     * Nom de l'attribut en BD : value
     */
    protected String value;

    private static final long serialVersionUID = 7162466361958281317L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_KEY, String.class, key);
        visitor.visit(this, PROPERTY_VALUE, String.class, value);
        visitor.end(this);
    }

    @Override
    public void setKey(String key) {
        String oldValue = this.key;
        fireOnPreWrite(PROPERTY_KEY, oldValue, key);
        this.key = key;
        fireOnPostWrite(PROPERTY_KEY, oldValue, key);
    }

    @Override
    public String getKey() {
        fireOnPreRead(PROPERTY_KEY, key);
        String result = this.key;
        fireOnPostRead(PROPERTY_KEY, key);
        return result;
    }

    @Override
    public void setValue(String value) {
        String oldValue = this.value;
        fireOnPreWrite(PROPERTY_VALUE, oldValue, value);
        this.value = value;
        fireOnPostWrite(PROPERTY_VALUE, oldValue, value);
    }

    @Override
    public String getValue() {
        fireOnPreRead(PROPERTY_VALUE, value);
        String result = this.value;
        fireOnPostRead(PROPERTY_VALUE, value);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //SgqConfigurationAbstract
