/*
 * #%L
 * SGQ :: Business
 * $Id: SearchModel.java 400 2013-06-23 12:38:25Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1/sgq-business/src/main/java/com/herbocailleau/sgq/business/model/SearchModel.java $
 * %%
 * Copyright (C) 2012, 2013 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Country;
import com.herbocailleau.sgq.entities.ProductStatus;
import com.herbocailleau.sgq.entities.SynthesisMention;

/**
 * Objet contenant les données de la requete saisie à partir de l'interface
 * graphique.
 * 
 * @author echatellier
 */
public class SearchModel {

    /**
     * Type de date supporté par le moteur de recherche.
     */
    public enum DateType {
        ENTRY_DATE, DLUO, DMES, DPMES, DMESD, EXPIRED_DATE
    }

    /**
     * Choix possible sur le champ date d'expiration.
     */
    public enum ExpiredType {
        NON_EXPIRED, EXPIRED, ALL
    }

    protected String query;

    protected String client;

    protected Country origin;
    
    protected String supplier;

    protected List<ProductStatus> productStatus;

    protected List<String> productCategories;

    protected List<AnalyzeType> analyzeTypes;

    protected boolean analyzeTypeOrOperator;

    protected DateType dateType;

    protected Date beginDate;

    protected Date endDate;

    protected SynthesisMention synthesisMention;

    protected List<SearchColumn> searchColumns;

    protected ExpiredType expired;

    public SearchModel() {
        // init columns with default selected ones
        searchColumns = new ArrayList<SearchColumn>();
        for (SearchColumn searchColumn : SearchColumn.values()) {
            if (searchColumn.isDefaultSelected()) {
                searchColumns.add(searchColumn);
            }
        }
        
        expired = ExpiredType.NON_EXPIRED;
    }

    public SearchModel(String query) {
        this();
        this.query = query;
    }

    public String getQuery() {
        return query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getClient() {
        return client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public Country getOrigin() {
        return origin;
    }

    public void setOrigin(Country origin) {
        this.origin = origin;
    }

    public String getSupplier() {
        return supplier;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier;
    }

    public List<ProductStatus> getProductStatus() {
        return productStatus;
    }

    public void setProductStatus(List<ProductStatus> productStatus) {
        this.productStatus = productStatus;
    }

    public List<String> getProductCategories() {
        return productCategories;
    }

    public void setProductCategories(List<String> productCategories) {
        this.productCategories = productCategories;
    }

    public List<AnalyzeType> getAnalyzeTypes() {
        return analyzeTypes;
    }

    public void setAnalyzeTypes(List<AnalyzeType> analyzeTypes) {
        this.analyzeTypes = analyzeTypes;
    }

    public boolean isAnalyzeTypeOrOperator() {
        return analyzeTypeOrOperator;
    }

    public void setAnalyzeTypeOrOperator(boolean analyzeTypeOrOperator) {
        this.analyzeTypeOrOperator = analyzeTypeOrOperator;
    }

    public DateType getDateType() {
        return dateType;
    }

    public void setDateType(DateType dateType) {
        this.dateType = dateType;
    }

    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public SynthesisMention getSynthesisMention() {
        return synthesisMention;
    }

    public void setSynthesisMention(SynthesisMention synthesisMention) {
        this.synthesisMention = synthesisMention;
    }

    public List<SearchColumn> getSearchColumns() {
        return searchColumns;
    }

    public void setSearchColumns(List<SearchColumn> searchColumns) {
        this.searchColumns = searchColumns;
    }

    public ExpiredType getExpired() {
        return expired;
    }

    public void setExpired(ExpiredType expired) {
        this.expired = expired;
    }
}
