/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business;

import com.herbocailleau.sgq.business.SgqBusinessException;
import java.util.Properties;
import org.nuiton.util.config.ApplicationConfig;
import org.nuiton.util.config.ArgumentsParserException;

public class SgqBusinessConfig {
    protected ApplicationConfig config = new ApplicationConfig();

    public SgqBusinessConfig() {
        for (SgqBusinessOption o : SgqBusinessOption.values()) {
            if (o.defaultValue == null) continue;
            this.config.setDefaultOption(o.key, o.defaultValue);
        }
    }

    public ApplicationConfig getConfig() {
        return this.config;
    }

    public void parse() {
        try {
            this.config.parse(new String[0]);
        }
        catch (ArgumentsParserException ex) {
            throw new SgqBusinessException("Can't load configuration", ex);
        }
    }

    public Properties getFlatOptions() {
        return this.config.getFlatOptions();
    }

    public String getApplicationVersion() {
        return this.config.getOption("application.version");
    }

    public String getDocumentationUrl() {
        return this.config.getOption(SgqBusinessOption.SGQ_DOCUMENTATION_URL.key);
    }

    public int getBatchRangeNonBioStart() {
        return this.config.getOptionAsInt(SgqBusinessOption.BATCH_RANGE_NONBIO_START.key);
    }

    public int getBatchRangeNonBioEnd() {
        return this.config.getOptionAsInt(SgqBusinessOption.BATCH_RANGE_NONBIO_END.key);
    }

    public int getBatchRangeBioStart() {
        return this.config.getOptionAsInt(SgqBusinessOption.BATCH_RANGE_BIO_START.key);
    }

    public int getBatchRangeBioEnd() {
        return this.config.getOptionAsInt(SgqBusinessOption.BATCH_RANGE_BIO_END.key);
    }

    public String getLabelProductionFilename() {
        return this.config.getOption(SgqBusinessOption.LABEL_PRODUCTION_FILENAME.key);
    }

    public String getLabelExpeditionFilename() {
        return this.config.getOption(SgqBusinessOption.LABEL_EXPEDITION_FILENAME.key);
    }

    public String getImportCsvFileEncoding() {
        return this.config.getOption(SgqBusinessOption.IMPORT_CSV_FILE_ENCODING.key);
    }

    public String getImportDbfFileEncoding() {
        return this.config.getOption(SgqBusinessOption.IMPORT_DBF_FILE_ENCODING.key);
    }

    public String getBackupDevicesCommand() {
        return this.config.getOption(SgqBusinessOption.BACKUP_DEVICES_COMMAND.key);
    }

    public String getBackupPerformCommand() {
        return this.config.getOption(SgqBusinessOption.BACKUP_PERFORM_COMMAND.key);
    }

    public String getDatabaseUsername() {
        return this.config.getOption(SgqBusinessOption.HIBERNATE_CONNETION_USERNAME.key);
    }

    public boolean isDevMode() {
        return this.config.getOptionAsBoolean(SgqBusinessOption.DEV_MODE.key);
    }

    static enum SgqBusinessOption {
        CONFIG_FILE("config.file", "sgqweb.properties"),
        SGQ_DIRECTORY("sgq.directory", "${java.io.tmpdir}/sgq"),
        SGQ_DOCUMENTATION_URL("sgq.documentation.url", "http://maven-site.forge.codelutin.com/sgq-ch/"),
        HIBERNATE_DIALECT("hibernate.dialect", "org.hibernate.dialect.H2Dialect"),
        HIBERNATE_CONNECTION_URL("hibernate.connection.url", "jdbc:h2:file:${sgq.directory}/data/sgq"),
        HIBERNATE_CONNETION_USERNAME("hibernate.connection.username", "sa"),
        HIBERNATE_CONNECTION_PASSWORD("hibernate.connection.password", ""),
        IMPORT_CSV_FILE_ENCODING("import.csv.file.encoding", "UTF-8"),
        IMPORT_DBF_FILE_ENCODING("import.dbf.file.encoding", "Cp437"),
        BATCH_RANGE_NONBIO_START("batch.range.nonbio.start", "22105"),
        BATCH_RANGE_NONBIO_END("batch.range.nonbio.end", "69999"),
        BATCH_RANGE_BIO_START("batch.range.bio.start", "71716"),
        BATCH_RANGE_BIO_END("batch.range.bio.end", "89999"),
        LABEL_PRODUCTION_FILENAME("label.production.filename", "FIF_HIST.txt"),
        LABEL_EXPEDITION_FILENAME("label.expedition.filename", "FIC_HIST.txt"),
        BACKUP_DEVICES_SCRIPT("backup.devices.script", "/var/local/sgq/sgq-backup-devices.sh"),
        BACKUP_DEVICES_COMMAND("backup.devices.command", "${backup.devices.script}"),
        BACKUP_PERFORM_SCRIPT("backup.perform.script", "/var/local/sgq/sgq-backup-perform.sh"),
        BACKUP_PERFORM_COMMAND("backup.perform.command", "${backup.perform.script} %d sa sgq %f %m"),
        DEV_MODE("dev.mode", "false");

        protected String key;
        protected String defaultValue;

        private SgqBusinessOption(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }
    }
}

