/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.business.model.PresentationModel;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.BatchDAOImpl;
import com.herbocailleau.sgq.entities.Expedition;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.entities.Presentation;
import com.herbocailleau.sgq.entities.PresentationDAOAbstract;
import com.herbocailleau.sgq.entities.ProductPlace;
import com.herbocailleau.sgq.entities.Production;
import com.herbocailleau.sgq.entities.Zone;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.TopiaException;

public class PresentationDAOImpl<E extends Presentation>
extends PresentationDAOAbstract<E> {
    public List<Presentation> findAllNonExpiredValid(String productName) throws TopiaException {
        String query = "from " + Presentation.class.getName() + " where " + "batch" + "." + "expiredDate" + " = null" + " and " + "batch" + "." + "invalid" + " = false";
        List result = null;
        if (StringUtils.isNotBlank((CharSequence)productName)) {
            query = query + " and " + BatchDAOImpl.getFieldLikeInsensitive("batch.product.name", ":product");
            result = this.context.findAll(query, new Object[]{"product", "%" + StringUtils.stripAccents((String)productName) + "%"});
        } else {
            result = this.context.findAll(query, new Object[0]);
        }
        return result;
    }

    public List<PresentationModel> findAllNonExpiredValidModel(String product) throws TopiaException {
        String query = "select P, PP.place, (select count(*) from " + Production.class.getName() + "  where " + "presentation" + " = P and " + "destination" + " = :ze)," + " (select count(*) from " + Production.class.getName() + "  where " + "presentation" + " = P and " + "destination" + " = :zp) + " + " (select count(*) from " + Expedition.class.getName() + "  where " + "presentation" + " = P and " + "destination" + " = :zp)," + " (select count(*) from " + Expedition.class.getName() + "  where " + "presentation" + " = P and " + "destination" + " = :zc)" + " from " + Presentation.class.getName() + " P," + " " + ProductPlace.class.getName() + " PP" + " where P." + "batch" + "." + "expiredDate" + " = null" + " and P." + "batch" + "." + "invalid" + " = false" + " and P.batch.product = PP.product" + " and PP.presentationCode = P.presentationCode";
        List lines = null;
        if (StringUtils.isNotBlank((CharSequence)product)) {
            query = query + " and (" + BatchDAOImpl.getFieldLikeInsensitive("P.batch.product.name", ":product") + " or " + BatchDAOImpl.getFieldLikeInsensitive("P.batch.product.code", ":product") + ")";
            lines = this.context.findAll(query, new Object[]{"product", "%" + StringUtils.stripAccents((String)product) + "%", "ze", Zone.ZE, "zc", Zone.ZC, "zp", Zone.ZP});
        } else {
            lines = this.context.findAll(query, new Object[]{"ze", Zone.ZE, "zc", Zone.ZC, "zp", Zone.ZP});
        }
        Collections.sort(lines, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                Zone o2Zone;
                int result = -1;
                Zone o1Zone = ((Place)o1[1]).getZone();
                if (o1Zone == (o2Zone = ((Place)o2[1]).getZone())) {
                    result = 0;
                } else {
                    switch (((Place)o1[1]).getZone()) {
                        case ZC: {
                            result = 1;
                            break;
                        }
                        case ZP: {
                            if (o2Zone != Zone.ZE) break;
                            result = 1;
                        }
                    }
                }
                return result;
            }
        });
        HashMap<Presentation, PresentationModel> presentationCache = new HashMap<Presentation, PresentationModel>();
        for (Object[] line : lines) {
            Presentation presentation = (Presentation)line[0];
            Place place = (Place)line[1];
            long labelToZeCount = ((Number)line[2]).longValue();
            long labelToZpCount = ((Number)line[3]).longValue();
            long labelToZcCount = ((Number)line[4]).longValue();
            PresentationModel model = (PresentationModel)presentationCache.get(presentation);
            if (model == null) {
                model = new PresentationModel(presentation);
                presentationCache.put(presentation, model);
            }
            if ((place.getZone() != Zone.ZE || !presentation.isOriginal() && labelToZeCount <= 0L) && (place.getZone() != Zone.ZP || (!model.getPlaces().isEmpty() || !presentation.isOriginal()) && labelToZpCount <= 0L) && (place.getZone() != Zone.ZC || (!model.getPlaces().isEmpty() || !presentation.isOriginal()) && labelToZcCount <= 0L)) continue;
            model.addPlace(place);
        }
        query = "select P from " + Presentation.class.getName() + " P" + " where P." + "batch" + "." + "expiredDate" + " = null" + " and P." + "batch" + "." + "invalid" + " = false" + " and P.batch.product not in (select PP.product FROM " + ProductPlace.class.getName() + " PP" + "  where PP.presentationCode = P.presentationCode)";
        List presentations = this.context.findAll(query, new Object[0]);
        for (Presentation presentation : presentations) {
            PresentationModel model = new PresentationModel(presentation);
            presentationCache.put(presentation, model);
        }
        ArrayList<PresentationModel> result = new ArrayList<PresentationModel>(presentationCache.values());
        Collections.sort(result, new Comparator<PresentationModel>(){

            @Override
            public int compare(PresentationModel o1, PresentationModel o2) {
                int result = o1.getPresentation().getPresentationCode().ordinal() - o2.getPresentation().getPresentationCode().ordinal();
                return result;
            }
        });
        return result;
    }

    public List<PresentationModel> findAllByBatchOrderByPresentation(Batch batch) throws TopiaException {
        String query = "select P, PP.place, (select count(*) from " + Production.class.getName() + "  where " + "presentation" + " = P and " + "destination" + " = :ze)," + " (select count(*) from " + Production.class.getName() + "  where " + "presentation" + " = P and " + "destination" + " = :zp) + " + " (select count(*) from " + Expedition.class.getName() + "  where " + "presentation" + " = P and " + "destination" + " = :zp)," + " (select count(*) from " + Expedition.class.getName() + "  where " + "presentation" + " = P and " + "destination" + " = :zc)" + " from " + Presentation.class.getName() + " P," + " " + ProductPlace.class.getName() + " PP" + " where P." + "batch" + " = :batch" + " and P.batch.product = PP.product" + " and PP.presentationCode = P.presentationCode";
        List lines = this.context.findAll(query, new Object[]{"batch", batch, "ze", Zone.ZE, "zp", Zone.ZP, "zc", Zone.ZC});
        Collections.sort(lines, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                Zone o2Zone;
                int result = -1;
                Zone o1Zone = ((Place)o1[1]).getZone();
                if (o1Zone == (o2Zone = ((Place)o2[1]).getZone())) {
                    result = 0;
                } else {
                    switch (((Place)o1[1]).getZone()) {
                        case ZC: {
                            result = 1;
                            break;
                        }
                        case ZP: {
                            if (o2Zone != Zone.ZE) break;
                            result = 1;
                        }
                    }
                }
                return result;
            }
        });
        HashMap<Presentation, PresentationModel> presentationCache = new HashMap<Presentation, PresentationModel>();
        for (Object[] line : lines) {
            Presentation presentation = (Presentation)line[0];
            Place place = (Place)line[1];
            long labelToZeCount = ((Number)line[2]).longValue();
            long labelToZpCount = ((Number)line[3]).longValue();
            long labelToZcCount = ((Number)line[4]).longValue();
            PresentationModel model = (PresentationModel)presentationCache.get(presentation);
            if (model == null) {
                model = new PresentationModel(presentation);
                presentationCache.put(presentation, model);
            }
            if ((place.getZone() != Zone.ZE || !presentation.isOriginal() && labelToZeCount <= 0L) && (place.getZone() != Zone.ZP || (!model.getPlaces().isEmpty() || !presentation.isOriginal()) && labelToZpCount <= 0L) && (place.getZone() != Zone.ZC || (!model.getPlaces().isEmpty() || !presentation.isOriginal()) && labelToZcCount <= 0L)) continue;
            model.addPlace(place);
        }
        query = "select P from " + Presentation.class.getName() + " P" + " where P." + "batch" + " = :batch" + " and P.batch.product not in (select PP.product FROM " + ProductPlace.class.getName() + " PP" + "  where PP.presentationCode = P.presentationCode)";
        List presentations = this.context.findAll(query, new Object[]{"batch", batch});
        for (Presentation presentation : presentations) {
            PresentationModel model = new PresentationModel(presentation);
            presentationCache.put(presentation, model);
        }
        ArrayList<PresentationModel> result = new ArrayList<PresentationModel>(presentationCache.values());
        Collections.sort(result, new Comparator<PresentationModel>(){

            @Override
            public int compare(PresentationModel o1, PresentationModel o2) {
                int result = o1.getPresentation().getPresentationCode().ordinal() - o2.getPresentation().getPresentationCode().ordinal();
                return result;
            }
        });
        return result;
    }

    public void setPresentationQuantityToZero(Batch batch) throws TopiaException {
        String query = "update " + Presentation.class.getName() + " set quantity = 0" + " where batch = :batch";
        this.context.execute(query, new Object[]{"batch", batch});
    }
}

