package com.herbocailleau.sgq.entities;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class PresentationAbstract extends TopiaEntityAbstract implements Presentation {

    /**
     * Nom de l'attribut en BD : quantity
     */
    protected double quantity;

    /**
     * Nom de l'attribut en BD : dmesd
     */
    protected Date dmesd;

    /**
     * Nom de l'attribut en BD : batch
     */
    protected Batch batch;

    /**
     * Nom de l'attribut en BD : presentationCode
     */
    protected PresentationCode presentationCode;

    private static final long serialVersionUID = 7005457395135558704L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_QUANTITY, double.class, quantity);
        visitor.visit(this, PROPERTY_DMESD, Date.class, dmesd);
        visitor.visit(this, PROPERTY_BATCH, Batch.class, batch);
        visitor.visit(this, PROPERTY_PRESENTATION_CODE, PresentationCode.class, presentationCode);
        visitor.end(this);
    }

    @Override
    public void setQuantity(double quantity) {
        double oldValue = this.quantity;
        fireOnPreWrite(PROPERTY_QUANTITY, oldValue, quantity);
        this.quantity = quantity;
        fireOnPostWrite(PROPERTY_QUANTITY, oldValue, quantity);
    }

    @Override
    public double getQuantity() {
        fireOnPreRead(PROPERTY_QUANTITY, quantity);
        double result = this.quantity;
        fireOnPostRead(PROPERTY_QUANTITY, quantity);
        return result;
    }

    @Override
    public void setDmesd(Date dmesd) {
        Date oldValue = this.dmesd;
        fireOnPreWrite(PROPERTY_DMESD, oldValue, dmesd);
        this.dmesd = dmesd;
        fireOnPostWrite(PROPERTY_DMESD, oldValue, dmesd);
    }

    @Override
    public Date getDmesd() {
        fireOnPreRead(PROPERTY_DMESD, dmesd);
        Date result = this.dmesd;
        fireOnPostRead(PROPERTY_DMESD, dmesd);
        return result;
    }

    @Override
    public void setBatch(Batch batch) {
        Batch oldValue = this.batch;
        fireOnPreWrite(PROPERTY_BATCH, oldValue, batch);
        this.batch = batch;
        fireOnPostWrite(PROPERTY_BATCH, oldValue, batch);
    }

    @Override
    public Batch getBatch() {
        fireOnPreRead(PROPERTY_BATCH, batch);
        Batch result = this.batch;
        fireOnPostRead(PROPERTY_BATCH, batch);
        return result;
    }

    @Override
    public void setPresentationCode(PresentationCode presentationCode) {
        PresentationCode oldValue = this.presentationCode;
        fireOnPreWrite(PROPERTY_PRESENTATION_CODE, oldValue, presentationCode);
        this.presentationCode = presentationCode;
        fireOnPostWrite(PROPERTY_PRESENTATION_CODE, oldValue, presentationCode);
    }

    @Override
    public PresentationCode getPresentationCode() {
        fireOnPreRead(PROPERTY_PRESENTATION_CODE, presentationCode);
        PresentationCode result = this.presentationCode;
        fireOnPostRead(PROPERTY_PRESENTATION_CODE, presentationCode);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //PresentationAbstract
