package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.SGQDAOHelper.SGQEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class ProductDAOAbstract<E extends Product> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Product.class;
    }

    @Override
    public SGQEntityEnum getTopiaEntityEnum() {
        return SGQEntityEnum.Product;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Batch> list = getContext()
                                                    .getDAO(Batch.class)
                                                    .findAllByProperties(Batch.PROPERTY_PRODUCT, entity);
                                            for (Batch item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getProduct())) {
                                                    item.setProduct(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByNaturalId(String code) throws TopiaException {
        return findByProperties(Product.PROPERTY_CODE, code);
    }

    public boolean existByNaturalId(String code) throws TopiaException {
        return existByProperties(Product.PROPERTY_CODE, code);
    }

    /**
     * @deprecated since 2.6.10, prefer use {@link #createByNaturalId}
     * @param code 
     * @return 
     * @throws TopiaException
     */
    @Deprecated
    public E create(String code) throws TopiaException {
        return create(Product.PROPERTY_CODE, code);
    }

    public E createByNaturalId(String code) throws TopiaException {
        return create(Product.PROPERTY_CODE, code);
    }

    public E createByNotNull(String code) throws TopiaException {
        return create(Product.PROPERTY_CODE, code);
    }

    public E findByCode(String v) throws TopiaException {
        E result = findByProperty(Product.PROPERTY_CODE, v);
        return result;
    }

    public List<E> findAllByCode(String v) throws TopiaException {
        List<E> result = findAllByProperty(Product.PROPERTY_CODE, v);
        return result;
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Product.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Product.PROPERTY_NAME, v);
        return result;
    }

    public E findByCategory(String v) throws TopiaException {
        E result = findByProperty(Product.PROPERTY_CATEGORY, v);
        return result;
    }

    public List<E> findAllByCategory(String v) throws TopiaException {
        List<E> result = findAllByProperty(Product.PROPERTY_CATEGORY, v);
        return result;
    }

    public E findByLatinName(String v) throws TopiaException {
        E result = findByProperty(Product.PROPERTY_LATIN_NAME, v);
        return result;
    }

    public List<E> findAllByLatinName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Product.PROPERTY_LATIN_NAME, v);
        return result;
    }

    public E findByFamily(String v) throws TopiaException {
        E result = findByProperty(Product.PROPERTY_FAMILY, v);
        return result;
    }

    public List<E> findAllByFamily(String v) throws TopiaException {
        List<E> result = findAllByProperty(Product.PROPERTY_FAMILY, v);
        return result;
    }

    public E findByBotanicControl(boolean v) throws TopiaException {
        E result = findByProperty(Product.PROPERTY_BOTANIC_CONTROL, v);
        return result;
    }

    public List<E> findAllByBotanicControl(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Product.PROPERTY_BOTANIC_CONTROL, v);
        return result;
    }

    public E findByIdentificationControl(boolean v) throws TopiaException {
        E result = findByProperty(Product.PROPERTY_IDENTIFICATION_CONTROL, v);
        return result;
    }

    public List<E> findAllByIdentificationControl(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Product.PROPERTY_IDENTIFICATION_CONTROL, v);
        return result;
    }

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(Product.PROPERTY_COMMENT, v);
        return result;
    }

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Product.PROPERTY_COMMENT, v);
        return result;
    }

    public E findContainsProductStatus(ProductStatus v) throws TopiaException {
        E result = findContains(Product.PROPERTY_PRODUCT_STATUS, v);
        return result;
    }

    public List<E> findAllContainsProductStatus(ProductStatus v) throws TopiaException {
        List<E> result = findAllContains(Product.PROPERTY_PRODUCT_STATUS, v);
        return result;
    }

    public E findContainsAnalyzeType(AnalyzeType v) throws TopiaException {
        E result = findContains(Product.PROPERTY_ANALYZE_TYPE, v);
        return result;
    }

    public List<E> findAllContainsAnalyzeType(AnalyzeType v) throws TopiaException {
        List<E> result = findAllContains(Product.PROPERTY_ANALYZE_TYPE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Batch.class) {
            BatchDAO dao = (BatchDAO)
                getContext().getDAO(Batch.class);
            tmp = dao.findAllByProduct(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Batch.class, entity);
        if (!list.isEmpty()) {
            result.put(Batch.class, list);
        }

        return result;
    }

} //ProductDAOAbstract<E extends Product>
