/*
 * #%L
 * SGQ :: Business
 * $Id: SgqService.java 48 2012-09-11 12:46:57Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-business/src/main/java/com/herbocailleau/sgq/business/SgqService.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business;

/**
 * Common interface for all sgq application services.
 * 
 * The struts UI use {@link #setServiceDAOHelper(ServiceDAOHelper)} method to inject
 * request scope transaction
 * 
 * @author echatellier
 */
public abstract class SgqService {

    protected SgqBusinessConfig config;

    protected ServiceDAOHelper daoHelper;

    public void setConfig(SgqBusinessConfig config) {
        this.config = config;
    }

    /**
     * Inject dao helper containing transaction to use.
     * 
     * @param daoHelper dao helper
     */
    public void setServiceDAOHelper(ServiceDAOHelper daoHelper) {
        this.daoHelper = daoHelper;
    }
}
