/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSSupportsConditionMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSupportsConditionNested
implements ICSSSupportsConditionMember,
ICSSSourceLocationAware {
    private final ICommonsList<ICSSSupportsConditionMember> m_aMembers = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasMembers() {
        return this.m_aMembers.isNotEmpty();
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    @Nonnull
    public CSSSupportsConditionNested addMember(@Nonnull ICSSSupportsConditionMember iCSSSupportsConditionMember) {
        ValueEnforcer.notNull((Object)iCSSSupportsConditionMember, (String)"SupportsConditionMember");
        this.m_aMembers.add((Object)iCSSSupportsConditionMember);
        return this;
    }

    @Nonnull
    public CSSSupportsConditionNested addMember(@Nonnegative int n, @Nonnull ICSSSupportsConditionMember iCSSSupportsConditionMember) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)iCSSSupportsConditionMember, (String)"SupportsConditionMember");
        if (n >= this.getMemberCount()) {
            this.m_aMembers.add((Object)iCSSSupportsConditionMember);
        } else {
            this.m_aMembers.add(n, (Object)iCSSSupportsConditionMember);
        }
        return this;
    }

    @Nonnull
    public EChange removeMember(@Nonnull ICSSSupportsConditionMember iCSSSupportsConditionMember) {
        return this.m_aMembers.removeObject((Object)iCSSSupportsConditionMember);
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int n) {
        return this.m_aMembers.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeAllMembers() {
        return this.m_aMembers.removeAll();
    }

    @Nullable
    public ICSSSupportsConditionMember getMemberAtIndex(@Nonnegative int n) {
        return (ICSSSupportsConditionMember)this.m_aMembers.getAtIndex(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ICSSSupportsConditionMember> getAllMembers() {
        return (ICommonsList)this.m_aMembers.getClone();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        StringBuilder stringBuilder = new StringBuilder("(");
        boolean bl = true;
        for (ICSSSupportsConditionMember iCSSSupportsConditionMember : this.m_aMembers) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(' ');
            }
            stringBuilder.append(iCSSSupportsConditionMember.getAsCSSString(iCSSWriterSettings, n));
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSupportsConditionNested cSSSupportsConditionNested = (CSSSupportsConditionNested)object;
        return this.m_aMembers.equals(cSSSupportsConditionNested.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("members", this.m_aMembers).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

