/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.resource.inmemory;

import com.helger.annotation.WillNotClose;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.io.resource.inmemory.AbstractMemoryReadableResource;
import java.io.InputStream;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ReadableResourceInputStream
extends AbstractMemoryReadableResource {
    private final InputStream m_aIS;

    public ReadableResourceInputStream(@Nullable String string, @WillNotClose @NonNull InputStream inputStream) {
        super(StringHelper.isNotEmpty((String)string) ? string : "input-stream");
        this.m_aIS = (InputStream)ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
    }

    public final @NonNull InputStream getInputStream() {
        return this.m_aIS;
    }

    public final boolean isReadMultiple() {
        return false;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("InputStream", (Object)this.m_aIS).getToString();
    }
}

