/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.string.util;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import java.util.Locale;
import org.jspecify.annotations.NonNull;

@Immutable
public final class RomanNumeral {
    public static final int MIN_VAL = 1;
    public static final int MAX_VAL = 3999;
    private static final int[] NUMBERS = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    private static final String[] ROMAN_LETTERS = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    private final int m_nValue;

    private RomanNumeral(@Nonnegative int n) {
        ValueEnforcer.isBetweenInclusive((int)n, (String)"Value", (int)1, (int)3999);
        this.m_nValue = n;
    }

    private RomanNumeral(@NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Roman");
        String string2 = string.toUpperCase(Locale.ROOT);
        int n = 0;
        int n2 = 0;
        while (n < string2.length()) {
            char c = string2.charAt(n);
            int n3 = RomanNumeral._letterToNumber(c);
            if (++n == string2.length()) {
                n2 += n3;
                continue;
            }
            int n4 = RomanNumeral._letterToNumber(string2.charAt(n));
            if (n4 > n3) {
                n2 += n4 - n3;
                ++n;
                continue;
            }
            n2 += n3;
        }
        if (n2 > 3999) {
            throw new IllegalArgumentException("Roman numeral must have value 3999 or less.");
        }
        this.m_nValue = n2;
    }

    @Nonnegative
    private static int _letterToNumber(char c) {
        switch (c) {
            case 'I': {
                return 1;
            }
            case 'V': {
                return 5;
            }
            case 'X': {
                return 10;
            }
            case 'L': {
                return 50;
            }
            case 'C': {
                return 100;
            }
            case 'D': {
                return 500;
            }
            case 'M': {
                return 1000;
            }
        }
        throw new IllegalArgumentException("Unknown roman numeral char: " + c);
    }

    private static @NonNull String _getAsRomanString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = n;
        for (int i = 0; i < NUMBERS.length; ++i) {
            while (n2 >= NUMBERS[i]) {
                stringBuilder.append(ROMAN_LETTERS[i]);
                n2 -= NUMBERS[i];
            }
        }
        return stringBuilder.toString();
    }

    private @NonNull String _asRomanString() {
        return RomanNumeral._getAsRomanString(this.m_nValue);
    }

    private int _asInt() {
        return this.m_nValue;
    }

    @Nonnegative
    public static int romanStringToInt(String string) {
        return new RomanNumeral(string)._asInt();
    }

    public static @NonNull String intToRomanString(int n) {
        return new RomanNumeral(n)._asRomanString();
    }
}

