/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.map;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.UseDirectEqualsAndHashCode;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsLinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.NonNull;

@UseDirectEqualsAndHashCode
@NotThreadSafe
public class LRUMap<KEYTYPE, VALUETYPE>
extends CommonsLinkedHashMap<KEYTYPE, VALUETYPE> {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final int m_nMaxSize;

    public LRUMap(@Nonnegative int n) {
        super(n, 0.75f, true);
        this.m_nMaxSize = n;
    }

    public LRUMap(@NonNull LRUMap<KEYTYPE, VALUETYPE> lRUMap) {
        this(lRUMap.m_nMaxSize);
        this.putAll(lRUMap);
    }

    @Override
    public @NonNull LRUMap<KEYTYPE, VALUETYPE> getClone() {
        return new LRUMap<KEYTYPE, VALUETYPE>(this);
    }

    @Nonnegative
    public final int getMaxSize() {
        return this.m_nMaxSize;
    }

    @OverrideOnDemand
    protected void onRemoveEldestEntry(@Nonnegative int n,  @NonNull Map.Entry<KEYTYPE, VALUETYPE> entry) {
    }

    @Override
    protected final boolean removeEldestEntry( @NonNull Map.Entry<KEYTYPE, VALUETYPE> entry) {
        int n = this.size();
        if (n <= this.m_nMaxSize) {
            return false;
        }
        this.onRemoveEldestEntry(n, entry);
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        LRUMap lRUMap = (LRUMap)object;
        return EqualsHelper.equals((int)this.m_nMaxSize, (int)lRUMap.m_nMaxSize) && this.entrySet().equals(lRUMap.entrySet());
    }

    @Override
    public int hashCode() {
        HashCodeGenerator hashCodeGenerator = new HashCodeGenerator((Object)this).append(this.m_nMaxSize);
        for (Map.Entry entry : this.entrySet()) {
            hashCodeGenerator.append(entry.getKey()).append(entry.getValue());
        }
        return hashCodeGenerator.getHashCode();
    }

    @Override
    public String toString() {
        return new ToStringGenerator((Object)this).append("MaxSize", this.m_nMaxSize).append("Map", (Object)super.toString()).getToString();
    }
}

