/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.model;

import com.google.maps.internal.StringJoin;

public enum TravelMode implements StringJoin.UrlValue
{
    DRIVING("driving"),
    WALKING("walking"),
    BICYCLING("bicycling"),
    TRANSIT("transit");

    private final String mode;

    private TravelMode(String mode) {
        this.mode = mode;
    }

    public String toString() {
        return this.mode;
    }

    public static TravelMode lookup(String travelMode) {
        if (travelMode.equalsIgnoreCase(DRIVING.toString())) {
            return DRIVING;
        }
        if (travelMode.equalsIgnoreCase(WALKING.toString())) {
            return WALKING;
        }
        if (travelMode.equalsIgnoreCase(BICYCLING.toString())) {
            return BICYCLING;
        }
        if (travelMode.equalsIgnoreCase(TRANSIT.toString())) {
            return TRANSIT;
        }
        String string = String.valueOf(String.valueOf(travelMode));
        throw new RuntimeException(new StringBuilder(22 + string.length()).append("Unknown Travel Mode '").append(string).append("'").toString());
    }
}

