/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.newtypes.Declaration;
import com.google.javascript.jscomp.newtypes.DeclaredTypeRegistry;
import com.google.javascript.jscomp.newtypes.EnumType;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.NamespaceLit;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.PersistentMap;
import com.google.javascript.jscomp.newtypes.Property;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.Typedef;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class Namespace {
    protected Map<String, NominalType.RawNominalType> nominals = ImmutableMap.of();
    protected Map<String, EnumType> enums = ImmutableMap.of();
    protected Map<String, NamespaceLit> namespaces = ImmutableMap.of();
    protected Map<String, Typedef> typedefs = ImmutableMap.of();
    protected Map<String, DeclaredTypeRegistry> scopes = ImmutableMap.of();
    protected PersistentMap<String, Property> otherProps = PersistentMap.create();

    private boolean isDefined(String name) {
        return this.nominals.containsKey(name) || this.enums.containsKey(name) || this.namespaces.containsKey(name) || this.typedefs.containsKey(name) || this.scopes.containsKey(name) || this.otherProps.containsKey(name);
    }

    public boolean isDefined(QualifiedName qname) {
        Namespace ns;
        String name;
        if (qname.isIdentifier()) {
            name = qname.getLeftmostName();
            ns = this;
        } else {
            name = qname.getRightmostName();
            ns = this.getSubnamespace(qname.getAllButRightmost());
            if (ns == null) {
                return false;
            }
        }
        return ns.isDefined(name);
    }

    public void addSubnamespace(QualifiedName qname) {
        Preconditions.checkState((!this.isDefined(qname) ? 1 : 0) != 0);
        Namespace ns = this.getReceiverNamespace(qname);
        if (ns.namespaces.isEmpty()) {
            ns.namespaces = new LinkedHashMap<String, NamespaceLit>();
        }
        String name = qname.getRightmostName();
        ns.namespaces.put(name, new NamespaceLit());
    }

    public void addScope(QualifiedName qname, DeclaredTypeRegistry scope) {
        Namespace ns = this.getReceiverNamespace(qname);
        if (ns.scopes.isEmpty()) {
            ns.scopes = new LinkedHashMap<String, DeclaredTypeRegistry>();
        }
        String name = qname.getRightmostName();
        ns.scopes.put(name, scope);
    }

    public Declaration getDeclaration(QualifiedName qname) {
        Namespace recv = this.getReceiverNamespace(qname);
        if (recv == null) {
            return null;
        }
        String name = qname.getRightmostName();
        if (!recv.isDefined(name)) {
            return null;
        }
        Typedef typedef = recv.typedefs.get(name);
        EnumType enumType = recv.enums.get(name);
        NominalType.RawNominalType rawType = recv.nominals.get(name);
        DeclaredTypeRegistry scope = recv.scopes.get(name);
        NamespaceLit ns = recv.namespaces.get(name);
        return new Declaration(null, typedef, ns, enumType, scope, rawType, false, false, false, false, false);
    }

    public void addNominalType(QualifiedName qname, NominalType.RawNominalType rawNominalType) {
        Preconditions.checkState((!this.isDefined(qname) ? 1 : 0) != 0);
        Namespace ns = this.getReceiverNamespace(qname);
        if (ns.nominals.isEmpty()) {
            ns.nominals = new LinkedHashMap<String, NominalType.RawNominalType>();
        }
        String name = qname.getRightmostName();
        ns.nominals.put(name, rawNominalType);
    }

    public void addTypedef(QualifiedName qname, Typedef td) {
        Preconditions.checkState((!this.isDefined(qname) ? 1 : 0) != 0);
        Namespace ns = this.getReceiverNamespace(qname);
        if (ns.typedefs.isEmpty()) {
            ns.typedefs = new LinkedHashMap<String, Typedef>();
        }
        String name = qname.getRightmostName();
        ns.typedefs.put(name, td);
    }

    public void addEnum(QualifiedName qname, EnumType e) {
        Preconditions.checkState((!this.isDefined(qname) ? 1 : 0) != 0);
        Namespace ns = this.getReceiverNamespace(qname);
        if (ns.enums.isEmpty()) {
            ns.enums = new LinkedHashMap<String, EnumType>();
        }
        String name = qname.getRightmostName();
        ns.enums.put(name, e);
    }

    private Namespace getLocalSubnamespace(String name) {
        if (this.nominals != null && this.nominals.containsKey(name)) {
            return this.nominals.get(name);
        }
        if (this.namespaces != null && this.namespaces.containsKey(name)) {
            return this.namespaces.get(name);
        }
        if (this.enums != null && this.enums.containsKey(name)) {
            return this.enums.get(name);
        }
        return null;
    }

    private Namespace getReceiverNamespace(QualifiedName qname) {
        if (qname.isIdentifier()) {
            return this;
        }
        return this.getSubnamespace(qname.getAllButRightmost());
    }

    public Namespace getSubnamespace(QualifiedName qname) {
        String leftmost = qname.getLeftmostName();
        Namespace firstNamespace = this.getLocalSubnamespace(leftmost);
        if (firstNamespace == null || qname.isIdentifier()) {
            return firstNamespace;
        }
        return firstNamespace.getSubnamespace(qname.getAllButLeftmost());
    }

    public boolean hasSubnamespace(QualifiedName qname) {
        return this.getSubnamespace(qname) != null;
    }

    public boolean hasProp(String pname) {
        Property prop = (Property)this.otherProps.get(pname);
        if (prop == null) {
            return false;
        }
        Preconditions.checkState((!prop.isOptional() ? 1 : 0) != 0);
        return true;
    }

    public void addProperty(String pname, Node defSite, JSType type, boolean isConstant) {
        if (type == null && isConstant) {
            type = JSType.UNKNOWN;
        }
        this.otherProps = this.otherProps.with(pname, isConstant ? Property.makeConstant(defSite, type, type) : Property.makeWithDefsite(defSite, type, type));
    }

    public void addUndeclaredProperty(String pname, Node defSite, JSType t, boolean isConstant) {
        if (this.otherProps.containsKey(pname) && !((Property)this.otherProps.get(pname)).getType().isUnknown()) {
            return;
        }
        this.otherProps = this.otherProps.with(pname, isConstant ? Property.makeConstant(defSite, t, null) : Property.makeWithDefsite(defSite, t, null));
    }

    public JSType getPropDeclaredType(String pname) {
        Property p = (Property)this.otherProps.get(pname);
        return p == null ? null : p.getDeclaredType();
    }

    public abstract JSType toJSType();

    protected JSType withNamedTypes(ObjectType obj) {
        if (this.nominals != null) {
            for (Map.Entry<String, Namespace> entry : this.nominals.entrySet()) {
                obj = obj.withProperty(new QualifiedName(entry.getKey()), ((NominalType.RawNominalType)entry.getValue()).toJSType());
            }
        }
        if (this.enums != null) {
            for (Map.Entry<String, Namespace> entry : this.enums.entrySet()) {
                obj = obj.withProperty(new QualifiedName(entry.getKey()), ((EnumType)entry.getValue()).toJSType());
            }
        }
        if (this.namespaces != null) {
            for (Map.Entry<String, Namespace> entry : this.namespaces.entrySet()) {
                obj = obj.withProperty(new QualifiedName(entry.getKey()), ((NamespaceLit)entry.getValue()).toJSType());
            }
        }
        return JSType.fromObjectType(obj);
    }
}

