/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.graph.AdjacencyGraph;
import com.google.javascript.jscomp.graph.Annotation;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.SubGraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public abstract class GraphColoring<N, E> {
    protected N[] colorToNodeMap;
    protected final AdjacencyGraph<N, E> graph;

    public GraphColoring(AdjacencyGraph<N, E> adjacencyGraph) {
        this.graph = adjacencyGraph;
    }

    public abstract int color();

    public N getPartitionSuperNode(N n) {
        Preconditions.checkNotNull(this.colorToNodeMap, (Object)"No coloring founded. color() should be called first.");
        Color color = (Color)this.graph.getNode(n).getAnnotation();
        N n2 = this.colorToNodeMap[color.value];
        if (n2 == null) {
            this.colorToNodeMap[color.value] = n;
            return n;
        }
        return n2;
    }

    public AdjacencyGraph<N, E> getGraph() {
        return this.graph;
    }

    public static class GreedyGraphColoring<N, E>
    extends GraphColoring<N, E> {
        private final Comparator<N> tieBreaker;

        public GreedyGraphColoring(AdjacencyGraph<N, E> adjacencyGraph) {
            this(adjacencyGraph, null);
        }

        public GreedyGraphColoring(AdjacencyGraph<N, E> adjacencyGraph, Comparator<N> comparator) {
            super(adjacencyGraph);
            this.tieBreaker = comparator;
        }

        @Override
        public int color() {
            Object[] objectArray;
            this.graph.clearNodeAnnotations();
            ArrayList arrayList = Lists.newArrayList(this.graph.getNodes());
            Collections.sort(arrayList, new Comparator<GraphNode<N, E>>(){

                @Override
                public int compare(GraphNode<N, E> graphNode, GraphNode<N, E> graphNode2) {
                    int n = GreedyGraphColoring.this.graph.getWeight(graphNode2.getValue()) - GreedyGraphColoring.this.graph.getWeight(graphNode.getValue());
                    return n == 0 && GreedyGraphColoring.this.tieBreaker != null ? GreedyGraphColoring.this.tieBreaker.compare(graphNode.getValue(), graphNode2.getValue()) : n;
                }
            });
            int n = 0;
            do {
                objectArray = new Color(n);
                SubGraph subGraph = this.graph.newSubGraph();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    GraphNode graphNode = (GraphNode)iterator.next();
                    if (!subGraph.isIndependentOf(graphNode.getValue())) continue;
                    subGraph.addNode(graphNode.getValue());
                    graphNode.setAnnotation((Annotation)objectArray);
                    iterator.remove();
                }
                ++n;
            } while (!arrayList.isEmpty());
            objectArray = new Object[n];
            this.colorToNodeMap = objectArray;
            return n;
        }
    }

    public static class Color
    implements Annotation {
        int value = 0;

        Color(int n) {
            this.value = n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Color)) {
                return false;
            }
            return this.value == ((Color)object).value;
        }

        public int hashCode() {
            return this.value;
        }
    }
}

