/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.FlowScope;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.LinkedFlowScope;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ReverseAbstractInterpreter;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticSlot;
import com.google.javascript.rhino.jstype.UnionType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class TypeInference
extends DataFlowAnalysis.BranchedForwardDataFlowAnalysis<Node, FlowScope> {
    static final DiagnosticType TEMPLATE_TYPE_NOT_OBJECT_TYPE = DiagnosticType.error("JSC_TEMPLATE_TYPE_NOT_OBJECT_TYPE", "The template type must be an object type");
    static final DiagnosticType TEMPLATE_TYPE_OF_THIS_EXPECTED = DiagnosticType.error("JSC_TEMPLATE_TYPE_OF_THIS_EXPECTED", "A function type with the template type as the type of this must be a parameter type");
    static final DiagnosticType FUNCTION_LITERAL_UNDEFINED_THIS = DiagnosticType.warning("JSC_FUNCTION_LITERAL_UNDEFINED_THIS", "Function literal argument refers to undefined this argument");
    static final DiagnosticType FUNCTION_LITERAL_UNREAD_THIS = DiagnosticType.warning("JSC_FUNCTION_LITERAL_UNREAD_THIS", "Function literal argument does not refer to bound this argument");
    private final AbstractCompiler compiler;
    private final JSTypeRegistry registry;
    private final ReverseAbstractInterpreter reverseInterpreter;
    private final Scope syntacticScope;
    private final FlowScope functionScope;
    private final FlowScope bottomScope;
    private final Map<String, CodingConvention.AssertionFunctionSpec> assertionFunctionsMap;
    private final Multimap<Scope, Scope.Var> assignedOuterLocalVars = HashMultimap.create();
    private final Set<String> unflowableVarNames = Sets.newHashSet();

    TypeInference(AbstractCompiler abstractCompiler, ControlFlowGraph<Node> controlFlowGraph, ReverseAbstractInterpreter reverseAbstractInterpreter, Scope scope, Map<String, CodingConvention.AssertionFunctionSpec> map) {
        this(abstractCompiler, controlFlowGraph, reverseAbstractInterpreter, scope, map, (Collection<Scope.Var>)ImmutableSet.of());
    }

    TypeInference(AbstractCompiler abstractCompiler, ControlFlowGraph<Node> controlFlowGraph, ReverseAbstractInterpreter reverseAbstractInterpreter, Scope scope, Map<String, CodingConvention.AssertionFunctionSpec> map, Collection<Scope.Var> collection) {
        super(controlFlowGraph, new LinkedFlowScope.FlowScopeJoinOp());
        this.compiler = abstractCompiler;
        this.registry = abstractCompiler.getTypeRegistry();
        this.reverseInterpreter = reverseAbstractInterpreter;
        this.syntacticScope = scope;
        this.functionScope = LinkedFlowScope.createEntryLattice(scope);
        this.assertionFunctionsMap = map;
        for (Scope.Var var : collection) {
            String string = var.getName();
            if (scope.getVar(string) != var) continue;
            this.unflowableVarNames.add(string);
        }
        Iterator<Scope.Var> iterator = scope.getVars();
        while (iterator.hasNext()) {
            Scope.Var var;
            var = iterator.next();
            if (this.unflowableVarNames.contains(var.getName()) || var.getParentNode() == null || var.getType() != null || var.getParentNode().getType() != 118 || var.isExtern()) continue;
            this.functionScope.inferSlotType(var.getName(), this.getNativeType(JSTypeNative.VOID_TYPE));
        }
        this.bottomScope = LinkedFlowScope.createEntryLattice(new Scope(scope.getRootNode(), scope.getTypeOfThis()));
    }

    @Override
    FlowScope createInitialEstimateLattice() {
        return this.bottomScope;
    }

    @Override
    FlowScope createEntryLattice() {
        return this.functionScope;
    }

    Multimap<Scope, Scope.Var> getAssignedOuterLocalVars() {
        return this.assignedOuterLocalVars;
    }

    @Override
    FlowScope flowThrough(Node node, FlowScope flowScope) {
        if (flowScope == this.bottomScope) {
            return flowScope;
        }
        FlowScope flowScope2 = flowScope.createChildFlowScope();
        flowScope2 = this.traverse(node, flowScope2);
        return flowScope2;
    }

    @Override
    List<FlowScope> branchedFlowThrough(Node node, FlowScope flowScope) {
        FlowScope flowScope2 = this.flowThrough(node, flowScope);
        Node node2 = null;
        FlowScope flowScope3 = null;
        BooleanOutcomePair booleanOutcomePair = null;
        List list = this.getCfg().getOutEdges(node);
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
        for (DiGraph.DiGraphEdge diGraphEdge : list) {
            ControlFlowGraph.Branch branch = (ControlFlowGraph.Branch)((Object)diGraphEdge.getValue());
            FlowScope flowScope4 = flowScope2;
            switch (branch) {
                case ON_TRUE: {
                    if (NodeUtil.isForIn(node)) {
                        Node node3 = node.getFirstChild();
                        Node node4 = node3.getNext();
                        FlowScope flowScope5 = this.traverse(node4, flowScope2.createChildFlowScope());
                        if (node3.getType() == 118) {
                            node3 = node3.getFirstChild();
                        }
                        if (node3.getType() == 38) {
                            JSType jSType;
                            JSType jSType2;
                            JSType jSType3 = this.getNativeType(JSTypeNative.STRING_TYPE);
                            ObjectType objectType = this.getJSType(node4).dereference();
                            JSType jSType4 = jSType2 = objectType == null ? null : objectType.getIndexType();
                            if (jSType2 != null && !jSType2.isUnknownType() && !(jSType = jSType3.getGreatestSubtype(jSType2)).isEmptyType()) {
                                jSType3 = jSType;
                            }
                            this.redeclare(flowScope5, node3.getString(), jSType3);
                        }
                        flowScope4 = flowScope5;
                        break;
                    }
                }
                case ON_FALSE: {
                    if (node2 == null && (node2 = NodeUtil.getConditionExpression(node)) == null && node.getType() == 111) {
                        node2 = node;
                        if (flowScope3 == null) {
                            flowScope3 = this.traverse(node2.getFirstChild(), flowScope2.createChildFlowScope());
                        }
                    }
                    if (node2 == null) break;
                    if (node2.getType() == 101 || node2.getType() == 100) {
                        if (booleanOutcomePair == null) {
                            booleanOutcomePair = node2.getType() == 101 ? this.traverseAnd(node2, flowScope2.createChildFlowScope()) : this.traverseOr(node2, flowScope2.createChildFlowScope());
                        }
                        flowScope4 = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(node2, booleanOutcomePair.getOutcomeFlowScope(node2.getType(), branch == ControlFlowGraph.Branch.ON_TRUE), branch == ControlFlowGraph.Branch.ON_TRUE);
                        break;
                    }
                    if (flowScope3 == null) {
                        flowScope3 = this.traverse(node2, flowScope2.createChildFlowScope());
                    }
                    flowScope4 = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(node2, flowScope3, branch == ControlFlowGraph.Branch.ON_TRUE);
                }
            }
            arrayList.add(flowScope4.optimize());
        }
        return arrayList;
    }

    private FlowScope traverse(Node node, FlowScope flowScope) {
        JSDocInfo jSDocInfo;
        switch (node.getType()) {
            case 86: {
                flowScope = this.traverseAssign(node, flowScope);
                break;
            }
            case 38: {
                flowScope = this.traverseName(node, flowScope);
                break;
            }
            case 33: {
                flowScope = this.traverseGetProp(node, flowScope);
                break;
            }
            case 101: {
                flowScope = this.traverseAnd(node, flowScope).getJoinedFlowScope().createChildFlowScope();
                break;
            }
            case 100: {
                flowScope = this.traverseOr(node, flowScope).getJoinedFlowScope().createChildFlowScope();
                break;
            }
            case 98: {
                flowScope = this.traverseHook(node, flowScope);
                break;
            }
            case 64: {
                flowScope = this.traverseObjectLiteral(node, flowScope);
                break;
            }
            case 37: {
                flowScope = this.traverseCall(node, flowScope);
                break;
            }
            case 30: {
                flowScope = this.traverseNew(node, flowScope);
                break;
            }
            case 21: 
            case 93: {
                flowScope = this.traverseAdd(node, flowScope);
                break;
            }
            case 28: 
            case 29: {
                flowScope = this.traverse(node.getFirstChild(), flowScope);
                node.setJSType(this.getNativeType(JSTypeNative.NUMBER_TYPE));
                break;
            }
            case 63: {
                flowScope = this.traverseArrayLiteral(node, flowScope);
                break;
            }
            case 42: {
                node.setJSType((JSType)flowScope.getTypeOfThis());
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 102: 
            case 103: {
                flowScope = this.traverseChildren(node, flowScope);
                node.setJSType(this.getNativeType(JSTypeNative.NUMBER_TYPE));
                break;
            }
            case 65: 
            case 83: {
                flowScope = this.traverse(node.getFirstChild(), flowScope);
                node.setJSType(this.getJSType(node.getFirstChild()));
                break;
            }
            case 85: {
                flowScope = this.traverseChildren(node, flowScope);
                node.setJSType(this.getJSType(node.getLastChild()));
                break;
            }
            case 32: {
                flowScope = this.traverseChildren(node, flowScope);
                node.setJSType(this.getNativeType(JSTypeNative.STRING_TYPE));
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 45: 
            case 46: 
            case 51: 
            case 52: {
                flowScope = this.traverseChildren(node, flowScope);
                node.setJSType(this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
                break;
            }
            case 35: {
                flowScope = this.traverseGetElem(node, flowScope);
                break;
            }
            case 130: {
                flowScope = this.traverseChildren(node, flowScope);
                if (node.getFirstChild().getType() != 33) break;
                this.ensurePropertyDeclared(node.getFirstChild());
                break;
            }
            case 110: {
                flowScope = this.traverse(node.getFirstChild(), flowScope);
                break;
            }
            case 4: 
            case 49: 
            case 118: {
                flowScope = this.traverseChildren(node, flowScope);
                break;
            }
            case 120: {
                flowScope = this.traverseCatch(node, flowScope);
            }
        }
        if (node.getType() != 105 && (jSDocInfo = node.getJSDocInfo()) != null && jSDocInfo.hasType()) {
            JSType jSType = jSDocInfo.getType().evaluate(this.syntacticScope, this.registry);
            if (node.isQualifiedName() && node.getParent().getType() == 130) {
                this.updateScopeForTypeChange(flowScope, node, node.getJSType(), jSType);
            }
            node.setJSType(jSType);
        }
        return flowScope;
    }

    private FlowScope traverseCatch(Node node, FlowScope flowScope) {
        Node node2 = node.getFirstChild();
        JSType jSType = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        node2.setJSType(jSType);
        this.redeclare(flowScope, node2.getString(), jSType);
        return flowScope;
    }

    private FlowScope traverseAssign(Node node, FlowScope flowScope) {
        Node node2 = node.getFirstChild();
        Node node3 = node.getLastChild();
        flowScope = this.traverseChildren(node, flowScope);
        JSType jSType = node2.getJSType();
        JSType jSType2 = this.getJSType(node3);
        node.setJSType(jSType2);
        this.updateScopeForTypeChange(flowScope, node2, jSType, jSType2);
        return flowScope;
    }

    private void updateScopeForTypeChange(FlowScope flowScope, Node node, JSType jSType, JSType jSType2) {
        Preconditions.checkNotNull((Object)jSType2);
        switch (node.getType()) {
            case 38: {
                boolean bl;
                String string = node.getString();
                Scope.Var var = this.syntacticScope.getVar(string);
                if (var != null && var.isLocal() && var.getScope() != this.syntacticScope) {
                    this.assignedOuterLocalVars.put((Object)var.getScope(), (Object)var);
                }
                if (!(bl = node.hasChildren()) || var == null || var.isTypeInferred()) {
                    this.redeclare(flowScope, string, jSType2);
                }
                node.setJSType(bl || jSType == null ? jSType2 : null);
                if (var == null || !var.isTypeInferred()) break;
                JSType jSType3 = var.getType();
                var.setType(jSType3 == null ? jSType2 : jSType3.getLeastSupertype(jSType2));
                break;
            }
            case 33: {
                String string = node.getQualifiedName();
                if (string != null) {
                    flowScope.inferQualifiedSlot(string, jSType == null ? this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : jSType, jSType2);
                }
                node.setJSType(jSType2);
                this.ensurePropertyDefined(node, jSType2);
            }
        }
    }

    private void ensurePropertyDefined(Node node, JSType jSType) {
        String string = node.getLastChild().getString();
        JSType jSType2 = this.getJSType(node.getFirstChild());
        ObjectType objectType = ObjectType.cast(jSType2.restrictByNotNullOrUndefined());
        if (objectType == null) {
            this.registry.registerPropertyOnType(string, jSType2);
        } else {
            if (this.ensurePropertyDeclaredHelper(node, objectType)) {
                return;
            }
            if (!objectType.isPropertyTypeDeclared(string)) {
                if (objectType.hasProperty(string) || !objectType.isInstanceType()) {
                    if ("prototype".equals(string)) {
                        objectType.defineDeclaredProperty(string, jSType, false, node);
                    } else {
                        objectType.defineInferredProperty(string, jSType, false, node);
                    }
                } else if (node.getFirstChild().getType() == 42 && this.getJSType(this.syntacticScope.getRootNode()).isConstructor()) {
                    objectType.defineInferredProperty(string, jSType, false, node);
                } else {
                    this.registry.registerPropertyOnType(string, objectType);
                }
            }
        }
    }

    private void ensurePropertyDeclared(Node node) {
        ObjectType objectType = ObjectType.cast(this.getJSType(node.getFirstChild()).restrictByNotNullOrUndefined());
        if (objectType != null) {
            this.ensurePropertyDeclaredHelper(node, objectType);
        }
    }

    private boolean ensurePropertyDeclaredHelper(Node node, ObjectType objectType) {
        Scope.Var var;
        String string = node.getLastChild().getString();
        String string2 = node.getQualifiedName();
        if (string2 != null && (var = this.syntacticScope.getVar(string2)) != null && !var.isTypeInferred() && (string.equals("prototype") || !objectType.hasOwnProperty(string) && (!objectType.isInstanceType() || var.isExtern() && !objectType.isNativeObjectType()))) {
            return objectType.defineDeclaredProperty(string, var.getType(), var.isExtern(), node);
        }
        return false;
    }

    private FlowScope traverseName(Node node, FlowScope flowScope) {
        String string = node.getString();
        Node node2 = node.getFirstChild();
        JSType jSType = node.getJSType();
        if (node2 != null) {
            flowScope = this.traverse(node2, flowScope);
            this.updateScopeForTypeChange(flowScope, node, node.getJSType(), this.getJSType(node2));
            return flowScope;
        }
        StaticSlot staticSlot = flowScope.getSlot(string);
        if (staticSlot != null) {
            boolean bl;
            boolean bl2 = staticSlot.isTypeInferred();
            boolean bl3 = bl2 && this.unflowableVarNames.contains(string);
            boolean bl4 = bl = bl2 && this.syntacticScope.getParent() != null && staticSlot == this.syntacticScope.getParent().getSlot(string);
            if (!bl3 && !bl && (jSType = (JSType)staticSlot.getType()) == null) {
                jSType = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
        }
        node.setJSType(jSType);
        return flowScope;
    }

    private FlowScope traverseArrayLiteral(Node node, FlowScope flowScope) {
        flowScope = this.traverseChildren(node, flowScope);
        node.setJSType(this.getNativeType(JSTypeNative.ARRAY_TYPE));
        return flowScope;
    }

    private FlowScope traverseObjectLiteral(Node node, FlowScope flowScope) {
        boolean bl;
        JSType jSType = node.getJSType();
        Preconditions.checkNotNull((Object)jSType);
        ObjectType objectType = ObjectType.cast(jSType);
        if (objectType == null) {
            return flowScope;
        }
        boolean bl2 = bl = node.getJSDocInfo() != null && node.getJSDocInfo().getLendsName() != null;
        if (objectType.hasReferenceName() && !bl) {
            return flowScope;
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            Node node3 = node2.getFirstChild();
            flowScope = this.traverse(node3, flowScope);
            String string = NodeUtil.getStringValue(node2);
            if (string == null) {
                node.setJSType(this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
                return flowScope;
            }
            objectType.defineInferredProperty(string, this.getJSType(node3), false, node2);
        }
        return flowScope;
    }

    private FlowScope traverseAdd(Node node, FlowScope flowScope) {
        Node node2 = node.getFirstChild();
        Node node3 = node2.getNext();
        flowScope = this.traverseChildren(node, flowScope);
        JSType jSType = node2.getJSType();
        JSType jSType2 = node3.getJSType();
        JSType jSType3 = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        if (jSType != null && jSType2 != null) {
            boolean bl = jSType.isUnknownType();
            boolean bl2 = jSType2.isUnknownType();
            jSType3 = bl && bl2 ? this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : (!bl && jSType.isString() || !bl2 && jSType2.isString() ? this.getNativeType(JSTypeNative.STRING_TYPE) : (bl || bl2 ? this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : (this.isAddedAsNumber(jSType) && this.isAddedAsNumber(jSType2) ? this.getNativeType(JSTypeNative.NUMBER_TYPE) : this.registry.createUnionType(JSTypeNative.STRING_TYPE, JSTypeNative.NUMBER_TYPE))));
        }
        node.setJSType(jSType3);
        if (node.getType() == 93) {
            this.updateScopeForTypeChange(flowScope, node2, jSType, jSType3);
        }
        return flowScope;
    }

    private boolean isAddedAsNumber(JSType jSType) {
        return jSType.isSubtype(this.registry.createUnionType(JSTypeNative.VOID_TYPE, JSTypeNative.NULL_TYPE, JSTypeNative.NUMBER_VALUE_OR_OBJECT_TYPE, JSTypeNative.BOOLEAN_TYPE, JSTypeNative.BOOLEAN_OBJECT_TYPE));
    }

    private FlowScope traverseHook(Node node, FlowScope flowScope) {
        Node node2 = node.getFirstChild();
        Node node3 = node2.getNext();
        Node node4 = node.getLastChild();
        flowScope = this.traverse(node2, flowScope);
        FlowScope flowScope2 = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(node2, flowScope, true);
        FlowScope flowScope3 = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(node2, flowScope, false);
        this.traverse(node3, flowScope2.createChildFlowScope());
        this.traverse(node4, flowScope3.createChildFlowScope());
        JSType jSType = node3.getJSType();
        JSType jSType2 = node4.getJSType();
        if (jSType != null && jSType2 != null) {
            node.setJSType(jSType.getLeastSupertype(jSType2));
        } else {
            node.setJSType(null);
        }
        return flowScope.createChildFlowScope();
    }

    private FlowScope traverseCall(Node node, FlowScope flowScope) {
        flowScope = this.traverseChildren(node, flowScope);
        Node node2 = node.getFirstChild();
        JSType jSType = this.getJSType(node2).restrictByNotNullOrUndefined();
        if (jSType != null) {
            if (jSType instanceof FunctionType) {
                FunctionType functionType = (FunctionType)jSType;
                node.setJSType(functionType.getReturnType());
                this.updateTypeOfParametersOnClosure(node, functionType);
                this.updateTypeOfThisOnClosure(node, functionType);
            } else if (jSType.equals(this.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE))) {
                node.setJSType(this.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE));
            }
        }
        flowScope = this.tightenTypesAfterAssertions(flowScope, node);
        return flowScope;
    }

    private FlowScope tightenTypesAfterAssertions(FlowScope flowScope, Node node) {
        JSType jSType;
        JSType jSType2;
        Node node2 = node.getFirstChild();
        Node node3 = node2.getNext();
        CodingConvention.AssertionFunctionSpec assertionFunctionSpec = this.assertionFunctionsMap.get(node2.getQualifiedName());
        if (assertionFunctionSpec == null || node3 == null) {
            return flowScope;
        }
        Node node4 = assertionFunctionSpec.getAssertedParam(node3);
        if (node4 == null) {
            return flowScope;
        }
        JSTypeNative jSTypeNative = assertionFunctionSpec.getAssertedType();
        String string = node4.getQualifiedName();
        if (jSTypeNative == null) {
            if (string != null) {
                JSType jSType3;
                JSType jSType4 = this.getJSType(node4);
                if (jSType4 != (jSType3 = jSType4.restrictByNotNullOrUndefined())) {
                    flowScope = flowScope.createChildFlowScope();
                    this.redeclare(flowScope, string, jSType3);
                    node.setJSType(jSType3);
                }
            } else if (node4.getType() == 101 || node4.getType() == 100) {
                BooleanOutcomePair booleanOutcomePair = this.traverseWithinShortCircuitingBinOp(node4, flowScope);
                flowScope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(node4, booleanOutcomePair.getOutcomeFlowScope(node4.getType(), true), true);
            }
        } else if (string != null && (jSType2 = this.getJSType(node4)) != (jSType = jSType2.getGreatestSubtype(this.getNativeType(jSTypeNative)))) {
            flowScope = flowScope.createChildFlowScope();
            this.redeclare(flowScope, string, jSType);
            node.setJSType(jSType);
        }
        return flowScope;
    }

    private void updateTypeOfParametersOnClosure(Node node, FunctionType functionType) {
        int n = 0;
        int n2 = node.getChildCount();
        for (Node node2 : functionType.getParameters()) {
            JSType jSType = node2.getJSType();
            if (jSType instanceof FunctionType) {
                FunctionType functionType2 = (FunctionType)jSType;
                if (n + 1 >= n2) {
                    return;
                }
                Node node3 = node.getChildAtIndex(n + 1);
                JSType jSType2 = this.getJSType(node3);
                if (node3.getType() == 105 && jSType2 instanceof FunctionType && node3.getJSDocInfo() == null) {
                    node3.setJSType(functionType2);
                }
            }
            ++n;
        }
    }

    private void updateTypeOfThisOnClosure(Node node, FunctionType functionType) {
        if (functionType.getTemplateTypeName() == null) {
            return;
        }
        int n = 0;
        int n2 = node.getChildCount();
        for (Node node2 : functionType.getParameters()) {
            JSType jSType = this.getJSType(node2).restrictByNotNullOrUndefined();
            if (jSType.isTemplateType()) {
                Node node3;
                JSType jSType2 = null;
                if (n + 1 < n2 && !((jSType2 = this.getJSType(node3 = node.getChildAtIndex(n + 1)).restrictByNotNullOrUndefined()) instanceof ObjectType)) {
                    this.compiler.report(JSError.make(NodeUtil.getSourceName(node3), node3, TEMPLATE_TYPE_NOT_OBJECT_TYPE, new String[0]));
                    return;
                }
                boolean bl = false;
                int n3 = 0;
                for (Node node4 : functionType.getParameters()) {
                    FunctionType functionType2;
                    JSType jSType3 = this.getJSType(node4).restrictByNotNullOrUndefined();
                    if (jSType3 instanceof FunctionType && (functionType2 = (FunctionType)jSType3).getTypeOfThis().equals(jSType)) {
                        bl = true;
                        if (n3 + 1 >= n2) {
                            return;
                        }
                        Node node5 = node.getChildAtIndex(n3 + 1);
                        JSType jSType4 = this.getJSType(node5);
                        if (node5.getType() == 105 && jSType4 instanceof FunctionType) {
                            if (jSType2 != null && !jSType2.isNoType()) {
                                FunctionType functionType3 = (FunctionType)jSType4;
                                if (functionType3.getTypeOfThis().isUnknownType()) {
                                    node5.setJSType(this.registry.createFunctionTypeWithNewThisType(functionType3, (ObjectType)jSType2));
                                }
                                if (!NodeUtil.referencesThis(NodeUtil.getFunctionBody(node5))) {
                                    this.compiler.report(JSError.make(NodeUtil.getSourceName(node), node, FUNCTION_LITERAL_UNREAD_THIS, new String[0]));
                                }
                            } else if (NodeUtil.referencesThis(NodeUtil.getFunctionBody(node5))) {
                                this.compiler.report(JSError.make(NodeUtil.getSourceName(node), node, FUNCTION_LITERAL_UNDEFINED_THIS, new String[0]));
                            }
                        }
                    }
                    ++n3;
                }
                if (!bl) {
                    this.compiler.report(JSError.make(NodeUtil.getSourceName(node), node, TEMPLATE_TYPE_OF_THIS_EXPECTED, new String[0]));
                    return;
                }
            }
            ++n;
        }
    }

    private FlowScope traverseNew(Node node, FlowScope flowScope) {
        Serializable serializable;
        Node node2 = node.getFirstChild();
        flowScope = this.traverse(node2, flowScope);
        JSType jSType = node2.getJSType();
        JSType jSType2 = null;
        if (jSType != null) {
            if ((jSType = jSType.restrictByNotNullOrUndefined()).isUnknownType()) {
                jSType2 = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            } else if (jSType instanceof FunctionType && ((FunctionType)(serializable = (FunctionType)jSType)).isConstructor()) {
                jSType2 = ((FunctionType)serializable).getInstanceType();
            }
        }
        node.setJSType(jSType2);
        for (serializable = node2.getNext(); serializable != null; serializable = ((Node)serializable).getNext()) {
            flowScope = this.traverse((Node)serializable, flowScope);
        }
        return flowScope;
    }

    private BooleanOutcomePair traverseAnd(Node node, FlowScope flowScope) {
        return this.traverseShortCircuitingBinOp(node, flowScope, true);
    }

    private FlowScope traverseChildren(Node node, FlowScope flowScope) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            flowScope = this.traverse(node2, flowScope);
        }
        return flowScope;
    }

    private FlowScope traverseGetElem(Node node, FlowScope flowScope) {
        JSType jSType;
        flowScope = this.traverseChildren(node, flowScope);
        ObjectType objectType = ObjectType.cast(this.getJSType(node.getFirstChild()).restrictByNotNullOrUndefined());
        if (objectType != null && (jSType = objectType.getParameterType()) != null) {
            node.setJSType(jSType);
        }
        return this.dereferencePointer(node.getFirstChild(), flowScope);
    }

    private FlowScope traverseGetProp(Node node, FlowScope flowScope) {
        Node node2 = node.getFirstChild();
        Node node3 = node.getLastChild();
        flowScope = this.traverseChildren(node, flowScope);
        node.setJSType(this.getPropertyType(node2.getJSType(), node3.getString(), node, flowScope));
        return this.dereferencePointer(node.getFirstChild(), flowScope);
    }

    private FlowScope dereferencePointer(Node node, FlowScope flowScope) {
        JSType jSType;
        JSType jSType2;
        if (node.getType() == 38 && (jSType2 = this.getJSType(node)) != (jSType = jSType2.restrictByNotNullOrUndefined())) {
            flowScope = flowScope.createChildFlowScope();
            this.redeclare(flowScope, node.getString(), jSType);
        }
        return flowScope;
    }

    private JSType getPropertyType(JSType jSType, String string, Node node, FlowScope flowScope) {
        ObjectType objectType;
        JSType jSType2;
        String string2 = node.getQualifiedName();
        StaticSlot staticSlot = flowScope.getSlot(string2);
        if (staticSlot != null && (jSType2 = (JSType)staticSlot.getType()) != null) {
            if (jSType2.equals(this.getNativeType(JSTypeNative.UNKNOWN_TYPE)) && staticSlot != this.syntacticScope.getSlot(string2)) {
                return this.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE);
            }
            return jSType2;
        }
        jSType2 = null;
        if (jSType != null) {
            jSType2 = jSType.findPropertyType(string);
        }
        if ((jSType2 == null || jSType2.isUnknownType()) && string2 != null && (objectType = ObjectType.cast(this.registry.getType(string2))) != null) {
            jSType2 = objectType.getConstructor();
        }
        return jSType2;
    }

    private BooleanOutcomePair traverseOr(Node node, FlowScope flowScope) {
        return this.traverseShortCircuitingBinOp(node, flowScope, false);
    }

    private BooleanOutcomePair traverseShortCircuitingBinOp(Node node, FlowScope flowScope, boolean bl) {
        BooleanOutcomePair booleanOutcomePair;
        JSType jSType;
        Node node2 = node.getFirstChild();
        Node node3 = node.getLastChild();
        BooleanOutcomePair booleanOutcomePair2 = this.traverseWithinShortCircuitingBinOp(node2, flowScope.createChildFlowScope());
        JSType jSType2 = node2.getJSType();
        FlowScope flowScope2 = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(node2, booleanOutcomePair2.getOutcomeFlowScope(node2.getType(), bl), bl);
        BooleanOutcomePair booleanOutcomePair3 = this.traverseWithinShortCircuitingBinOp(node3, flowScope2.createChildFlowScope());
        JSType jSType3 = node3.getJSType();
        if (jSType2 != null && jSType3 != null) {
            jSType2 = jSType2.getRestrictedTypeGivenToBooleanOutcome(!bl);
            if (booleanOutcomePair2.toBooleanOutcomes == BooleanLiteralSet.get(!bl)) {
                jSType = jSType2;
                booleanOutcomePair = booleanOutcomePair2;
            } else {
                jSType = jSType2.getLeastSupertype(jSType3);
                booleanOutcomePair = this.getBooleanOutcomePair(booleanOutcomePair2, booleanOutcomePair3, bl);
            }
            if (booleanOutcomePair.booleanValues == BooleanLiteralSet.EMPTY && this.getNativeType(JSTypeNative.BOOLEAN_TYPE).isSubtype(jSType) && jSType instanceof UnionType) {
                jSType = ((UnionType)jSType).getRestrictedUnion(this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
            }
        } else {
            jSType = null;
            booleanOutcomePair = new BooleanOutcomePair(BooleanLiteralSet.BOTH, BooleanLiteralSet.BOTH, booleanOutcomePair2.getJoinedFlowScope(), booleanOutcomePair3.getJoinedFlowScope());
        }
        node.setJSType(jSType);
        return booleanOutcomePair;
    }

    private BooleanOutcomePair traverseWithinShortCircuitingBinOp(Node node, FlowScope flowScope) {
        switch (node.getType()) {
            case 101: {
                return this.traverseAnd(node, flowScope);
            }
            case 100: {
                return this.traverseOr(node, flowScope);
            }
        }
        flowScope = this.traverse(node, flowScope);
        return this.newBooleanOutcomePair(node.getJSType(), flowScope);
    }

    BooleanOutcomePair getBooleanOutcomePair(BooleanOutcomePair booleanOutcomePair, BooleanOutcomePair booleanOutcomePair2, boolean bl) {
        return new BooleanOutcomePair(TypeInference.getBooleanOutcomes(booleanOutcomePair.toBooleanOutcomes, booleanOutcomePair2.toBooleanOutcomes, bl), TypeInference.getBooleanOutcomes(booleanOutcomePair.booleanValues, booleanOutcomePair2.booleanValues, bl), booleanOutcomePair.getJoinedFlowScope(), booleanOutcomePair2.getJoinedFlowScope());
    }

    static BooleanLiteralSet getBooleanOutcomes(BooleanLiteralSet booleanLiteralSet, BooleanLiteralSet booleanLiteralSet2, boolean bl) {
        return booleanLiteralSet2.union(booleanLiteralSet.intersection(BooleanLiteralSet.get(!bl)));
    }

    private BooleanOutcomePair newBooleanOutcomePair(JSType jSType, FlowScope flowScope) {
        if (jSType == null) {
            return new BooleanOutcomePair(BooleanLiteralSet.BOTH, BooleanLiteralSet.BOTH, flowScope, flowScope);
        }
        return new BooleanOutcomePair(jSType.getPossibleToBooleanOutcomes(), this.registry.getNativeType(JSTypeNative.BOOLEAN_TYPE).isSubtype(jSType) ? BooleanLiteralSet.BOTH : BooleanLiteralSet.EMPTY, flowScope, flowScope);
    }

    private void redeclare(FlowScope flowScope, String string, JSType jSType) {
        if (jSType == null) {
            jSType = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        if (this.unflowableVarNames.contains(string)) {
            return;
        }
        flowScope.inferSlotType(string, jSType);
    }

    private JSType getJSType(Node node) {
        JSType jSType = node.getJSType();
        if (jSType == null) {
            return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return jSType;
    }

    private JSType getNativeType(JSTypeNative jSTypeNative) {
        return this.registry.getNativeType(jSTypeNative);
    }

    private final class BooleanOutcomePair {
        final BooleanLiteralSet toBooleanOutcomes;
        final BooleanLiteralSet booleanValues;
        final FlowScope leftScope;
        final FlowScope rightScope;
        FlowScope joinedScope = null;

        BooleanOutcomePair(BooleanLiteralSet booleanLiteralSet, BooleanLiteralSet booleanLiteralSet2, FlowScope flowScope, FlowScope flowScope2) {
            this.toBooleanOutcomes = booleanLiteralSet;
            this.booleanValues = booleanLiteralSet2;
            this.leftScope = flowScope;
            this.rightScope = flowScope2;
        }

        FlowScope getJoinedFlowScope() {
            if (this.joinedScope == null) {
                this.joinedScope = this.leftScope == this.rightScope ? this.rightScope : TypeInference.this.join(this.leftScope, this.rightScope);
            }
            return this.joinedScope;
        }

        FlowScope getOutcomeFlowScope(int n, boolean bl) {
            if (n == 101 && bl || n == 100 && !bl) {
                return this.rightScope;
            }
            return this.getJoinedFlowScope();
        }
    }
}

