/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.safehtml.shared;

import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlHostedModeUtils;
import com.google.gwt.safehtml.shared.SafeHtmlString;

public final class SafeHtmlUtils {
    private static final String HTML_ENTITY_REGEX = "[a-z]+|#[0-9]+|#x[0-9a-fA-F]+";
    public static final SafeHtml EMPTY_SAFE_HTML = new SafeHtmlString("");
    private static final RegExp AMP_RE = RegExp.compile("&", "g");
    private static final RegExp GT_RE = RegExp.compile(">", "g");
    private static final RegExp LT_RE = RegExp.compile("<", "g");
    private static final RegExp SQUOT_RE = RegExp.compile("'", "g");
    private static final RegExp QUOT_RE = RegExp.compile("\"", "g");

    public static SafeHtml fromSafeConstant(String s) {
        SafeHtmlHostedModeUtils.maybeCheckCompleteHtml(s);
        return new SafeHtmlString(s);
    }

    public static SafeHtml fromString(String s) {
        return new SafeHtmlString(SafeHtmlUtils.htmlEscape(s));
    }

    public static SafeHtml fromTrustedString(String s) {
        return new SafeHtmlString(s);
    }

    public static String htmlEscape(char c) {
        switch (c) {
            case '&': {
                return "&amp;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&#39;";
            }
        }
        return "" + c;
    }

    public static String htmlEscape(String s) {
        if (s.indexOf("&") != -1) {
            s = AMP_RE.replace(s, "&amp;");
        }
        if (s.indexOf("<") != -1) {
            s = LT_RE.replace(s, "&lt;");
        }
        if (s.indexOf(">") != -1) {
            s = GT_RE.replace(s, "&gt;");
        }
        if (s.indexOf("\"") != -1) {
            s = QUOT_RE.replace(s, "&quot;");
        }
        if (s.indexOf("'") != -1) {
            s = SQUOT_RE.replace(s, "&#39;");
        }
        return s;
    }

    public static String htmlEscapeAllowEntities(String text) {
        StringBuilder escaped = new StringBuilder();
        boolean firstSegment = true;
        for (String segment : text.split("&", -1)) {
            if (firstSegment) {
                firstSegment = false;
                escaped.append(SafeHtmlUtils.htmlEscape(segment));
                continue;
            }
            int entityEnd = segment.indexOf(59);
            if (entityEnd > 0 && segment.substring(0, entityEnd).matches(HTML_ENTITY_REGEX)) {
                escaped.append("&").append(segment.substring(0, entityEnd + 1));
                escaped.append(SafeHtmlUtils.htmlEscape(segment.substring(entityEnd + 1)));
                continue;
            }
            escaped.append("&amp;").append(SafeHtmlUtils.htmlEscape(segment));
        }
        return escaped.toString();
    }

    private SafeHtmlUtils() {
    }
}

