/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 Google $
//  type=id
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $


/**
 * Localized names for the "id" locale.
 */
public class LocalizedNamesImpl_id extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "ID",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "ZA",
        "AL",
        "DZ",
        "US",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AN",
        "SA",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "NL",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BR",
        "GB",
        "BN",
        "BG",
        "BF",
        "BI",
        "EA",
        "TD",
        "CN",
        "CL",
        "CI",
        "CW",
        "DK",
        "DG",
        "DM",
        "EC",
        "SV",
        "ER",
        "EE",
        "ET",
        "FJ",
        "PH",
        "FI",
        "GA",
        "GM",
        "GE",
        "GH",
        "GI",
        "GD",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GQ",
        "GY",
        "GF",
        "HT",
        "HN",
        "HK",
        "HU",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IM",
        "IL",
        "IT",
        "JM",
        "JP",
        "DE",
        "JE",
        "DJ",
        "NC",
        "KH",
        "CM",
        "CA",
        "KZ",
        "KE",
        "AX",
        "IC",
        "CC",
        "CK",
        "FO",
        "KY",
        "UM",
        "FK",
        "MP",
        "MH",
        "NF",
        "PN",
        "SB",
        "GS",
        "SJ",
        "TC",
        "VI",
        "VG",
        "WF",
        "KG",
        "KI",
        "CO",
        "KM",
        "CD",
        "CG",
        "KR",
        "KP",
        "CR",
        "HR",
        "CU",
        "KW",
        "LA",
        "LV",
        "LB",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MG",
        "MO",
        "MK",
        "MV",
        "MW",
        "MY",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "EG",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "NO",
        "PG",
        "OM",
        "QO",
        "PS",
        "PK",
        "PW",
        "PA",
        "PY",
        "PE",
        "PL",
        "PF",
        "PT",
        "FR",
        "PR",
        "AC",
        "BV",
        "CX",
        "CP",
        "HM",
        "QA",
        "CF",
        "CZ",
        "DO",
        "RE",
        "RO",
        "RU",
        "RW",
        "EH",
        "BL",
        "SH",
        "KN",
        "LC",
        "MF",
        "PM",
        "VC",
        "WS",
        "AS",
        "SM",
        "ST",
        "NZ",
        "SN",
        "RS",
        "CS",
        "SC",
        "SL",
        "SG",
        "CY",
        "SK",
        "SI",
        "SO",
        "ES",
        "LK",
        "SS",
        "SD",
        "SR",
        "SZ",
        "SE",
        "CH",
        "SX",
        "SY",
        "TW",
        "TJ",
        "CV",
        "TZ",
        "TF",
        "TH",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TV",
        "UG",
        "UA",
        "AE",
        "EU",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "IO",
        "YE",
        "JO",
        "GR",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Dunia");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Amerika Utara");
    namesMap.put("005", "Amerika Selatan");
    namesMap.put("009", "Oseania");
    namesMap.put("011", "Afrika Barat");
    namesMap.put("013", "Amerika Tengah");
    namesMap.put("014", "Afrika Timur");
    namesMap.put("015", "Afrika Utara");
    namesMap.put("017", "Afrika Tengah");
    namesMap.put("018", "Afrika bagian selatan");
    namesMap.put("019", "Amerika");
    namesMap.put("021", "Amerika bagian utara");
    namesMap.put("029", "Kepulauan Karibia");
    namesMap.put("030", "Asia Timur");
    namesMap.put("034", "Asia Selatan");
    namesMap.put("035", "Asia Tenggara");
    namesMap.put("039", "Eropa Selatan");
    namesMap.put("053", "Australia dan Selandia Baru");
    namesMap.put("057", "Wilayah Mikronesia");
    namesMap.put("061", "Polinesia");
    namesMap.put("143", "Asia Tengah");
    namesMap.put("145", "Asia Barat");
    namesMap.put("150", "Eropa");
    namesMap.put("151", "Eropa Timur");
    namesMap.put("154", "Eropa Utara");
    namesMap.put("155", "Eropa Barat");
    namesMap.put("419", "Amerika Latin");
    namesMap.put("AC", "Pulau Ascension");
    namesMap.put("AD", "Andora");
    namesMap.put("AE", "Uni Emirat Arab");
    namesMap.put("AG", "Antigua dan Barbuda");
    namesMap.put("AN", "Antilla Belanda");
    namesMap.put("AQ", "Antarktika");
    namesMap.put("AS", "Samoa Amerika");
    namesMap.put("AX", "Kepulauan Aland");
    namesMap.put("BA", "Bosnia dan Herzegovina");
    namesMap.put("BE", "Belgia");
    namesMap.put("BL", "Saint Barthelemy");
    namesMap.put("BR", "Brasil");
    namesMap.put("BS", "Bahama");
    namesMap.put("BV", "Pulau Bouvet");
    namesMap.put("BY", "Belarusia");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kepulauan Cocos");
    namesMap.put("CD", "Kongo - Kinshasa");
    namesMap.put("CF", "Republik Afrika Tengah");
    namesMap.put("CG", "Kongo - Republik");
    namesMap.put("CH", "Swiss");
    namesMap.put("CI", "Cote d'Ivoire");
    namesMap.put("CK", "Kepulauan Cook");
    namesMap.put("CL", "Cile");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CO", "Kolombia");
    namesMap.put("CP", "Pulau Clipperton");
    namesMap.put("CR", "Kosta Rika");
    namesMap.put("CS", "Serbia dan Montenegro");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Tanjung Verde");
    namesMap.put("CX", "Pulau Christmas");
    namesMap.put("CY", "Siprus");
    namesMap.put("CZ", "Republik Cheska");
    namesMap.put("DE", "Jerman");
    namesMap.put("DJ", "Jibuti");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Republik Dominika");
    namesMap.put("EA", "Ceuta dan Melilla");
    namesMap.put("EC", "Ekuador");
    namesMap.put("EG", "Mesir");
    namesMap.put("EH", "Sahara Barat");
    namesMap.put("ES", "Spanyol");
    namesMap.put("EU", "Uni Eropa");
    namesMap.put("FI", "Finlandia");
    namesMap.put("FK", "Kepulauan Malvinas");
    namesMap.put("FM", "Mikronesia");
    namesMap.put("FO", "Kepulauan Faroe");
    namesMap.put("FR", "Prancis");
    namesMap.put("GB", "Britania Raya");
    namesMap.put("GF", "Guyana Perancis");
    namesMap.put("GL", "Grinlandia");
    namesMap.put("GQ", "Guinea Khatulistiwa");
    namesMap.put("GR", "Yunani");
    namesMap.put("GS", "Kepulauan South Sandwich dan South Georgia");
    namesMap.put("HM", "Pulau Heard dan Kepulauan McDonald");
    namesMap.put("HR", "Kroasia");
    namesMap.put("HU", "Hungaria");
    namesMap.put("IC", "Kepulauan Canary");
    namesMap.put("IE", "Irlandia");
    namesMap.put("IO", "Wilayah Inggris di Samudra Hindia");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Islandia");
    namesMap.put("IT", "Italia");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JO", "Yordania");
    namesMap.put("JP", "Jepang");
    namesMap.put("KG", "Kirgistan");
    namesMap.put("KH", "Kamboja");
    namesMap.put("KM", "Komoros");
    namesMap.put("KN", "Saint Kitts dan Nevis");
    namesMap.put("KP", "Korea Utara");
    namesMap.put("KR", "Korea Selatan");
    namesMap.put("KY", "Kepulauan Kayman");
    namesMap.put("KZ", "Kazakstan");
    namesMap.put("LT", "Lituania");
    namesMap.put("LU", "Luksemburg");
    namesMap.put("LY", "Libia");
    namesMap.put("MA", "Maroko");
    namesMap.put("MC", "Monako");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Kepulauan Marshall");
    namesMap.put("MK", "Makedonia");
    namesMap.put("MM", "Myanmar");
    namesMap.put("MO", "Makau");
    namesMap.put("MP", "Kepulauan Mariana Utara");
    namesMap.put("MV", "Maladewa");
    namesMap.put("MX", "Meksiko");
    namesMap.put("MZ", "Mozambik");
    namesMap.put("NC", "Kaledonia Baru");
    namesMap.put("NF", "Kepulauan Norfolk");
    namesMap.put("NI", "Nikaragua");
    namesMap.put("NL", "Belanda");
    namesMap.put("NO", "Norwegia");
    namesMap.put("NZ", "Selandia Baru");
    namesMap.put("PF", "Polinesia Prancis");
    namesMap.put("PG", "Nugini Papua Nugini");
    namesMap.put("PH", "Filipina");
    namesMap.put("PL", "Polandia");
    namesMap.put("PM", "Saint Pierre dan Miquelon");
    namesMap.put("PN", "Kepulauan Pitcairn");
    namesMap.put("PR", "Puerto Riko");
    namesMap.put("PS", "Otoritas Palestina");
    namesMap.put("PT", "Portugis");
    namesMap.put("QO", "Oseania Luar");
    namesMap.put("RO", "Rumania");
    namesMap.put("RU", "Rusia");
    namesMap.put("SA", "Arab Saudi");
    namesMap.put("SB", "Kepulauan Solomon");
    namesMap.put("SE", "Swedia");
    namesMap.put("SG", "Singapura");
    namesMap.put("SJ", "Kepulauan Svalbard dan Jan Mayen");
    namesMap.put("ST", "Sao Tome dan Principe");
    namesMap.put("TC", "Kepulauan Turks dan Caicos");
    namesMap.put("TF", "Teritori Kutub Selatan Prancis");
    namesMap.put("TL", "Timor Leste");
    namesMap.put("TM", "Turkimenistan");
    namesMap.put("TR", "Turki");
    namesMap.put("TT", "Trinidad dan Tobago");
    namesMap.put("UA", "Ukraina");
    namesMap.put("UM", "Kepulauan Kecil Terluar Amerika Serikat");
    namesMap.put("US", "Amerika Serikat");
    namesMap.put("VA", "Vatikan");
    namesMap.put("VC", "Saint Vincent dan Grenadines");
    namesMap.put("VG", "Kepulauan Virgin Inggris");
    namesMap.put("VI", "Kepulauan U.S. Virgin");
    namesMap.put("WF", "Kepulauan Wallis dan Futuna");
    namesMap.put("YE", "Yaman");
    namesMap.put("ZA", "Afrika Selatan");
    namesMap.put("ZZ", "Wilayah Tidak Dikenal");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Dunia",
        "002": "Afrika",
        "003": "Amerika Utara",
        "005": "Amerika Selatan",
        "009": "Oseania",
        "011": "Afrika Barat",
        "013": "Amerika Tengah",
        "014": "Afrika Timur",
        "015": "Afrika Utara",
        "017": "Afrika Tengah",
        "018": "Afrika bagian selatan",
        "019": "Amerika",
        "021": "Amerika bagian utara",
        "029": "Kepulauan Karibia",
        "030": "Asia Timur",
        "034": "Asia Selatan",
        "035": "Asia Tenggara",
        "039": "Eropa Selatan",
        "053": "Australia dan Selandia Baru",
        "057": "Wilayah Mikronesia",
        "061": "Polinesia",
        "143": "Asia Tengah",
        "145": "Asia Barat",
        "150": "Eropa",
        "151": "Eropa Timur",
        "154": "Eropa Utara",
        "155": "Eropa Barat",
        "419": "Amerika Latin",
        "AC": "Pulau Ascension",
        "AD": "Andora",
        "AE": "Uni Emirat Arab",
        "AG": "Antigua dan Barbuda",
        "AN": "Antilla Belanda",
        "AQ": "Antarktika",
        "AS": "Samoa Amerika",
        "AX": "Kepulauan Aland",
        "BA": "Bosnia dan Herzegovina",
        "BE": "Belgia",
        "BL": "Saint Barthelemy",
        "BR": "Brasil",
        "BS": "Bahama",
        "BV": "Pulau Bouvet",
        "BY": "Belarusia",
        "CA": "Kanada",
        "CC": "Kepulauan Cocos",
        "CD": "Kongo - Kinshasa",
        "CF": "Republik Afrika Tengah",
        "CG": "Kongo - Republik",
        "CH": "Swiss",
        "CI": "Cote d'Ivoire",
        "CK": "Kepulauan Cook",
        "CL": "Cile",
        "CM": "Kamerun",
        "CO": "Kolombia",
        "CP": "Pulau Clipperton",
        "CR": "Kosta Rika",
        "CS": "Serbia dan Montenegro",
        "CU": "Kuba",
        "CV": "Tanjung Verde",
        "CX": "Pulau Christmas",
        "CY": "Siprus",
        "CZ": "Republik Cheska",
        "DE": "Jerman",
        "DJ": "Jibuti",
        "DM": "Dominika",
        "DO": "Republik Dominika",
        "EA": "Ceuta dan Melilla",
        "EC": "Ekuador",
        "EG": "Mesir",
        "EH": "Sahara Barat",
        "ES": "Spanyol",
        "EU": "Uni Eropa",
        "FI": "Finlandia",
        "FK": "Kepulauan Malvinas",
        "FM": "Mikronesia",
        "FO": "Kepulauan Faroe",
        "FR": "Prancis",
        "GB": "Britania Raya",
        "GF": "Guyana Perancis",
        "GL": "Grinlandia",
        "GQ": "Guinea Khatulistiwa",
        "GR": "Yunani",
        "GS": "Kepulauan South Sandwich dan South Georgia",
        "HM": "Pulau Heard dan Kepulauan McDonald",
        "HR": "Kroasia",
        "HU": "Hungaria",
        "IC": "Kepulauan Canary",
        "IE": "Irlandia",
        "IO": "Wilayah Inggris di Samudra Hindia",
        "IQ": "Irak",
        "IS": "Islandia",
        "IT": "Italia",
        "JM": "Jamaika",
        "JO": "Yordania",
        "JP": "Jepang",
        "KG": "Kirgistan",
        "KH": "Kamboja",
        "KM": "Komoros",
        "KN": "Saint Kitts dan Nevis",
        "KP": "Korea Utara",
        "KR": "Korea Selatan",
        "KY": "Kepulauan Kayman",
        "KZ": "Kazakstan",
        "LT": "Lituania",
        "LU": "Luksemburg",
        "LY": "Libia",
        "MA": "Maroko",
        "MC": "Monako",
        "MG": "Madagaskar",
        "MH": "Kepulauan Marshall",
        "MK": "Makedonia",
        "MM": "Myanmar",
        "MO": "Makau",
        "MP": "Kepulauan Mariana Utara",
        "MV": "Maladewa",
        "MX": "Meksiko",
        "MZ": "Mozambik",
        "NC": "Kaledonia Baru",
        "NF": "Kepulauan Norfolk",
        "NI": "Nikaragua",
        "NL": "Belanda",
        "NO": "Norwegia",
        "NZ": "Selandia Baru",
        "PF": "Polinesia Prancis",
        "PG": "Nugini Papua Nugini",
        "PH": "Filipina",
        "PL": "Polandia",
        "PM": "Saint Pierre dan Miquelon",
        "PN": "Kepulauan Pitcairn",
        "PR": "Puerto Riko",
        "PS": "Otoritas Palestina",
        "PT": "Portugis",
        "QO": "Oseania Luar",
        "RO": "Rumania",
        "RU": "Rusia",
        "SA": "Arab Saudi",
        "SB": "Kepulauan Solomon",
        "SE": "Swedia",
        "SG": "Singapura",
        "SJ": "Kepulauan Svalbard dan Jan Mayen",
        "ST": "Sao Tome dan Principe",
        "TC": "Kepulauan Turks dan Caicos",
        "TF": "Teritori Kutub Selatan Prancis",
        "TL": "Timor Leste",
        "TM": "Turkimenistan",
        "TR": "Turki",
        "TT": "Trinidad dan Tobago",
        "UA": "Ukraina",
        "UM": "Kepulauan Kecil Terluar Amerika Serikat",
        "US": "Amerika Serikat",
        "VA": "Vatikan",
        "VC": "Saint Vincent dan Grenadines",
        "VG": "Kepulauan Virgin Inggris",
        "VI": "Kepulauan U.S. Virgin",
        "WF": "Kepulauan Wallis dan Futuna",
        "YE": "Yaman",
        "ZA": "Afrika Selatan",
        "ZZ": "Wilayah Tidak Dikenal"
    };
  }-*/;
}
