/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.CommonResources;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.CellBasedWidgetImpl;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasKeyProvider;
import com.google.gwt.view.client.ProvidesKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellWidget<C>
extends Widget
implements HasKeyProvider<C>,
HasValue<C> {
    private final Cell<C> cell;
    private final ProvidesKey<C> keyProvider;
    private C value;
    private final ValueUpdater<C> valueUpdater = new ValueUpdater<C>(){

        @Override
        public void update(C value) {
            ValueChangeEvent.fire(CellWidget.this, value);
        }
    };

    private static Element createDefaultWrapperElement() {
        DivElement div = Document.get().createDivElement();
        div.setClassName(CommonResources.getInlineBlockStyle());
        return div;
    }

    public CellWidget(Cell<C> cell) {
        this(cell, null, null);
    }

    public CellWidget(Cell<C> cell, ProvidesKey<C> keyProvider) {
        this(cell, null, keyProvider);
    }

    public CellWidget(Cell<C> cell, C initialValue) {
        this(cell, initialValue, null);
    }

    public CellWidget(Cell<C> cell, C initialValue, ProvidesKey<C> keyProvider) {
        this(cell, initialValue, keyProvider, CellWidget.createDefaultWrapperElement());
    }

    protected CellWidget(Cell<C> cell, C initialValue, ProvidesKey<C> keyProvider, Element elem) {
        this.cell = cell;
        this.keyProvider = keyProvider;
        this.setElement(elem);
        CellBasedWidgetImpl.get().sinkEvents(this, cell.getConsumedEvents());
        this.setValue(initialValue);
    }

    @Override
    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<C> handler) {
        return this.addHandler(handler, ValueChangeEvent.getType());
    }

    public Cell<C> getCell() {
        return this.cell;
    }

    @Override
    public ProvidesKey<C> getKeyProvider() {
        return this.keyProvider;
    }

    @Override
    public C getValue() {
        return this.value;
    }

    @Override
    public void onBrowserEvent(Event event) {
        CellBasedWidgetImpl.get().onBrowserEvent(this, event);
        super.onBrowserEvent(event);
        String eventType = event.getType();
        if (this.cell.getConsumedEvents().contains(eventType)) {
            this.cell.onBrowserEvent(this.createContext(), this.getElement(), this.value, event, this.valueUpdater);
        }
    }

    public void redraw() {
        SafeHtmlBuilder sb = new SafeHtmlBuilder();
        this.cell.render(this.createContext(), this.value, sb);
        this.getElement().setInnerHTML(sb.toSafeHtml().asString());
    }

    @Override
    public void setValue(C value) {
        this.setValue(value, false, true);
    }

    @Override
    public void setValue(C value, boolean fireEvents) {
        this.setValue(value, fireEvents, true);
    }

    public void setValue(C value, boolean fireEvents, boolean redraw) {
        C oldValue = this.getValue();
        if (!(value == oldValue || oldValue != null && oldValue.equals(value))) {
            this.value = value;
            if (redraw) {
                this.redraw();
            }
            if (fireEvents) {
                ValueChangeEvent.fire(this, value);
            }
        }
    }

    private Cell.Context createContext() {
        return new Cell.Context(0, 0, this.getKey(this.value));
    }

    private Object getKey(C value) {
        return this.keyProvider == null || value == null ? value : this.keyProvider.getKey(value);
    }
}

