/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.cellview.client;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.CellBasedWidgetImpl;
import com.google.gwt.user.cellview.client.HasDataPresenter;
import com.google.gwt.user.cellview.client.HasKeyboardPagingPolicy;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.impl.FocusImpl;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.HasKeyProvider;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.Range;
import com.google.gwt.view.client.RangeChangeEvent;
import com.google.gwt.view.client.RowCountChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHasData<T>
extends Widget
implements HasData<T>,
HasKeyProvider<T>,
Focusable,
HasKeyboardPagingPolicy {
    private static com.google.gwt.user.client.Element tmpElem;
    boolean isFocused;
    private char accessKey = '\u0000';
    private boolean isRefreshing;
    private final HasDataPresenter<T> presenter;
    private HandlerRegistration selectionManagerReg;
    private int tabIndex;

    static Element convertToElements(Widget widget, com.google.gwt.user.client.Element tmpElem, SafeHtml html) {
        DOM.setEventListener(tmpElem, widget);
        tmpElem.setInnerHTML(html.asString());
        DOM.setEventListener(tmpElem, null);
        return tmpElem;
    }

    static void replaceAllChildren(Widget widget, Element childContainer, SafeHtml html) {
        if (!widget.isAttached()) {
            DOM.setEventListener(widget.getElement(), widget);
        }
        childContainer.setInnerHTML(CellBasedWidgetImpl.get().processHtml(html).asString());
        if (!widget.isAttached()) {
            DOM.setEventListener(widget.getElement(), null);
        }
    }

    static void replaceChildren(Widget widget, Element childContainer, Element newChildren, int start, SafeHtml html) {
        int childCount = childContainer.getChildCount();
        Element toReplace = null;
        if (start < childCount) {
            toReplace = (Element)childContainer.getChild(start).cast();
        }
        int count = newChildren.getChildCount();
        for (int i = 0; i < count; ++i) {
            if (toReplace == null) {
                childContainer.appendChild(newChildren.getChild(0));
                continue;
            }
            Element nextSibling = toReplace.getNextSiblingElement();
            childContainer.replaceChild(newChildren.getChild(0), toReplace);
            toReplace = nextSibling;
        }
    }

    private static com.google.gwt.user.client.Element getTmpElem() {
        if (tmpElem == null) {
            tmpElem = (com.google.gwt.user.client.Element)Document.get().createDivElement().cast();
        }
        return tmpElem;
    }

    public AbstractHasData(Element elem, int pageSize, ProvidesKey<T> keyProvider) {
        this.setElement(elem);
        this.presenter = new HasDataPresenter(this, new View(this), pageSize, keyProvider);
        HashSet<String> eventTypes = new HashSet<String>();
        eventTypes.add("focus");
        eventTypes.add("blur");
        eventTypes.add("keydown");
        eventTypes.add("keyup");
        eventTypes.add("click");
        eventTypes.add("mousedown");
        CellBasedWidgetImpl.get().sinkEvents(this, eventTypes);
        this.selectionManagerReg = this.addCellPreviewHandler(DefaultSelectionEventManager.createDefaultManager());
    }

    @Override
    public HandlerRegistration addCellPreviewHandler(CellPreviewEvent.Handler<T> handler) {
        return this.presenter.addCellPreviewHandler(handler);
    }

    @Override
    public HandlerRegistration addRangeChangeHandler(RangeChangeEvent.Handler handler) {
        return this.presenter.addRangeChangeHandler(handler);
    }

    @Override
    public HandlerRegistration addRowCountChangeHandler(RowCountChangeEvent.Handler handler) {
        return this.presenter.addRowCountChangeHandler(handler);
    }

    public char getAccessKey() {
        return this.accessKey;
    }

    @Deprecated
    public T getDisplayedItem(int indexOnPage) {
        return this.getVisibleItem(indexOnPage);
    }

    @Deprecated
    public List<T> getDisplayedItems() {
        return this.getVisibleItems();
    }

    @Override
    public HasKeyboardPagingPolicy.KeyboardPagingPolicy getKeyboardPagingPolicy() {
        return this.presenter.getKeyboardPagingPolicy();
    }

    @Override
    public HasKeyboardSelectionPolicy.KeyboardSelectionPolicy getKeyboardSelectionPolicy() {
        return this.presenter.getKeyboardSelectionPolicy();
    }

    @Override
    public ProvidesKey<T> getKeyProvider() {
        return this.presenter.getKeyProvider();
    }

    public final int getPageSize() {
        return this.getVisibleRange().getLength();
    }

    public final int getPageStart() {
        return this.getVisibleRange().getStart();
    }

    public Element getRowContainer() {
        this.presenter.flush();
        return this.getChildContainer();
    }

    @Override
    public int getRowCount() {
        return this.presenter.getRowCount();
    }

    @Override
    public SelectionModel<? super T> getSelectionModel() {
        return this.presenter.getSelectionModel();
    }

    @Override
    public int getTabIndex() {
        return this.tabIndex;
    }

    @Override
    public T getVisibleItem(int indexOnPage) {
        this.checkRowBounds(indexOnPage);
        return this.presenter.getVisibleItem(indexOnPage);
    }

    @Override
    public int getVisibleItemCount() {
        return this.presenter.getVisibleItemCount();
    }

    @Override
    public List<T> getVisibleItems() {
        return this.presenter.getVisibleItems();
    }

    @Override
    public Range getVisibleRange() {
        return this.presenter.getVisibleRange();
    }

    @Override
    public boolean isRowCountExact() {
        return this.presenter.isRowCountExact();
    }

    @Override
    public final void onBrowserEvent(Event event) {
        CellBasedWidgetImpl.get().onBrowserEvent(this, event);
        if (this.isRefreshing) {
            return;
        }
        EventTarget eventTarget = event.getEventTarget();
        if (!Element.is(eventTarget) || !this.getElement().isOrHasChild(Element.as(eventTarget))) {
            return;
        }
        super.onBrowserEvent(event);
        String eventType = event.getType();
        if ("focus".equals(eventType)) {
            this.isFocused = true;
            this.onFocus();
        } else if ("blur".equals(eventType)) {
            this.isFocused = false;
            this.onBlur();
        } else if ("keydown".equals(eventType) && !this.isKeyboardNavigationSuppressed()) {
            this.isFocused = true;
            int keyCode = event.getKeyCode();
            switch (keyCode) {
                case 40: {
                    this.presenter.keyboardNext();
                    event.preventDefault();
                    return;
                }
                case 38: {
                    this.presenter.keyboardPrev();
                    event.preventDefault();
                    return;
                }
                case 34: {
                    this.presenter.keyboardNextPage();
                    event.preventDefault();
                    return;
                }
                case 33: {
                    this.presenter.keyboardPrevPage();
                    event.preventDefault();
                    return;
                }
                case 36: {
                    this.presenter.keyboardHome();
                    event.preventDefault();
                    return;
                }
                case 35: {
                    this.presenter.keyboardEnd();
                    event.preventDefault();
                    return;
                }
                case 32: {
                    event.preventDefault();
                    return;
                }
            }
        }
        this.onBrowserEvent2(event);
    }

    public void redraw() {
        this.presenter.redraw();
    }

    @Override
    public void setAccessKey(char key) {
        this.accessKey = key;
        this.setKeyboardSelected(this.getKeyboardSelectedRow(), true, false);
    }

    @Override
    public void setFocus(boolean focused) {
        Element elem = this.getKeyboardSelectedElement();
        if (elem != null) {
            if (focused) {
                elem.focus();
            } else {
                elem.blur();
            }
        }
    }

    @Override
    public void setKeyboardPagingPolicy(HasKeyboardPagingPolicy.KeyboardPagingPolicy policy) {
        this.presenter.setKeyboardPagingPolicy(policy);
    }

    @Override
    public void setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy policy) {
        this.presenter.setKeyboardSelectionPolicy(policy);
    }

    public final void setPageSize(int pageSize) {
        this.setVisibleRange(this.getPageStart(), pageSize);
    }

    public final void setPageStart(int pageStart) {
        this.setVisibleRange(pageStart, this.getPageSize());
    }

    @Override
    public final void setRowCount(int count) {
        this.setRowCount(count, true);
    }

    @Override
    public void setRowCount(int size, boolean isExact) {
        this.presenter.setRowCount(size, isExact);
    }

    public final void setRowData(List<? extends T> values) {
        this.setRowCount(values.size());
        this.setVisibleRange(0, values.size());
        this.setRowData(0, values);
    }

    @Override
    public void setRowData(int start, List<? extends T> values) {
        this.presenter.setRowData(start, values);
    }

    @Override
    public void setSelectionModel(SelectionModel<? super T> selectionModel) {
        this.presenter.setSelectionModel(selectionModel);
    }

    public void setSelectionModel(SelectionModel<? super T> selectionModel, CellPreviewEvent.Handler<T> selectionEventManager) {
        if (this.selectionManagerReg != null) {
            this.selectionManagerReg.removeHandler();
            this.selectionManagerReg = null;
        }
        if (selectionEventManager != null) {
            this.selectionManagerReg = this.addCellPreviewHandler(selectionEventManager);
        }
        this.setSelectionModel(selectionModel);
    }

    @Override
    public void setTabIndex(int index) {
        this.tabIndex = index;
        this.setKeyboardSelected(this.getKeyboardSelectedRow(), true, false);
    }

    @Override
    public final void setVisibleRange(int start, int length) {
        this.setVisibleRange(new Range(start, length));
    }

    @Override
    public void setVisibleRange(Range range) {
        this.presenter.setVisibleRange(range);
    }

    @Override
    public void setVisibleRangeAndClearData(Range range, boolean forceRangeChangeEvent) {
        this.presenter.setVisibleRangeAndClearData(range, forceRangeChangeEvent);
    }

    protected boolean cellConsumesEventType(Cell<?> cell, String eventType) {
        Set<String> consumedEvents = cell.getConsumedEvents();
        return consumedEvents != null && consumedEvents.contains(eventType);
    }

    protected void checkRowBounds(int row) {
        if (!this.isRowWithinBounds(row)) {
            throw new IndexOutOfBoundsException("Row index: " + row + ", Row size: " + this.getRowCount());
        }
    }

    protected Element convertToElements(SafeHtml html) {
        return AbstractHasData.convertToElements(this, AbstractHasData.getTmpElem(), html);
    }

    protected abstract boolean dependsOnSelection();

    protected abstract Element getChildContainer();

    protected abstract Element getKeyboardSelectedElement();

    protected int getKeyboardSelectedRow() {
        return this.presenter.getKeyboardSelectedRow();
    }

    protected Object getValueKey(T value) {
        ProvidesKey<T> keyProvider = this.getKeyProvider();
        return keyProvider == null || value == null ? value : keyProvider.getKey(value);
    }

    protected abstract boolean isKeyboardNavigationSuppressed();

    protected boolean isRowWithinBounds(int row) {
        return row >= 0 && row < this.presenter.getVisibleItemCount();
    }

    protected void onBlur() {
    }

    protected void onBrowserEvent2(Event event) {
    }

    protected void onFocus() {
    }

    @Override
    protected void onUnload() {
        this.isFocused = false;
        super.onUnload();
    }

    @Deprecated
    protected void onUpdateSelection() {
    }

    protected abstract void renderRowValues(SafeHtmlBuilder var1, List<T> var2, int var3, SelectionModel<? super T> var4);

    protected void replaceAllChildren(List<T> values, SafeHtml html) {
        AbstractHasData.replaceAllChildren(this, this.getChildContainer(), html);
    }

    protected void replaceChildren(List<T> values, int start, SafeHtml html) {
        Element newChildren = this.convertToElements(html);
        AbstractHasData.replaceChildren(this, this.getChildContainer(), newChildren, start, html);
    }

    protected abstract boolean resetFocusOnCell();

    protected void setFocusable(Element elem, boolean focusable) {
        if (focusable) {
            FocusImpl focusImpl = FocusImpl.getFocusImplForWidget();
            com.google.gwt.user.client.Element rowElem = (com.google.gwt.user.client.Element)elem.cast();
            focusImpl.setTabIndex(rowElem, this.getTabIndex());
            if (this.accessKey != '\u0000') {
                focusImpl.setAccessKey(rowElem, this.accessKey);
            }
        } else {
            elem.setTabIndex(-1);
            elem.removeAttribute("tabIndex");
            elem.removeAttribute("accessKey");
        }
    }

    protected abstract void setKeyboardSelected(int var1, boolean var2, boolean var3);

    @Deprecated
    protected void setSelected(Element elem, boolean selected) {
    }

    final HandlerRegistration addValueChangeHandler(ValueChangeHandler<List<T>> handler) {
        return this.addHandler(handler, ValueChangeEvent.getType());
    }

    HasDataPresenter<T> getPresenter() {
        return this.presenter;
    }

    void setLoadingState(HasDataPresenter.LoadingState state) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class View<T>
    implements HasDataPresenter.View<T> {
        private final AbstractHasData<T> hasData;
        private boolean wasFocused;

        public View(AbstractHasData<T> hasData) {
            this.hasData = hasData;
        }

        @Override
        public <H extends EventHandler> HandlerRegistration addHandler(H handler, GwtEvent.Type<H> type) {
            return this.hasData.addHandler(handler, type);
        }

        @Override
        public void render(SafeHtmlBuilder sb, List<T> values, int start, SelectionModel<? super T> selectionModel) {
            this.hasData.renderRowValues(sb, values, start, selectionModel);
        }

        @Override
        public void replaceAllChildren(List<T> values, SafeHtml html, boolean stealFocus) {
            this.wasFocused = this.hasData.isFocused = this.hasData.isFocused || stealFocus;
            ((AbstractHasData)this.hasData).isRefreshing = true;
            this.hasData.replaceAllChildren(values, html);
            ((AbstractHasData)this.hasData).isRefreshing = false;
            this.fireValueChangeEvent();
        }

        @Override
        public void replaceChildren(List<T> values, int start, SafeHtml html, boolean stealFocus) {
            this.wasFocused = this.hasData.isFocused = this.hasData.isFocused || stealFocus;
            ((AbstractHasData)this.hasData).isRefreshing = true;
            this.hasData.replaceChildren(values, start, html);
            ((AbstractHasData)this.hasData).isRefreshing = false;
            this.fireValueChangeEvent();
        }

        @Override
        public void resetFocus() {
            if (this.wasFocused) {
                CellBasedWidgetImpl.get().resetFocus(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        Element elem;
                        if (!View.this.hasData.resetFocusOnCell() && (elem = View.this.hasData.getKeyboardSelectedElement()) != null) {
                            elem.focus();
                        }
                    }
                });
            }
        }

        @Override
        public void setKeyboardSelected(int index, boolean seleted, boolean stealFocus) {
            this.hasData.isFocused = this.hasData.isFocused || stealFocus;
            this.hasData.setKeyboardSelected(index, seleted, stealFocus);
        }

        @Override
        public void setLoadingState(HasDataPresenter.LoadingState state) {
            ((AbstractHasData)this.hasData).isRefreshing = true;
            this.hasData.setLoadingState(state);
            ((AbstractHasData)this.hasData).isRefreshing = false;
        }

        private void fireValueChangeEvent() {
            this.hasData.fireEvent(new ValueChangeEvent<List<T>>((List)this.hasData.getVisibleItems()){});
        }
    }
}

