/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.cell.client;

import com.google.gwt.cell.client.AbstractEditableCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInputCell<C, V>
extends AbstractEditableCell<C, V> {
    private Object focusedKey;

    private static Set<String> getConsumedEventsImpl(Set<String> userEvents) {
        HashSet<String> events = new HashSet<String>();
        events.add("focus");
        events.add("blur");
        events.add("keydown");
        if (userEvents != null && userEvents.size() > 0) {
            events.addAll(userEvents);
        }
        return events;
    }

    private static Set<String> getConsumedEventsImpl(String ... consumedEvents) {
        HashSet<String> userEvents = new HashSet<String>();
        if (consumedEvents != null) {
            for (String event : consumedEvents) {
                userEvents.add(event);
            }
        }
        return AbstractInputCell.getConsumedEventsImpl(userEvents);
    }

    public AbstractInputCell(String ... consumedEvents) {
        super(AbstractInputCell.getConsumedEventsImpl(consumedEvents));
    }

    public AbstractInputCell(Set<String> consumedEvents) {
        super(AbstractInputCell.getConsumedEventsImpl(consumedEvents));
    }

    @Override
    public boolean isEditing(Cell.Context context, Element parent, C value) {
        return this.focusedKey != null && this.focusedKey.equals(context.getKey());
    }

    @Override
    public void onBrowserEvent(Cell.Context context, Element parent, C value, NativeEvent event, ValueUpdater<C> valueUpdater) {
        super.onBrowserEvent(context, parent, value, event, valueUpdater);
        Element target = (Element)event.getEventTarget().cast();
        if (!this.getInputElement(parent).isOrHasChild(target)) {
            return;
        }
        String eventType = event.getType();
        if ("focus".equals(eventType)) {
            this.focusedKey = context.getKey();
        } else if ("blur".equals(eventType)) {
            this.focusedKey = null;
        }
    }

    @Override
    public boolean resetFocus(Cell.Context context, Element parent, C value) {
        if (this.isEditing(context, parent, value)) {
            this.getInputElement(parent).focus();
            return true;
        }
        return false;
    }

    protected void finishEditing(Element parent, C value, Object key, ValueUpdater<C> valueUpdater) {
        this.focusedKey = null;
        this.getInputElement(parent).blur();
    }

    protected Element getInputElement(Element parent) {
        return parent.getFirstChildElement();
    }

    @Override
    protected void onEnterKeyDown(Cell.Context context, Element parent, C value, NativeEvent event, ValueUpdater<C> valueUpdater) {
        Element input = this.getInputElement(parent);
        Element target = (Element)event.getEventTarget().cast();
        Object key = context.getKey();
        if (this.getInputElement(parent).isOrHasChild(target)) {
            this.finishEditing(parent, value, key, valueUpdater);
        } else {
            this.focusedKey = key;
            input.focus();
        }
    }
}

