/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "nds" locale.
 */
public class LocalizedNamesImpl_nds extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "DE",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "EG",
        "AX",
        "AL",
        "DZ",
        "VI",
        "UM",
        "AS",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "GQ",
        "AR",
        "AM",
        "AW",
        "AZ",
        "ET",
        "AU",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "MM",
        "BO",
        "BA",
        "BW",
        "BV",
        "BR",
        "VG",
        "IO",
        "BN",
        "BG",
        "BF",
        "BI",
        "QO",
        "CL",
        "CN",
        "CK",
        "CR",
        "CP",
        "DK",
        "CD",
        "DG",
        "DM",
        "DO",
        "DJ",
        "DE",
        "EA",
        "EC",
        "EE",
        "CI",
        "SV",
        "ER",
        "EU",
        "FK",
        "FO",
        "FJ",
        "FI",
        "FR",
        "TF",
        "GF",
        "PF",
        "GA",
        "GM",
        "GE",
        "GH",
        "GI",
        "GR",
        "GD",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GY",
        "HT",
        "HM",
        "HN",
        "HK",
        "IC",
        "IS",
        "IN",
        "ID",
        "IM",
        "IQ",
        "IR",
        "IE",
        "IL",
        "IT",
        "JM",
        "JP",
        "YE",
        "JE",
        "JO",
        "KY",
        "KH",
        "CM",
        "CA",
        "CV",
        "KZ",
        "QA",
        "KE",
        "KG",
        "KI",
        "CC",
        "CO",
        "KM",
        "HR",
        "CU",
        "KW",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MO",
        "MG",
        "MK",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MA",
        "MH",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "NA",
        "NR",
        "AN",
        "NL",
        "NC",
        "NZ",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "KP",
        "MP",
        "NF",
        "NO",
        "OM",
        "AT",
        "TL",
        "PK",
        "PS",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PH",
        "PN",
        "PL",
        "PT",
        "PR",
        "CG",
        "RE",
        "RW",
        "RO",
        "RU",
        "BL",
        "MF",
        "SB",
        "ZM",
        "WS",
        "SM",
        "ST",
        "SA",
        "SN",
        "RS",
        "SC",
        "SL",
        "ZW",
        "SG",
        "SK",
        "SI",
        "SO",
        "ES",
        "LK",
        "SH",
        "KN",
        "LC",
        "PM",
        "VC",
        "SD",
        "SR",
        "ZA",
        "GS",
        "KR",
        "SJ",
        "SZ",
        "SE",
        "CH",
        "SY",
        "TA",
        "TJ",
        "TW",
        "TZ",
        "TH",
        "TG",
        "TK",
        "TO",
        "TR",
        "TT",
        "TD",
        "CZ",
        "TN",
        "TM",
        "TC",
        "TV",
        "UG",
        "UA",
        "HU",
        "UY",
        "US",
        "UZ",
        "VU",
        "VA",
        "VE",
        "AE",
        "GB",
        "VN",
        "WF",
        "EH",
        "CX",
        "BY",
        "CF",
        "CY",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Welt");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Noordamerika");
    namesMap.put("005", "Süüdamerika");
    namesMap.put("009", "Ozeanien");
    namesMap.put("011", "Westafrika");
    namesMap.put("013", "Middelamerika");
    namesMap.put("014", "Oostafrika");
    namesMap.put("015", "Noordafrika");
    namesMap.put("017", "Zentralafrika");
    namesMap.put("018", "Süüdlich Afrika");
    namesMap.put("019", "Amerika");
    namesMap.put("029", "Karibik");
    namesMap.put("030", "Oostasien");
    namesMap.put("034", "Süüdasien");
    namesMap.put("035", "Süüdoostasien");
    namesMap.put("039", "Süüdeuropa");
    namesMap.put("053", "Australien un Neeseeland");
    namesMap.put("054", "Melanesien");
    namesMap.put("061", "Polynesien");
    namesMap.put("062", "Süüd-Zentralasien");
    namesMap.put("142", "Asien");
    namesMap.put("143", "Zentralasien");
    namesMap.put("145", "Westasien");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Oosteuropa");
    namesMap.put("154", "Noordeuropa");
    namesMap.put("155", "Westeuropa");
    namesMap.put("172", "Gemeenschop vun Unafhängige Staten");
    namesMap.put("419", "Latienamerika un Karibik");
    namesMap.put("AE", "Vereenigte Araabsche Emiraten");
    namesMap.put("AG", "Antigua un Barbuda");
    namesMap.put("AL", "Albanien");
    namesMap.put("AM", "Armenien");
    namesMap.put("AN", "Nedderlandsche Antillen");
    namesMap.put("AQ", "Antarktis");
    namesMap.put("AR", "Argentinien");
    namesMap.put("AS", "Amerikaansch-Samoa");
    namesMap.put("AT", "Öösterriek");
    namesMap.put("AU", "Australien");
    namesMap.put("AX", "Ålandeilannen");
    namesMap.put("AZ", "Aserbaidschan");
    namesMap.put("BA", "Bosnien un Herzegowina");
    namesMap.put("BD", "Bangladesch");
    namesMap.put("BE", "Belgien");
    namesMap.put("BG", "Bulgarien");
    namesMap.put("BN", "Brunei Darussalam");
    namesMap.put("BO", "Bolivien");
    namesMap.put("BR", "Brasilien");
    namesMap.put("BV", "Bouvet-Eiland");
    namesMap.put("BY", "Wittrussland");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kokos-Eilannen");
    namesMap.put("CD", "Demokraatsche Republik Kongo");
    namesMap.put("CF", "Zentralafrikaansche Republik");
    namesMap.put("CG", "Republik Kongo");
    namesMap.put("CH", "Swiez");
    namesMap.put("CI", "Elfenbeenküst");
    namesMap.put("CK", "Cook-Eilannen");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CO", "Kolumbien");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kap Verde");
    namesMap.put("CX", "Wiehnachtseiland");
    namesMap.put("CY", "Zypern");
    namesMap.put("CZ", "Tschechien");
    namesMap.put("DE", "Düütschland");
    namesMap.put("DJ", "Dschibuti");
    namesMap.put("DK", "Däänmark");
    namesMap.put("DO", "Dominikaansche Republik");
    namesMap.put("DZ", "Algerien");
    namesMap.put("EE", "Eestland");
    namesMap.put("EG", "Ägypten");
    namesMap.put("EH", "Westsahara");
    namesMap.put("ES", "Spanien");
    namesMap.put("ET", "Äthiopien");
    namesMap.put("EU", "Europääsche Union");
    namesMap.put("FI", "Finnland");
    namesMap.put("FJ", "Fidschi");
    namesMap.put("FK", "Falkland-Eilannen");
    namesMap.put("FM", "Mikronesien");
    namesMap.put("FO", "Färöer");
    namesMap.put("FR", "Frankriek");
    namesMap.put("GA", "Gabun");
    namesMap.put("GB", "Vereenigt Königriek");
    namesMap.put("GE", "Georgien");
    namesMap.put("GF", "Franzöösch-Guayana");
    namesMap.put("GL", "Gröönland");
    namesMap.put("GQ", "Äquatorialguinea");
    namesMap.put("GR", "Grekenland");
    namesMap.put("GS", "Süüdgeorgien un de Südlichen Sandwich-Eilannen");
    namesMap.put("HK", "Hongkong");
    namesMap.put("HM", "Heard- un McDonald-Eilannen");
    namesMap.put("HR", "Kroatien");
    namesMap.put("HU", "Ungarn");
    namesMap.put("ID", "Indonesien");
    namesMap.put("IE", "Irland");
    namesMap.put("IM", "Insel Man");
    namesMap.put("IN", "Indien");
    namesMap.put("IO", "Britisch Rebeed in’n Indischen Ozean");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Iesland");
    namesMap.put("IT", "Italien");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JO", "Jordanien");
    namesMap.put("KE", "Kenia");
    namesMap.put("KG", "Kirgisistan");
    namesMap.put("KH", "Kambodscha");
    namesMap.put("KM", "Komoren");
    namesMap.put("KN", "St. Kitts un Nevis");
    namesMap.put("KP", "Noordkorea");
    namesMap.put("KR", "Süüdkorea");
    namesMap.put("KY", "Kaiman-Eilannen");
    namesMap.put("KZ", "Kasachstan");
    namesMap.put("LB", "Libanon");
    namesMap.put("LC", "St. Lucia");
    namesMap.put("LI", "Liechtensteen");
    namesMap.put("LT", "Litauen");
    namesMap.put("LU", "Luxemborg");
    namesMap.put("LV", "Lettland");
    namesMap.put("LY", "Libyen");
    namesMap.put("MA", "Marokko");
    namesMap.put("MD", "Moldawien");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Marshall-Eilannen");
    namesMap.put("MK", "Makedonien");
    namesMap.put("MM", "Birma");
    namesMap.put("MN", "Mongolei");
    namesMap.put("MO", "Macao");
    namesMap.put("MP", "Nöördliche Marianen");
    namesMap.put("MR", "Mauretanien");
    namesMap.put("MV", "Malediven");
    namesMap.put("MX", "Mexiko");
    namesMap.put("MZ", "Mosambik");
    namesMap.put("NC", "Neekaledonien");
    namesMap.put("NF", "Norfolk");
    namesMap.put("NI", "Nikaragua");
    namesMap.put("NL", "Nedderlannen");
    namesMap.put("NO", "Norwegen");
    namesMap.put("NZ", "Neeseeland");
    namesMap.put("PF", "Franzöösch-Polynesien");
    namesMap.put("PG", "Papua-Neeguinea");
    namesMap.put("PH", "Philippinen");
    namesMap.put("PL", "Polen");
    namesMap.put("PM", "St. Pierre un Miquelon");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PS", "Palästinensische Rebeden");
    namesMap.put("QA", "Katar");
    namesMap.put("QO", "Büter Ozeanien");
    namesMap.put("RE", "Reunion");
    namesMap.put("RO", "Rumänien");
    namesMap.put("RS", "Serbien");
    namesMap.put("RU", "Russland");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Saudi-Arabien");
    namesMap.put("SB", "Salomonen");
    namesMap.put("SC", "Seychellen");
    namesMap.put("SG", "Singapur");
    namesMap.put("SH", "St. Helena");
    namesMap.put("SI", "Slowenien");
    namesMap.put("SJ", "Svalbard un Jan Mayen");
    namesMap.put("SK", "Slowakei");
    namesMap.put("SR", "Surinam");
    namesMap.put("ST", "São Tomé un Príncipe");
    namesMap.put("SY", "Syrien");
    namesMap.put("SZ", "Swasiland");
    namesMap.put("TC", "Turks- un Caicosinseln");
    namesMap.put("TD", "Tschad");
    namesMap.put("TF", "Franzöösche Süüd- un Antarktisrebeden");
    namesMap.put("TJ", "Tadschikistan");
    namesMap.put("TL", "Oosttimor");
    namesMap.put("TN", "Tunesien");
    namesMap.put("TR", "Törkie");
    namesMap.put("TT", "Trinidad un Tobago");
    namesMap.put("TZ", "Tansania");
    namesMap.put("UM", "Amerikaansch-Ozeanien");
    namesMap.put("US", "USA");
    namesMap.put("UZ", "Usbekistan");
    namesMap.put("VA", "Vatikan");
    namesMap.put("VC", "St. Vincent un de Grenadinen");
    namesMap.put("VG", "Brietsche Jumfern-Eilannen");
    namesMap.put("VI", "Amerikaansche Jumfern-Eilannen");
    namesMap.put("WF", "Wallis un Futuna");
    namesMap.put("YE", "Jemen");
    namesMap.put("ZA", "Süüdafrika");
    namesMap.put("ZM", "Sambia");
    namesMap.put("ZW", "Simbabwe");
    namesMap.put("ZZ", "Unbekannte oder ungüllige Region");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Welt",
        "002": "Afrika",
        "003": "Noordamerika",
        "005": "Süüdamerika",
        "009": "Ozeanien",
        "011": "Westafrika",
        "013": "Middelamerika",
        "014": "Oostafrika",
        "015": "Noordafrika",
        "017": "Zentralafrika",
        "018": "Süüdlich Afrika",
        "019": "Amerika",
        "029": "Karibik",
        "030": "Oostasien",
        "034": "Süüdasien",
        "035": "Süüdoostasien",
        "039": "Süüdeuropa",
        "053": "Australien un Neeseeland",
        "054": "Melanesien",
        "061": "Polynesien",
        "062": "Süüd-Zentralasien",
        "142": "Asien",
        "143": "Zentralasien",
        "145": "Westasien",
        "150": "Europa",
        "151": "Oosteuropa",
        "154": "Noordeuropa",
        "155": "Westeuropa",
        "172": "Gemeenschop vun Unafhängige Staten",
        "419": "Latienamerika un Karibik",
        "AE": "Vereenigte Araabsche Emiraten",
        "AG": "Antigua un Barbuda",
        "AL": "Albanien",
        "AM": "Armenien",
        "AN": "Nedderlandsche Antillen",
        "AQ": "Antarktis",
        "AR": "Argentinien",
        "AS": "Amerikaansch-Samoa",
        "AT": "Öösterriek",
        "AU": "Australien",
        "AX": "Ålandeilannen",
        "AZ": "Aserbaidschan",
        "BA": "Bosnien un Herzegowina",
        "BD": "Bangladesch",
        "BE": "Belgien",
        "BG": "Bulgarien",
        "BN": "Brunei Darussalam",
        "BO": "Bolivien",
        "BR": "Brasilien",
        "BV": "Bouvet-Eiland",
        "BY": "Wittrussland",
        "CA": "Kanada",
        "CC": "Kokos-Eilannen",
        "CD": "Demokraatsche Republik Kongo",
        "CF": "Zentralafrikaansche Republik",
        "CG": "Republik Kongo",
        "CH": "Swiez",
        "CI": "Elfenbeenküst",
        "CK": "Cook-Eilannen",
        "CM": "Kamerun",
        "CO": "Kolumbien",
        "CU": "Kuba",
        "CV": "Kap Verde",
        "CX": "Wiehnachtseiland",
        "CY": "Zypern",
        "CZ": "Tschechien",
        "DE": "Düütschland",
        "DJ": "Dschibuti",
        "DK": "Däänmark",
        "DO": "Dominikaansche Republik",
        "DZ": "Algerien",
        "EE": "Eestland",
        "EG": "Ägypten",
        "EH": "Westsahara",
        "ES": "Spanien",
        "ET": "Äthiopien",
        "EU": "Europääsche Union",
        "FI": "Finnland",
        "FJ": "Fidschi",
        "FK": "Falkland-Eilannen",
        "FM": "Mikronesien",
        "FO": "Färöer",
        "FR": "Frankriek",
        "GA": "Gabun",
        "GB": "Vereenigt Königriek",
        "GE": "Georgien",
        "GF": "Franzöösch-Guayana",
        "GL": "Gröönland",
        "GQ": "Äquatorialguinea",
        "GR": "Grekenland",
        "GS": "Süüdgeorgien un de Südlichen Sandwich-Eilannen",
        "HK": "Hongkong",
        "HM": "Heard- un McDonald-Eilannen",
        "HR": "Kroatien",
        "HU": "Ungarn",
        "ID": "Indonesien",
        "IE": "Irland",
        "IM": "Insel Man",
        "IN": "Indien",
        "IO": "Britisch Rebeed in’n Indischen Ozean",
        "IQ": "Irak",
        "IS": "Iesland",
        "IT": "Italien",
        "JM": "Jamaika",
        "JO": "Jordanien",
        "KE": "Kenia",
        "KG": "Kirgisistan",
        "KH": "Kambodscha",
        "KM": "Komoren",
        "KN": "St. Kitts un Nevis",
        "KP": "Noordkorea",
        "KR": "Süüdkorea",
        "KY": "Kaiman-Eilannen",
        "KZ": "Kasachstan",
        "LB": "Libanon",
        "LC": "St. Lucia",
        "LI": "Liechtensteen",
        "LT": "Litauen",
        "LU": "Luxemborg",
        "LV": "Lettland",
        "LY": "Libyen",
        "MA": "Marokko",
        "MD": "Moldawien",
        "MG": "Madagaskar",
        "MH": "Marshall-Eilannen",
        "MK": "Makedonien",
        "MM": "Birma",
        "MN": "Mongolei",
        "MO": "Macao",
        "MP": "Nöördliche Marianen",
        "MR": "Mauretanien",
        "MV": "Malediven",
        "MX": "Mexiko",
        "MZ": "Mosambik",
        "NC": "Neekaledonien",
        "NF": "Norfolk",
        "NI": "Nikaragua",
        "NL": "Nedderlannen",
        "NO": "Norwegen",
        "NZ": "Neeseeland",
        "PF": "Franzöösch-Polynesien",
        "PG": "Papua-Neeguinea",
        "PH": "Philippinen",
        "PL": "Polen",
        "PM": "St. Pierre un Miquelon",
        "PN": "Pitcairn",
        "PS": "Palästinensische Rebeden",
        "QA": "Katar",
        "QO": "Büter Ozeanien",
        "RE": "Reunion",
        "RO": "Rumänien",
        "RS": "Serbien",
        "RU": "Russland",
        "RW": "Ruanda",
        "SA": "Saudi-Arabien",
        "SB": "Salomonen",
        "SC": "Seychellen",
        "SG": "Singapur",
        "SH": "St. Helena",
        "SI": "Slowenien",
        "SJ": "Svalbard un Jan Mayen",
        "SK": "Slowakei",
        "SR": "Surinam",
        "ST": "São Tomé un Príncipe",
        "SY": "Syrien",
        "SZ": "Swasiland",
        "TC": "Turks- un Caicosinseln",
        "TD": "Tschad",
        "TF": "Franzöösche Süüd- un Antarktisrebeden",
        "TJ": "Tadschikistan",
        "TL": "Oosttimor",
        "TN": "Tunesien",
        "TR": "Törkie",
        "TT": "Trinidad un Tobago",
        "TZ": "Tansania",
        "UM": "Amerikaansch-Ozeanien",
        "US": "USA",
        "UZ": "Usbekistan",
        "VA": "Vatikan",
        "VC": "St. Vincent un de Grenadinen",
        "VG": "Brietsche Jumfern-Eilannen",
        "VI": "Amerikaansche Jumfern-Eilannen",
        "WF": "Wallis un Futuna",
        "YE": "Jemen",
        "ZA": "Süüdafrika",
        "ZM": "Sambia",
        "ZW": "Simbabwe",
        "ZZ": "Unbekannte oder ungüllige Region"
    };
  }-*/;
}
