/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.jvm;

import java.util.EnumSet;
import java.util.Set;
import org.openjdk.tools.javac.jvm.Target;
import org.openjdk.tools.javac.main.Option;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.Options;

public enum Profile {
    COMPACT1("compact1", 1, Target.JDK1_8, Target.JDK1_9),
    COMPACT2("compact2", 2, Target.JDK1_8, Target.JDK1_9),
    COMPACT3("compact3", 3, Target.JDK1_8, Target.JDK1_9),
    DEFAULT{

        @Override
        public boolean isValid(Target target) {
            return true;
        }
    };

    private static final Context.Key<Profile> profileKey;
    public final String name;
    public final int value;
    final Set<Target> targets;

    public static Profile instance(Context context) {
        Profile profile = context.get(profileKey);
        if (profile == null) {
            Options options = Options.instance(context);
            String string = options.get(Option.PROFILE);
            if (string != null) {
                profile = Profile.lookup(string);
            }
            if (profile == null) {
                profile = DEFAULT;
            }
            context.put(profileKey, profile);
        }
        return profile;
    }

    private Profile() {
        this.name = null;
        this.value = Integer.MAX_VALUE;
        this.targets = null;
    }

    private Profile(String string2, int n2, Target target, Target ... targetArray) {
        this.name = string2;
        this.value = n2;
        this.targets = EnumSet.of(target, targetArray);
    }

    public static Profile lookup(String string) {
        for (Profile profile : Profile.values()) {
            if (!string.equals(profile.name)) continue;
            return profile;
        }
        return null;
    }

    public static Profile lookup(int n) {
        for (Profile profile : Profile.values()) {
            if (n != profile.value) continue;
            return profile;
        }
        return null;
    }

    public boolean isValid(Target target) {
        return this.targets.contains((Object)target);
    }

    static {
        profileKey = new Context.Key();
    }
}

