/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Input/output argument of a function or a stored procedure.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Argument extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Defaults to FIXED_TYPE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String argumentKind;

  /**
   * Set if argument_kind == FIXED_TYPE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private StandardSqlDataType dataType;

  /**
   * Optional. Whether the argument is an aggregate function parameter. Must be Unset for routine
   * types other than AGGREGATE_FUNCTION. For AGGREGATE_FUNCTION, if set to false, it is equivalent
   * to adding "NOT AGGREGATE" clause in DDL; Otherwise, it is equivalent to omitting "NOT
   * AGGREGATE" clause in DDL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isAggregate;

  /**
   * Optional. Specifies whether the argument is input or output. Can be set for procedures only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mode;

  /**
   * Optional. The name of this argument. Can be absent for function return argument.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Optional. Defaults to FIXED_TYPE.
   * @return value or {@code null} for none
   */
  public java.lang.String getArgumentKind() {
    return argumentKind;
  }

  /**
   * Optional. Defaults to FIXED_TYPE.
   * @param argumentKind argumentKind or {@code null} for none
   */
  public Argument setArgumentKind(java.lang.String argumentKind) {
    this.argumentKind = argumentKind;
    return this;
  }

  /**
   * Set if argument_kind == FIXED_TYPE.
   * @return value or {@code null} for none
   */
  public StandardSqlDataType getDataType() {
    return dataType;
  }

  /**
   * Set if argument_kind == FIXED_TYPE.
   * @param dataType dataType or {@code null} for none
   */
  public Argument setDataType(StandardSqlDataType dataType) {
    this.dataType = dataType;
    return this;
  }

  /**
   * Optional. Whether the argument is an aggregate function parameter. Must be Unset for routine
   * types other than AGGREGATE_FUNCTION. For AGGREGATE_FUNCTION, if set to false, it is equivalent
   * to adding "NOT AGGREGATE" clause in DDL; Otherwise, it is equivalent to omitting "NOT
   * AGGREGATE" clause in DDL.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsAggregate() {
    return isAggregate;
  }

  /**
   * Optional. Whether the argument is an aggregate function parameter. Must be Unset for routine
   * types other than AGGREGATE_FUNCTION. For AGGREGATE_FUNCTION, if set to false, it is equivalent
   * to adding "NOT AGGREGATE" clause in DDL; Otherwise, it is equivalent to omitting "NOT
   * AGGREGATE" clause in DDL.
   * @param isAggregate isAggregate or {@code null} for none
   */
  public Argument setIsAggregate(java.lang.Boolean isAggregate) {
    this.isAggregate = isAggregate;
    return this;
  }

  /**
   * Optional. Specifies whether the argument is input or output. Can be set for procedures only.
   * @return value or {@code null} for none
   */
  public java.lang.String getMode() {
    return mode;
  }

  /**
   * Optional. Specifies whether the argument is input or output. Can be set for procedures only.
   * @param mode mode or {@code null} for none
   */
  public Argument setMode(java.lang.String mode) {
    this.mode = mode;
    return this;
  }

  /**
   * Optional. The name of this argument. Can be absent for function return argument.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Optional. The name of this argument. Can be absent for function return argument.
   * @param name name or {@code null} for none
   */
  public Argument setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public Argument set(String fieldName, Object value) {
    return (Argument) super.set(fieldName, value);
  }

  @Override
  public Argument clone() {
    return (Argument) super.clone();
  }

}
