/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2018-10-25 at 08:23:19 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * The data part of the report.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Analytics Reporting API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReportData extends com.google.api.client.json.GenericJson {

  /**
   * The last time the data in the report was refreshed. All the hits received before this timestamp
   * are included in the calculation of the report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String dataLastRefreshed;

  /**
   * Indicates if response to this request is golden or not. Data is golden when the exact same
   * request will not produce any new results if asked at a later point in time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isDataGolden;

  /**
   * Minimum and maximum values seen over all matching rows. These are both empty when
   * `hideValueRanges` in the request is false, or when rowCount is zero.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DateRangeValues> maximums;

  /**
   * Minimum and maximum values seen over all matching rows. These are both empty when
   * `hideValueRanges` in the request is false, or when rowCount is zero.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DateRangeValues> minimums;

  /**
   * Total number of matching rows for this query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer rowCount;

  /**
   * There's one ReportRow for every unique combination of dimensions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ReportRow> rows;

  /**
   * If the results are [sampled](https://support.google.com/analytics/answer/2637192), this returns
   * the total number of samples read, one entry per date range. If the results are not sampled this
   * field will not be defined. See [developer
   * guide](/analytics/devguides/reporting/core/v4/basics#sampling) for details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> samplesReadCounts;

  /**
   * If the results are [sampled](https://support.google.com/analytics/answer/2637192), this returns
   * the total number of samples present, one entry per date range. If the results are not sampled
   * this field will not be defined. See [developer
   * guide](/analytics/devguides/reporting/core/v4/basics#sampling) for details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> samplingSpaceSizes;

  /**
   * For each requested date range, for the set of all rows that match the query, every requested
   * value format gets a total. The total for a value format is computed by first totaling the
   * metrics mentioned in the value format and then evaluating the value format as a scalar
   * expression.  E.g., The "totals" for `3 / (ga:sessions + 2)` we compute `3 / ((sum of all
   * relevant ga:sessions) + 2)`. Totals are computed before pagination.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DateRangeValues> totals;

  /**
   * The last time the data in the report was refreshed. All the hits received before this timestamp
   * are included in the calculation of the report.
   * @return value or {@code null} for none
   */
  public String getDataLastRefreshed() {
    return dataLastRefreshed;
  }

  /**
   * The last time the data in the report was refreshed. All the hits received before this timestamp
   * are included in the calculation of the report.
   * @param dataLastRefreshed dataLastRefreshed or {@code null} for none
   */
  public ReportData setDataLastRefreshed(String dataLastRefreshed) {
    this.dataLastRefreshed = dataLastRefreshed;
    return this;
  }

  /**
   * Indicates if response to this request is golden or not. Data is golden when the exact same
   * request will not produce any new results if asked at a later point in time.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsDataGolden() {
    return isDataGolden;
  }

  /**
   * Indicates if response to this request is golden or not. Data is golden when the exact same
   * request will not produce any new results if asked at a later point in time.
   * @param isDataGolden isDataGolden or {@code null} for none
   */
  public ReportData setIsDataGolden(java.lang.Boolean isDataGolden) {
    this.isDataGolden = isDataGolden;
    return this;
  }

  /**
   * Minimum and maximum values seen over all matching rows. These are both empty when
   * `hideValueRanges` in the request is false, or when rowCount is zero.
   * @return value or {@code null} for none
   */
  public java.util.List<DateRangeValues> getMaximums() {
    return maximums;
  }

  /**
   * Minimum and maximum values seen over all matching rows. These are both empty when
   * `hideValueRanges` in the request is false, or when rowCount is zero.
   * @param maximums maximums or {@code null} for none
   */
  public ReportData setMaximums(java.util.List<DateRangeValues> maximums) {
    this.maximums = maximums;
    return this;
  }

  /**
   * Minimum and maximum values seen over all matching rows. These are both empty when
   * `hideValueRanges` in the request is false, or when rowCount is zero.
   * @return value or {@code null} for none
   */
  public java.util.List<DateRangeValues> getMinimums() {
    return minimums;
  }

  /**
   * Minimum and maximum values seen over all matching rows. These are both empty when
   * `hideValueRanges` in the request is false, or when rowCount is zero.
   * @param minimums minimums or {@code null} for none
   */
  public ReportData setMinimums(java.util.List<DateRangeValues> minimums) {
    this.minimums = minimums;
    return this;
  }

  /**
   * Total number of matching rows for this query.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getRowCount() {
    return rowCount;
  }

  /**
   * Total number of matching rows for this query.
   * @param rowCount rowCount or {@code null} for none
   */
  public ReportData setRowCount(java.lang.Integer rowCount) {
    this.rowCount = rowCount;
    return this;
  }

  /**
   * There's one ReportRow for every unique combination of dimensions.
   * @return value or {@code null} for none
   */
  public java.util.List<ReportRow> getRows() {
    return rows;
  }

  /**
   * There's one ReportRow for every unique combination of dimensions.
   * @param rows rows or {@code null} for none
   */
  public ReportData setRows(java.util.List<ReportRow> rows) {
    this.rows = rows;
    return this;
  }

  /**
   * If the results are [sampled](https://support.google.com/analytics/answer/2637192), this returns
   * the total number of samples read, one entry per date range. If the results are not sampled this
   * field will not be defined. See [developer
   * guide](/analytics/devguides/reporting/core/v4/basics#sampling) for details.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getSamplesReadCounts() {
    return samplesReadCounts;
  }

  /**
   * If the results are [sampled](https://support.google.com/analytics/answer/2637192), this returns
   * the total number of samples read, one entry per date range. If the results are not sampled this
   * field will not be defined. See [developer
   * guide](/analytics/devguides/reporting/core/v4/basics#sampling) for details.
   * @param samplesReadCounts samplesReadCounts or {@code null} for none
   */
  public ReportData setSamplesReadCounts(java.util.List<java.lang.Long> samplesReadCounts) {
    this.samplesReadCounts = samplesReadCounts;
    return this;
  }

  /**
   * If the results are [sampled](https://support.google.com/analytics/answer/2637192), this returns
   * the total number of samples present, one entry per date range. If the results are not sampled
   * this field will not be defined. See [developer
   * guide](/analytics/devguides/reporting/core/v4/basics#sampling) for details.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getSamplingSpaceSizes() {
    return samplingSpaceSizes;
  }

  /**
   * If the results are [sampled](https://support.google.com/analytics/answer/2637192), this returns
   * the total number of samples present, one entry per date range. If the results are not sampled
   * this field will not be defined. See [developer
   * guide](/analytics/devguides/reporting/core/v4/basics#sampling) for details.
   * @param samplingSpaceSizes samplingSpaceSizes or {@code null} for none
   */
  public ReportData setSamplingSpaceSizes(java.util.List<java.lang.Long> samplingSpaceSizes) {
    this.samplingSpaceSizes = samplingSpaceSizes;
    return this;
  }

  /**
   * For each requested date range, for the set of all rows that match the query, every requested
   * value format gets a total. The total for a value format is computed by first totaling the
   * metrics mentioned in the value format and then evaluating the value format as a scalar
   * expression.  E.g., The "totals" for `3 / (ga:sessions + 2)` we compute `3 / ((sum of all
   * relevant ga:sessions) + 2)`. Totals are computed before pagination.
   * @return value or {@code null} for none
   */
  public java.util.List<DateRangeValues> getTotals() {
    return totals;
  }

  /**
   * For each requested date range, for the set of all rows that match the query, every requested
   * value format gets a total. The total for a value format is computed by first totaling the
   * metrics mentioned in the value format and then evaluating the value format as a scalar
   * expression.  E.g., The "totals" for `3 / (ga:sessions + 2)` we compute `3 / ((sum of all
   * relevant ga:sessions) + 2)`. Totals are computed before pagination.
   * @param totals totals or {@code null} for none
   */
  public ReportData setTotals(java.util.List<DateRangeValues> totals) {
    this.totals = totals;
    return this;
  }

  @Override
  public ReportData set(String fieldName, Object value) {
    return (ReportData) super.set(fieldName, value);
  }

  @Override
  public ReportData clone() {
    return (ReportData) super.clone();
  }

}
