/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.EscapedSelector;
import com.github.sommeri.less4j.core.ast.KeyframesBody;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.NestedSelectorAppender;
import com.github.sommeri.less4j.core.ast.PseudoClass;
import com.github.sommeri.less4j.core.ast.ReusableStructureName;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.ArrayList;
import java.util.Set;

public class LessAstValidator {
    private final ProblemsHandler problemsHandler;
    private final ASTManipulator manipulator = new ASTManipulator();

    public LessAstValidator(ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
    }

    public void validate(ASTCssNode node) {
        switch (node.getType()) {
            case RULE_SET: {
                this.checkEmptySelector((RuleSet)node);
                this.checkTopLevelNested((RuleSet)node);
                break;
            }
            case MIXIN_REFERENCE: {
                this.checkInterpolatedNamespaceName((MixinReference)node);
                this.checkExtendedNamespaceName((MixinReference)node);
                this.checkInterpolatedMixinName((MixinReference)node);
                break;
            }
            case PSEUDO_CLASS: {
                this.checkDeprecatedParameterType((PseudoClass)node);
                break;
            }
            case ESCAPED_SELECTOR: {
                this.problemsHandler.deprecatedSyntaxEscapedSelector((EscapedSelector)node);
                break;
            }
            case KEYFRAMES_BODY: {
                this.checkForDisallowedMembers((KeyframesBody)node);
            }
        }
        ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
        for (ASTCssNode aSTCssNode : childs) {
            this.validate(aSTCssNode);
        }
    }

    private void checkTopLevelNested(RuleSet node) {
        if (node.getParent().getType() != ASTCssNodeType.STYLE_SHEET) {
            return;
        }
        for (Selector selector : node.getSelectors()) {
            NestedSelectorAppender appender = selector.findFirstAppender();
            if (appender == null) continue;
            this.problemsHandler.nestedAppenderOnTopLevel(appender);
            this.manipulator.removeFromClosestBody(node);
            return;
        }
    }

    private void checkForDisallowedMembers(KeyframesBody keyframes) {
        Set<ASTCssNodeType> supportedMembers = keyframes.getSupportedMembers();
        for (ASTCssNode member : keyframes.getBody()) {
            ASTCssNodeType type = member.getType();
            if (supportedMembers.contains((Object)type)) continue;
            this.problemsHandler.unsupportedKeyframesMember(member);
        }
    }

    private void checkInterpolatedMixinName(MixinReference reference) {
        if (reference.hasInterpolatedFinalName()) {
            this.problemsHandler.interpolatedMixinReferenceSelector(reference);
            this.manipulator.removeFromClosestBody(reference);
        }
    }

    private void checkInterpolatedNamespaceName(MixinReference reference) {
        if (reference.hasInterpolatedNameChain()) {
            this.problemsHandler.interpolatedNamespaceReferenceSelector(reference);
            this.manipulator.removeFromClosestBody(reference);
        }
    }

    private void checkExtendedNamespaceName(MixinReference reference) {
        for (ReusableStructureName name : reference.getNameChain()) {
            if (!name.hasMultipleParts()) continue;
            this.problemsHandler.extendedNamespaceReferenceSelector(reference);
            this.manipulator.removeFromClosestBody(reference);
            return;
        }
    }

    private void checkDeprecatedParameterType(PseudoClass pseudo) {
        ASTCssNode parameter = pseudo.getParameter();
        if (parameter != null && parameter.getType() == ASTCssNodeType.VARIABLE) {
            this.problemsHandler.variableAsPseudoclassParameter(pseudo);
        }
    }

    private void checkEmptySelector(RuleSet ruleSet) {
        if (ruleSet.getSelectors() == null || ruleSet.getSelectors().isEmpty()) {
            this.problemsHandler.rulesetWithoutSelector(ruleSet);
        }
    }
}

