/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.problems.BugHappened;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.List;
import java.util.Set;

public class AstLogic {
    public static boolean hasOwnScope(ASTCssNode node) {
        return node instanceof Body;
    }

    public static void validateCssBodyCompatibility(ASTCssNode reference, List<ASTCssNode> members, ProblemsHandler problemsHandler) {
        ASTCssNode parent = reference.getParent();
        if (!(parent instanceof Body)) {
            throw new BugHappened("Parent is not a body instance. " + parent, parent);
        }
        Set<ASTCssNodeType> supportedMembers = ((Body)parent).getSupportedMembers();
        for (ASTCssNode member : members) {
            if (supportedMembers.contains((Object)member.getType())) continue;
            problemsHandler.wrongMemberBroughtIntoBody(reference, member, parent);
        }
    }
}

