/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.expressions.ConversionUtils;
import com.github.sommeri.less4j.core.compiler.expressions.Function;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;

class Percentage
implements Function {
    private final ConversionUtils utils = new ConversionUtils();

    Percentage() {
    }

    @Override
    public Expression evaluate(Expression parameter, ProblemsHandler problemsHandler) {
        if (parameter.getType() == ASTCssNodeType.NUMBER) {
            return this.evaluate((NumberExpression)parameter);
        }
        if (parameter.getType() == ASTCssNodeType.STRING_EXPRESSION) {
            return this.evaluate((CssString)parameter, problemsHandler);
        }
        problemsHandler.mathFunctionParameterNotANumberWarn("percentage", parameter);
        return this.createResult(Double.NaN, parameter.getUnderlyingStructure());
    }

    private Expression evaluate(CssString parameter, ProblemsHandler problemsHandler) {
        Double value = this.utils.toDouble(parameter);
        if (value.isNaN()) {
            problemsHandler.mathFunctionParameterNotANumberWarn("percentage", parameter);
        }
        return this.createResult(value, parameter.getUnderlyingStructure());
    }

    private Expression evaluate(NumberExpression parameter) {
        return this.createResult(parameter.getValueAsDouble(), parameter.getUnderlyingStructure());
    }

    private Expression createResult(Double originalValue, HiddenTokenAwareTree parentToken) {
        Double value = originalValue * 100.0;
        return new NumberExpression(parentToken, value, "%", null, NumberExpression.Dimension.PERCENTAGE);
    }
}

