/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ComparisonExpression;
import com.github.sommeri.less4j.core.ast.ComparisonExpressionOperator;
import com.github.sommeri.less4j.core.ast.ComposedExpression;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.ExpressionOperator;
import com.github.sommeri.less4j.core.ast.FaultyExpression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.Guard;
import com.github.sommeri.less4j.core.ast.GuardCondition;
import com.github.sommeri.less4j.core.ast.IdentifierExpression;
import com.github.sommeri.less4j.core.ast.IndirectVariable;
import com.github.sommeri.less4j.core.ast.NamedExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.ast.ParenthesesExpression;
import com.github.sommeri.less4j.core.ast.SignedExpression;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.compiler.expressions.ArithmeticCalculator;
import com.github.sommeri.less4j.core.compiler.expressions.ColorsCalculator;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionComparator;
import com.github.sommeri.less4j.core.compiler.expressions.GuardsComparator;
import com.github.sommeri.less4j.core.compiler.expressions.ListCalculator;
import com.github.sommeri.less4j.core.compiler.expressions.MathFunctions;
import com.github.sommeri.less4j.core.compiler.expressions.NullScope;
import com.github.sommeri.less4j.core.compiler.scopes.Scope;
import com.github.sommeri.less4j.core.problems.BugHappened;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ExpressionEvaluator {
    private final Scope scope;
    private final ProblemsHandler problemsHandler;
    private ArithmeticCalculator arithmeticCalculator;
    private ListCalculator listCalculator = new ListCalculator();
    private ColorsCalculator colorsCalculator;
    private ExpressionComparator comparator = new GuardsComparator();
    private MathFunctions mathFunctions;

    public ExpressionEvaluator(ProblemsHandler problemsHandler) {
        this(new NullScope(), problemsHandler);
    }

    public ExpressionEvaluator(Scope scope, ProblemsHandler problemsHandler) {
        this.scope = scope == null ? new NullScope() : scope;
        this.problemsHandler = problemsHandler;
        this.arithmeticCalculator = new ArithmeticCalculator(problemsHandler);
        this.colorsCalculator = new ColorsCalculator(problemsHandler);
        this.mathFunctions = new MathFunctions(problemsHandler);
    }

    public Expression joinAll(List<Expression> allArguments, ASTCssNode parent) {
        if (allArguments.isEmpty()) {
            return new IdentifierExpression(parent.getUnderlyingStructure(), "");
        }
        Iterator<Expression> iterator = allArguments.iterator();
        Expression result = iterator.next();
        while (iterator.hasNext()) {
            result = new ComposedExpression(parent.getUnderlyingStructure(), result, new ExpressionOperator(parent.getUnderlyingStructure()), iterator.next());
        }
        return result;
    }

    public List<Expression> evaluateAll(List<Expression> expressions) {
        ArrayList<Expression> values = new ArrayList<Expression>();
        for (Expression argument : expressions) {
            values.add(this.evaluate(argument));
        }
        return values;
    }

    public Expression evaluate(Variable input) {
        Expression value = this.scope.getValue(input);
        if (value == null) {
            this.problemsHandler.undefinedVariable(input);
            return new FaultyExpression(input);
        }
        return this.evaluate(value);
    }

    public Expression evaluateIfPresent(Variable input) {
        Expression value = this.scope.getValue(input);
        if (value == null) {
            return null;
        }
        return this.evaluate(value);
    }

    public Expression evaluate(IndirectVariable input) {
        Expression value = this.scope.getValue(input);
        if (!(value instanceof CssString)) {
            this.problemsHandler.nonStringIndirection(input);
            return new FaultyExpression(input);
        }
        CssString realName = (CssString)value;
        String realVariableName = "@" + realName.getValue();
        value = this.scope.getValue(realVariableName);
        if (value == null) {
            this.problemsHandler.undefinedVariable(realVariableName, realName);
            return new FaultyExpression(realName.getUnderlyingStructure());
        }
        return this.evaluate(value);
    }

    public Expression evaluate(Expression input) {
        switch (input.getType()) {
            case FUNCTION: {
                return this.evaluate((FunctionExpression)input);
            }
            case COMPOSED_EXPRESSION: {
                return this.evaluate((ComposedExpression)input);
            }
            case INDIRECT_VARIABLE: {
                return this.evaluate((IndirectVariable)input);
            }
            case VARIABLE: {
                return this.evaluate((Variable)input);
            }
            case PARENTHESES_EXPRESSION: {
                return this.evaluate(((ParenthesesExpression)input).getEnclosedExpression());
            }
            case SIGNED_EXPRESSION: {
                return this.evaluate((SignedExpression)input);
            }
            case NAMED_EXPRESSION: {
                return ((NamedExpression)input).getExpression();
            }
            case STRING_EXPRESSION: 
            case IDENTIFIER_EXPRESSION: 
            case COLOR_EXPRESSION: 
            case NUMBER: 
            case FAULTY_EXPRESSION: 
            case ESCAPED_VALUE: {
                return input;
            }
        }
        throw new BugHappened("Unknown expression type", (ASTCssNode)input);
    }

    private boolean booleanEvalueate(Expression input) {
        if (input.getType() == ASTCssNodeType.COMPARISON_EXPRESSION) {
            return this.booleanEvalueate((ComparisonExpression)input);
        }
        Expression value = this.evaluate(input);
        if (value.getType() != ASTCssNodeType.IDENTIFIER_EXPRESSION) {
            return false;
        }
        IdentifierExpression identifier = (IdentifierExpression)value;
        return "true".equals(identifier.getValue());
    }

    public boolean booleanEvalueate(ComparisonExpression input) {
        Expression leftE = this.evaluate(input.getLeft());
        Expression rightE = this.evaluate(input.getRight());
        ComparisonExpressionOperator operator = input.getOperator();
        if (operator.getOperator() == ComparisonExpressionOperator.Operator.OPEQ) {
            return this.comparator.equal(leftE, rightE);
        }
        if (leftE.getType() != ASTCssNodeType.NUMBER) {
            this.problemsHandler.incompatibleComparisonOperand(leftE, operator);
            return false;
        }
        if (rightE.getType() != ASTCssNodeType.NUMBER) {
            this.problemsHandler.incompatibleComparisonOperand(rightE, operator);
            return false;
        }
        return this.compareNumbers((NumberExpression)leftE, (NumberExpression)rightE, operator);
    }

    private boolean compareNumbers(NumberExpression leftE, NumberExpression rightE, ComparisonExpressionOperator operator) {
        Double left = leftE.getValueAsDouble();
        Double right = rightE.getValueAsDouble();
        switch (operator.getOperator()) {
            case GREATER: {
                return left.compareTo(right) > 0;
            }
            case GREATER_OR_EQUAL: {
                return left.compareTo(right) >= 0;
            }
            case LOWER_OR_EQUAL: {
                return left.compareTo(right) <= 0;
            }
            case LOWER: {
                return left.compareTo(right) < 0;
            }
        }
        throw new BugHappened("Unexpected comparison operator", (ASTCssNode)operator);
    }

    public Expression evaluate(FunctionExpression input) {
        return this.mathFunctions.evaluate(input, this.evaluate(input.getParameter()));
    }

    public Expression evaluate(SignedExpression input) {
        Expression evaluate = this.evaluate(input.getExpression());
        if (evaluate instanceof NumberExpression) {
            NumberExpression negation = ((NumberExpression)evaluate).clone();
            if (input.getSign() == SignedExpression.Sign.PLUS) {
                return negation;
            }
            negation.negate();
            negation.setOriginalString(null);
            negation.setExpliciteSign(false);
            return negation;
        }
        this.problemsHandler.nonNumberNegation(input);
        return new FaultyExpression(input);
    }

    public Expression evaluate(ComposedExpression input) {
        Expression leftValue = this.evaluate(input.getLeft());
        Expression rightValue = this.evaluate(input.getRight());
        if (this.arithmeticCalculator.accepts(input.getOperator(), leftValue, rightValue)) {
            return this.arithmeticCalculator.evalute(input, leftValue, rightValue);
        }
        if (this.colorsCalculator.accepts(input.getOperator(), leftValue, rightValue)) {
            return this.colorsCalculator.evalute(input, leftValue, rightValue);
        }
        if (this.listCalculator.accepts(input.getOperator())) {
            return this.listCalculator.evalute(input, leftValue, rightValue);
        }
        this.problemsHandler.cannotEvaluate(input);
        return new FaultyExpression(input);
    }

    public boolean evaluate(List<Guard> guards) {
        if (guards == null || guards.isEmpty()) {
            return true;
        }
        for (Guard guard : guards) {
            if (!this.evaluate(guard)) continue;
            return true;
        }
        return false;
    }

    public boolean evaluate(Guard guard) {
        List<GuardCondition> conditions = guard.getConditions();
        if (conditions == null || conditions.isEmpty()) {
            return true;
        }
        for (GuardCondition condition : conditions) {
            if (this.evaluate(condition)) continue;
            return false;
        }
        return true;
    }

    private boolean evaluate(GuardCondition guardCondition) {
        Expression condition = guardCondition.getCondition();
        boolean conditionStatus = this.booleanEvalueate(condition);
        return guardCondition.isNegated() ? !conditionStatus : conditionStatus;
    }

    public boolean isRatioExpression(Expression expression) {
        if (!(expression instanceof ComposedExpression)) {
            return false;
        }
        ComposedExpression composed = (ComposedExpression)expression;
        if (composed.getOperator().getOperator() != ExpressionOperator.Operator.SOLIDUS) {
            return false;
        }
        if (composed.getLeft().getType() != ASTCssNodeType.NUMBER) {
            return false;
        }
        return composed.getRight().getType() == ASTCssNodeType.NUMBER;
    }
}

