/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ElementSubsequent;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.ast.RuleSetsBody;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.ast.SelectorPart;
import com.github.sommeri.less4j.core.ast.SimpleSelector;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.BugHappened;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.List;

public class RuleSet
extends ASTCssNode {
    private List<Selector> selectors = new ArrayList<Selector>();
    private RuleSetsBody body;

    public RuleSet(HiddenTokenAwareTree token) {
        super(token);
    }

    public RuleSet(HiddenTokenAwareTree token, RuleSetsBody body, List<Selector> selectors) {
        super(token);
        this.body = body;
        this.addSelectors(selectors);
        this.configureParentToAllChilds();
    }

    public List<Selector> getSelectors() {
        return this.selectors;
    }

    public RuleSetsBody getBody() {
        return this.body;
    }

    public boolean hasEmptyBody() {
        return this.body == null ? true : this.body.isEmpty();
    }

    public void setBody(RuleSetsBody body) {
        this.body = body;
    }

    public boolean isReusableStructure() {
        return this.hasSingleClassSelector() || this.hasSingleIdSelector();
    }

    private boolean hasSingleClassSelector() {
        if (!this.hasSimpleSelecor()) {
            return false;
        }
        SelectorPart selector = this.selectors.get(0).getHead();
        return selector.isSingleClassSelector();
    }

    private boolean hasSingleIdSelector() {
        if (!this.hasSimpleSelecor()) {
            return false;
        }
        SelectorPart selector = this.selectors.get(0).getHead();
        return selector.isSingleIdSelector();
    }

    private boolean hasSimpleSelecor() {
        if (this.selectors == null || this.selectors.size() != 1) {
            return false;
        }
        Selector first = this.selectors.get(0);
        return !first.isCombined();
    }

    public ReusableStructure convertToReusableStructure() {
        if (!this.isReusableStructure()) {
            throw new BugHappened("Caller is supposed to check for this.", (ASTCssNode)this);
        }
        SimpleSelector head = (SimpleSelector)this.selectors.get(0).getHead();
        ElementSubsequent className = head.getSubsequent().get(0);
        ReusableStructure reusable = new ReusableStructure(this.getUnderlyingStructure(), className.clone());
        reusable.setBody(this.getBody().clone());
        reusable.configureParentToAllChilds();
        return reusable;
    }

    public String extractReusableStructureName() {
        if (!this.isReusableStructure()) {
            throw new BugHappened("Caller is supposed to check for this.", (ASTCssNode)this);
        }
        SimpleSelector selector = (SimpleSelector)this.selectors.get(0).getHead();
        ElementSubsequent name = selector.getSubsequent().get(0);
        return name.getFullName();
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        List<ASTCssNode> result = ArraysUtils.asNonNullList(this.body);
        result.addAll(0, this.selectors);
        return result;
    }

    public void addSelectors(List<Selector> selectors) {
        this.selectors.addAll(selectors);
    }

    public void addSelector(Selector selector) {
        this.selectors.add(selector);
    }

    public void replaceSelectors(List<Selector> result) {
        for (Selector oldSelector : this.selectors) {
            oldSelector.setParent(null);
        }
        this.selectors = new ArrayList<Selector>();
        this.selectors.addAll(result);
    }

    @Override
    public RuleSet clone() {
        RuleSet result = (RuleSet)super.clone();
        result.body = this.body == null ? null : this.body.clone();
        result.selectors = ArraysUtils.deeplyClonedList(this.selectors);
        result.configureParentToAllChilds();
        return result;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.RULE_SET;
    }
}

