/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.List;

public class NamespaceReference
extends ASTCssNode {
    private List<String> nameChain = new ArrayList<String>();
    private MixinReference finalReference;

    public NamespaceReference(HiddenTokenAwareTree underlyingStructure) {
        super(underlyingStructure);
    }

    public List<String> getNameChain() {
        return this.nameChain;
    }

    public void setNameChain(List<String> nameChain) {
        this.nameChain = nameChain;
    }

    public MixinReference getFinalReference() {
        return this.finalReference;
    }

    public void setFinalReference(MixinReference finalReference) {
        this.finalReference = finalReference;
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.finalReference);
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.NAMESPACE_REFERENCE;
    }

    @Override
    public NamespaceReference clone() {
        NamespaceReference result = (NamespaceReference)super.clone();
        result.nameChain = this.nameChain == null ? null : new ArrayList<String>(this.nameChain);
        result.finalReference = this.finalReference == null ? null : this.finalReference.clone();
        return result;
    }

    public void addName(String text) {
        this.nameChain.add(text);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String str : this.nameChain) {
            builder.append(str).append(" > ");
        }
        builder.append(this.getFinalReference().toString());
        return builder.toString();
    }
}

