/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ElementSubsequent;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.ast.VariableDeclaration;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MixinReference
extends ASTCssNode {
    private ElementSubsequent selector;
    private List<Expression> positionalParameters = new ArrayList<Expression>();
    private Map<String, Expression> namedParameters = new HashMap<String, Expression>();
    private boolean important = false;

    public MixinReference(HiddenTokenAwareTree token) {
        super(token);
    }

    public ElementSubsequent getSelector() {
        return this.selector;
    }

    public String getName() {
        return this.getSelector().getFullName();
    }

    public void setSelector(ElementSubsequent selector) {
        this.selector = selector;
    }

    public List<Expression> getPositionalParameters() {
        return this.positionalParameters;
    }

    public int getNumberOfDeclaredParameters() {
        return this.positionalParameters.size() + this.namedParameters.size();
    }

    public boolean hasNamedParameter(Variable variable) {
        return this.namedParameters.containsKey(variable.getName());
    }

    public Expression getNamedParameter(Variable variable) {
        return this.namedParameters.get(variable.getName());
    }

    public boolean hasPositionalParameter(int parameterNumber) {
        return this.getPositionalParameters().size() > parameterNumber;
    }

    public Expression getPositionalParameter(int parameterNumber) {
        return this.getPositionalParameters().get(parameterNumber);
    }

    public void addPositionalParameter(Expression parameter) {
        this.positionalParameters.add(parameter);
    }

    public void addNamedParameter(VariableDeclaration parameter) {
        this.namedParameters.put(parameter.getVariable().getName(), parameter.getValue());
    }

    public boolean isImportant() {
        return this.important;
    }

    public void setImportant(boolean important) {
        this.important = important;
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        List<ASTCssNode> result = ArraysUtils.asNonNullList(this.selector);
        result.addAll(this.positionalParameters);
        return result;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.MIXIN_REFERENCE;
    }

    public String toString() {
        return "MixinReference[" + this.getName() + "]";
    }

    @Override
    public MixinReference clone() {
        MixinReference result = (MixinReference)super.clone();
        result.selector = this.selector == null ? null : this.selector.clone();
        result.positionalParameters = ArraysUtils.deeplyClonedList(this.positionalParameters);
        result.configureParentToAllChilds();
        return result;
    }

    public List<Expression> getAllPositionalArgumentsFrom(int startIndx) {
        if (this.hasPositionalParameter(startIndx)) {
            return this.positionalParameters.subList(startIndx, this.positionalParameters.size());
        }
        return Collections.emptyList();
    }
}

