/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Comment;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import java.util.ArrayList;
import java.util.List;

public abstract class ASTCssNode
implements Cloneable {
    private ASTCssNode parent;
    private HiddenTokenAwareTree underlyingStructure;
    private List<Comment> openingComments = new ArrayList<Comment>();
    private List<Comment> orphanComments = new ArrayList<Comment>();
    private List<Comment> trailingComments = new ArrayList<Comment>();

    public ASTCssNode(HiddenTokenAwareTree underlyingStructure) {
        this.underlyingStructure = underlyingStructure;
        if (underlyingStructure == null) {
            throw new IllegalArgumentException("Underlying can not be null. It is used for error reporting, so place there the closest token possible.");
        }
    }

    public abstract List<? extends ASTCssNode> getChilds();

    public ASTCssNode getParent() {
        return this.parent;
    }

    public void setParent(ASTCssNode parent) {
        this.parent = parent;
    }

    public HiddenTokenAwareTree getUnderlyingStructure() {
        return this.underlyingStructure;
    }

    public void setUnderlyingStructure(HiddenTokenAwareTree underlyingStructure) {
        this.underlyingStructure = underlyingStructure;
    }

    public List<Comment> getTrailingComments() {
        return this.trailingComments;
    }

    public void setTrailingComments(List<Comment> trailingComments) {
        this.trailingComments = trailingComments;
    }

    public void addTrailingComments(List<Comment> comments) {
        this.trailingComments.addAll(comments);
    }

    public List<Comment> getOpeningComments() {
        return this.openingComments;
    }

    public void setOpeningComments(List<Comment> openingComments) {
        this.openingComments = openingComments;
    }

    public void addOpeningComments(List<Comment> openingComments) {
        this.openingComments.addAll(openingComments);
    }

    public List<Comment> getOrphanComments() {
        return this.orphanComments;
    }

    public void setOrphanComments(List<Comment> orphanComments) {
        this.orphanComments = orphanComments;
    }

    public abstract ASTCssNodeType getType();

    public int getSourceLine() {
        return this.getUnderlyingStructure() == null ? -1 : this.getUnderlyingStructure().getLine();
    }

    public int getCharPositionInSourceLine() {
        return this.getUnderlyingStructure() == null ? -1 : this.getUnderlyingStructure().getCharPositionInLine() + 1;
    }

    public ASTCssNode clone() {
        try {
            ASTCssNode clone = (ASTCssNode)super.clone();
            clone.setOpeningComments(new ArrayList<Comment>(this.getOpeningComments()));
            clone.setOrphanComments(new ArrayList<Comment>(this.getOrphanComments()));
            clone.setTrailingComments(new ArrayList<Comment>(this.getTrailingComments()));
            clone.setParent(null);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("This is a bug - please submit issue with this stack trace and an input.");
        }
    }

    public void configureParentToAllChilds() {
        List<? extends ASTCssNode> childs = this.getChilds();
        for (ASTCssNode aSTCssNode : childs) {
            aSTCssNode.setParent(this);
        }
    }
}

