/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;

public abstract class AbstractVariableDeclaration
extends ASTCssNode {
    private Variable variable;
    private Expression value;

    public AbstractVariableDeclaration(AbstractVariableDeclaration copy) {
        this(copy.getUnderlyingStructure(), copy.getVariable(), copy.getValue());
    }

    public AbstractVariableDeclaration(HiddenTokenAwareTree underlyingStructure, Variable variable, Expression value) {
        super(underlyingStructure);
        this.variable = variable;
        this.value = value;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public void setVariable(Variable variable) {
        this.variable = variable;
    }

    public Expression getValue() {
        return this.value;
    }

    public void setValue(Expression value) {
        this.value = value;
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.variable, this.value);
    }

    public String toString() {
        return "" + this.variable + ": " + this.value;
    }

    @Override
    public AbstractVariableDeclaration clone() {
        AbstractVariableDeclaration clone = (AbstractVariableDeclaration)super.clone();
        clone.variable = this.variable == null ? null : this.variable.clone();
        clone.value = this.value == null ? null : this.value.clone();
        clone.configureParentToAllChilds();
        return clone;
    }
}

